/*****************************************************************************
 * gyachi_notebook.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2008, Greg Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

/* gyachi_notebook consolidates core notebook functionality.
 * specifically, DnD of the tabs.
 */

#ifndef _GYACHI_NOTEBOOK_H_
#define _GYACHI_NOTEBOOK_H_

typedef struct _gyachi_notebook_interface {
	GtkWidget *window;
	GtkWidget *notebook;
	int       has_focus;	/* only used by pmnotebook */

	/* DnD stuff -- liberally borrowed from gnome-terminal */
	gulong   motion_notify_handler_id;
	gulong   grab_notify_handler_id;
	gulong   toplevel_grab_broken_handler_id;
	gulong   toplevel_motion_notify_handler_id;
	gulong   toplevel_button_release_handler_id;
	gint     x_start, y_start;
	gboolean drag_in_progress;
} GYACHI_NOTEBOOK_INTERFACE;

extern GSList *gyachi_notebooks;

GYACHI_NOTEBOOK_INTERFACE *gyachi_notebook_new(GtkWidget *window);

typedef struct pm_session PM_SESSION;

#endif /* #ifndef _GYACHI_NOTEBOOK_H_ */
