CHANGELOG for 7.4.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 7.4 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v7.4.0...v7.4.1

* 7.4.0-BETA2 (2025-11-02)

 * feature #62270 [Lock][DynamoDB] Allow symfony/lock 8.0 (DavidPrevot)
 * bug #62267 [Config] Use the empty string instead of null as an array offset (santysisi)
 * feature #62230 [Messenger] Support signing messages per handler (nicolas-grekas)
 * bug #62246 [HttpFoundation] Allow Request::setFormat() to override predefined formats (longwave)
 * feature #60153 [Serializer] Allow forcing timezone in `DateTimeNormalizer` during denormalization (frankdekker)
 * bug #62240 [DomCrawler] Handle malformed tags in HTML5 parser (longwave)
 * bug #62242 [MonologBridge] Accept HttpExceptionInterface in HttpCodeActivationStrategy (GromNaN)
 * bug #62222 [Cache] fix ext-redis 6.2.0 compatibility (xabbuh)
 * bug #62211 [Workflow] State contamination due to class-based setter cache (nicolas-grekas)
 * bug #62184 [EventDispatcher][FrameworkBundle] Rework union types on `#[AsEventListener]` (HypeMC)
 * bug #62199 [Workflow] State Contamination in Marking Stores due to Class-based Getter Cache (siganushka)
 * bug #62197 [Validator] Fix call to undefined getParser() in YamlValidator (yoeunes)
 * bug #62203 [Mailer] Fix contentId assignment for inline attachments (webflo)
 * bug #62201 [HtmlSanitizer] Remove `srcdoc` from allowed attributes (Spomky)
 * feature #62190 [Runtime] Expose `project_dir` as `APP_PROJECT_DIR` env var (nicolas-grekas)
 * bug #62191 [FrameworkBundle] Change HttpCache directory to use new getShareDir (alexander-schranz)
 * bug #62169 [HttpClient] Fix caching client decorating scoping client (pierredup)
 * bug #62185 [FrameworkBundle] Add missing `container.excluded` to `serializer.attribute_metadata` (HypeMC)
 * bug #62186 [DomCrawler] Fix converting HTML5 trees to DOM nodes (nicolas-grekas)
 * bug #62182 [VarDumper] Fix dumping CurlHttpClient instances (nicolas-grekas)
 * bug #62180 [DomCrawler] Properly ignore errors when using the native HTML5 parser (nicolas-grekas)
 * bug #62178 [FrameworkBundle] Expose share directory in AboutCommand (ro0NL)
 * bug #62167 [Lock][DynamoDB] Enable `http_client` injection and fix tests using AmpV5 client (GromNaN)

* 7.4.0-BETA1 (2025-10-27)

 * feature #62170 [HttpKernel] Add `KernelInterface::getShareDir()`, `APP_SHARE_DIR` and `kernel.share_dir` (nicolas-grekas)
 * feature #59974 [Runtime] Make project_dir configurable (wickedOne)
 * feature #60033 [ErrorHandler][FrameworkBundle] Add support for selecting the appropriate error renderer based on the `APP_RUNTIME_MODE` (yceruto)
 * feature #62027 [DebugBundle][HttpKernel] Collect dumps when console profiling is enabled (HypeMC)
 * feature #61843 [Messenger] Add `MessageSentToTransportsEvent` (HypeMC)
 * feature #61880 [JsonStreamer] Merge `PropertyMetadata` value transformers (mtarld)
 * feature #60212 [Form] Add `FormFlow` for multistep forms management (yceruto)
 * feature #62135 [Config] Deprecate config builder generators (nicolas-grekas)
 * feature #62129 [FrameworkBundle] Auto-generate `config/reference.php` to assist in writing and discovering app's configuration (nicolas-grekas)
 * feature #62069 [JsonStreamer] Add synthetic properties support (mtarld)
 * feature #62092 [Config][DependencyInjection] Deprecate the fluent PHP format for semantic configuration (nicolas-grekas)
 * feature #62090 [Config] Deprecate setting a default value to a node that is required (GromNaN)
 * feature #61984 [Messenger] Add retry delay on amazon sqs transport (deguif)
 * feature #62077 [Security] Add support for `Sec-Fetch-Site` to `SameOriginCsrfTokenManager` (nicolas-grekas)
 * feature #62073 [HttpClient] Add QUERY to the list of retriable HTTP methods (nicolas-grekas)
 * feature #62068 [Console] Add support for `Cursor` helper in invokable commands (yceruto)
 * feature #62059 [HttpClient] Add option `auto_upgrade_http_version` to control how the request HTTP version is handled in `HttplugClient` and `Psr18Client` (ajgarlag)
 * feature #62043 [Security] Allow multiple OIDC discovery endpoints (ruudk)
 * feature #62010 [Routing] Initialize `router.request_context`'s `_locale` parameter to `kernel.default_locale` (MatTheCat)
 * feature #62039 [Notifier] Add support for `confirm` option in Slack buttons API (Taras Hinyk)
 * feature #61949 [HttpFoundation] Deprecate HTTP method override for methods GET, HEAD, CONNECT and TRACE (nicolas-grekas)
 * feature #61979 [HttpFoundation] Add `Request::set/getAllowedHttpMethodOverride()` to list which HTTP methods can be overridden (nicolas-grekas)
 * feature #61490 [DependencyInjection][Routing] Define array-shapes to help writing PHP configs using yaml-like arrays (nicolas-grekas)
 * feature #61961 [HttpFoundation] Make `Request::createFromGlobals()` parse the body of PUT, DELETE, PATCH and QUERY requests (MatTheCat)
 * feature #61992 [DoctrineBridge] Deprecate `AbstractDoctrineExtension` (GromNaN)
 * feature #60660 [Security] Add security:oidc-token:generate command (Jean-Beru)
 * feature #61955 [Messenger] bump ext-redis to 6.2 and ext-relay to 0.12 minimum (xabbuh)
 * feature #61252 [FrameworkBundle] Add support for union types on `#[AsEventListener]` (Fan2Shrek)
 * feature #61748 [Console] Add support for interactive invokable commands with `#[Interact]` and `#[Ask]` attributes (yceruto)
 * feature #61952 [Cache] bump ext-relay to 0.12+ (xabbuh)
 * feature #61948 [HttpFoundation] Deprecate Request::get() in favor of using properties ->attributes, query or request directly (nicolas-grekas)
 * feature #61933 [Workflow] Move the dump command to the component (lyrixx)
 * feature #61919 [DependencyInjection] Deprecate `ExtensionInterface::getXsdValidationBasePath()` and `getNamespace()` (nicolas-grekas)
 * feature #60201 [Workflow] Add support for weighted transitions (lyrixx)
 * feature #60568 [DependencyInjection][Routing] Deprecate XML configuration format (MatTheCat)
 * feature #61837 [Form] Add new `active_at`, `not_active_at` and `legal_tender` options to `CurrencyType` (Crovitche-1623)
 * feature #61894 [DependencyInjection][Routing] Handle declaring services and routes using PHP arrays that follow the same shape as corresponding yaml files (nicolas-grekas)
 * feature #61860 [Config][DependencyInjection][Routing] Deprecate using `$this` or the internal scope of the loader from PHP config files (nicolas-grekas)
 * feature #61885 [DependencyInjection] Handle returning arrays and config-builders from config files (nicolas-grekas)
 * feature #59576 [HttpClient] Make `CachingHttpClient` compatible with RFC 9111 (Lctrs)
 * feature #61841 [Validator] deprecate passing an associative array to GroupSequence (xabbuh)
 * feature #61789 [Security] deprecate extending `RememberMeDetails` using legacy constructor signature (xabbuh)
 * feature #61807 [Uid] Add `MockUuidFactory` for deterministic UUID generation in tests (momito69)
 * feature #61838 [Notifier][LOX24] Add Lox24 webhook request parser support (alebedev80)
 * feature #61836 [MonologBridge] Deprecate `NotFoundActivationStrategy` (HypeMC)
 * feature #61791 [Validator] deprecate implicit constraint option names in YAML/XML mapping files (xabbuh)
 * feature #61778 [Notifier] Add support for building SmsEvent by dlr_code and RemoteEvent for other LOX24 webhook event types (alebedev80)
 * feature #61820 [HttpKernel][WebProfilerBundle] Display runner class in the profiler toolbar (MatTheCat)
 * feature #60902 [TwigBridgeRessources] add aria-invalid and aria-describedby on form inputs when validation failure exist (jeanfrancois-morin)
 * feature #59955 [MonologBridge] Add ability to react to console input being interactive or not (dkarlovi)
 * feature #61812 [Uid] Default to `UuidV7` when using `UuidFactory` (nicolas-grekas)
 * feature #60237 [DoctrineBridge] Add new `DayPointType` and `TimePointType` Doctrine type (wkania)
 * feature #60085 [Security] improve VoteObject adding extraData for give more possibilities to AccessDecicsionStrategy (eltharin)
 * feature #51273 [Config] Add `ArrayNodeDefinition::acceptAndWrap()` to list alternative types that should be accepted and wrapped in an array (nicolas-grekas)
 * feature #60561 [Validator] Add option to allow `ANY` protocol in `Assert\Url` constraint (alekLexis)
 * feature #61775 [Mailer][Mandrill] Add `subaccount` to the payload (andrehoong-pixieset)
 * feature #61777 [Notifier][Twilio] WhatsApp number validation (OvidiuGi)
 * feature #60023 [Lock] Add `LockKeyNormalizer` (valtzu)
 * feature #46257 [Messenger] Add AMQP exchange to exchange bindings (Samik081)
 * feature #60228 [Serializer] Support preserving array keys with `XmlEncoder` (Maximilian Ruta)
 * feature #61765 [TypeInfo] Add result cache to `TypeContextFactory` (landure)
 * feature #60114 [Workflow] Add support for `BackedEnum` in `MethodMarkingStore` (tucksaun)
 * feature #61758 [Mailer][Sendgrid] Add support for `global` region (sonnymilton)
 * feature #61743 [Security] deprecate the FQCN properties of `PersistentToken` and `RememberMeDetails` (xabbuh)
 * feature #60204 [FrameworkBundle] Add support for configuring workflow places with glob patterns matching consts/backed enums (lyrixx)
 * feature #60395 [HttpFoundation] Add `#[IsSignatureValid]` attribute (santysisi)
 * feature #61110 [FrameworkBundle] Prepare session in functionnal tests (cyve)
 * feature #61718 [Config] Add argument `$singular` to `NodeBuilder::arrayNode()` to decouple plurals/singulars from XML (nicolas-grekas)
 * feature #60138 [Lock] DynamoDB store (natepage)
 * feature #61092 [Console][QuestionHelper] add optional timeout for human interaction (janedbal)
 * feature #54366 [Messenger] Introduce `DefaultStampsProviderInterface ` (VincentLanglet)
 * feature #61694 [Security] Add `$tokenSource` argument to `#[IsCsrfTokenValid]` to support reading tokens from the query string or headers (webda2l)
 * feature #61563 [Serializer] Add `#[ExtendsSerializationFor]` to declare new serialization attributes for a class (nicolas-grekas)
 * feature #61545 [Validator] Add `#[ExtendsValidationFor]` to declare new constraints for a class (nicolas-grekas)
 * feature #61311 [WebProfilerBundle] Show `EventSource` requests in debug toolbar (valtzu)
 * feature #61654 [Security] Deprecate `PersistentToken::getClass()` and `RememberMeDetails::getUserFqcn()` in order to remove the user FQCN from the remember-me cookie in 8.0 (nicolas-grekas)
 * feature #58070 [VarDumper] Select HtmlDumper only if `Accept` header contains "html" (alexandre-daubois)
 * feature #61478 [Console] Add `#[Input]` attribute to support DTOs in invokable commands (yceruto)
 * feature #61034 [Security][SecurityBundle] Dump role hierarchy as mermaid chart (damienfern)
 * feature #61656 [DependencyInjection] Allow `Class::function(...)` and `global_function(...)` closures in PHP DSL for factories (GromNaN)
 * feature #61657 [VarExporter] Add support for exporting named closures (nicolas-grekas)
 * feature #61532 [Serializer] Allow using attributes to declare compile-time serialization metadata (nicolas-grekas)
 * feature #61528 [Validator] Allow using attributes to declare compile-time constraint metadata (nicolas-grekas)
 * feature #61379 [Security][TwigBridge] Add `access_decision()` and `access_decision_for_user()` (florentdestremau)
 * feature #59042 [Validator] Add `Video` constraint for validating video files (symfonyaml)
 * feature #61575 [DependencyInjection] Allow multiple `#[AsDecorator]` attributes (Jean-Beru)
 * feature #61592 [Runtime] Expose the runtime class in `$_SERVER['APP_RUNTIME']` (nicolas-grekas)
 * feature #61578 [DependencyInjection] Parse attributes found on abstract classes for resource definitions (nicolas-grekas)
 * feature #61564 [Serializer][Validator] Add JSON schema for validating and autocompleting YAML config files (nicolas-grekas)
 * feature #61536 [DependencyInjection] Allow adding resource tags using any config formats (nicolas-grekas)
 * feature #61297 [Form] Add form type guesser for `EnumType` (mttsch)
 * feature #61555 [Mailer][Sweego] Add support for new webhook events (welcoMattic)
 * feature #61431 [Intl] Add methods to filter currencies more precisely (Crovitche-1623)
 * feature #61542 [Security] Allow subclassing `#[IsGranted]` (nicolas-grekas)
 * feature #61497 [ObjectMapper] cache attributes in memory (soyuka)
 * feature #61522 [Runtime] Support runtime options as a string (VincentLanglet)
 * feature #59780 [FrameworkBundle] Only show relevant columns in `debug:router` call and adding colors (mamazu)
 * feature #61057 [Security] Improve performance of `RoleHierarchy::buildRoleMap` method (simonjamain-gp, simonjamain)
 * feature #60979 [Messenger] Add `--exclude-receivers` to `messenger:consume` command (jbdelhommeau)
 * feature #60442 [ObjectMapper] embed collection transformer (soyuka)
 * feature #61504  [SecurityHttp] Removes final keyword from IsGranted attribute (crtl)
 * feature #61500 [JsonPath][JsonStreamer][ObjectMapper] the components are no longer experimental (xabbuh)
 * feature #61492 [FrameworkBundle][Routing] Auto-register routes from attributes found on controller services (nicolas-grekas)
 * feature #61282 [DependencyInjection][Routing] Add JSON schema for validating and autocompleting YAML config files (nicolas-grekas)
 * feature #61078 [Console] Add getter for the original command "code" object (weitzman)
 * feature #61078 [Console] Add getter for the original command "code" object (weitzman)
 * feature #61480 [TypeInfo] Add extra type alias support (mtarld)
 * feature #61487 [Routing][Serializer] Deprecate annotation aliases and getters and setters in favor of public properties on attributes (nicolas-grekas)
 * feature #61475 [DomCrawler] Use the native HTML5 parser on PHP 8.4 (nicolas-grekas)
 * feature #60120 [Routing] Add possibility to create a request context with parameters directly (alexander-schranz)
 * feature #61455 [Mailer][Sendgrid] Add suppression groups support (KiloSierraCharlie)
 * feature #61267 [HttpFoundation] Add support for structured MIME suffix (Spomky)
 * feature #61358 [Routing] allow setting multiple envs in `#[Route]` attribute (santysisi)
 * feature #61359 [Security] Add `$methods` support to `#[IsGranted]` to restrict access by HTTP method (santysisi)
 * feature #60218 [Notifier][Discord] Add `DiscordBotTransport` (norkunas)
 * feature #61444 [Notifier][Telegram] Add TelegramOptions::messageThreadId() (MKC-MKC)
 * feature #61315 [Mailer] Add compatibility for Mailtrap's sandbox (KiloSierraCharlie)
 * feature #61173 [HttpFoundation][HttpKernel][WebProfilerBundle] Add support for the `QUERY` HTTP method (alexandre-daubois)
 * feature #61423 [Mime] Deprecate implementing `__sleep/wakeup()` on `AbstractPart` implementations (nicolas-grekas)
 * feature #61418 [Validator] Deprecate implementing `__sleep/wakeup()` on GenericMetadata implementations (nicolas-grekas)
 * feature #61417 [String] Deprecate implementing `__sleep/wakeup()` on string implementations (nicolas-grekas)
 * feature #61412 [HttpKernel] Deprecate `__sleep/wakeup()` on kernels and data collectors and make `Profile` final (nicolas-grekas)
 * feature #61413 [Serializer] Make `AttributeMetadata` and `ClassMetadata` final (nicolas-grekas)
 * feature #61366 [HtmlSanitizer] Use the native HTML5 parser when using PHP 8.4+ (nicolas-grekas)
 * feature #61290 [Mailer] Add MicrosoftGraph API Transport (bobvandevijver)
 * feature #60754 [Messenger] Allow SQS to handle its own retry/DLQ (maxbaldanza)
 * feature #61308 [Console] Adding more helpful error messages to the Questionhelper (mamazu)
 * feature #61270 [DependencyInjection] Deprecate registering a service without a class when its id is a non-existing FQCN (nicolas-grekas)
 * feature #61255 [Validator] deprecate passing choices as `$options` argument to `Choice` constraint (xabbuh)
 * feature #60355 [Serializer] Add `CDATA_WRAPPING_NAME_PATTERN` support to `XmlEncoder` (Maximilian Ruta)
 * feature #60955 [BrowserKit] Add PHPUnit constraints: `BrowserHistoryIsOnFirstPage` and `BrowserHistoryIsOnLastPage` (santysisi)
 * feature #60805 [Validator] Add `min` and `max` in both error messages of `LengthValidator` (VincentLanglet)
 * feature #61133 [AssetMapper] Add support for loading JSON using import statements (nicolas-grekas)
 * feature #61204 [Security] Support union type for `#[CurrentUser]` attribute (VincentLanglet)
 * feature #60730  [JsonStreamer] Add `include_null_properties` option (mtarld)
 * feature #61006 [JsonStreamer] Provide current object to value transformers  (mtarld)
 * feature #60935 [Translation] Add `StaticMessage` (VincentLanglet)
 * feature #61145 [ObjectMapper] Add `ObjectMapperAwareInterface` to set the owning object mapper instance (soyuka)
 * feature #61109 [Translation] Deprecate `TranslatableMessage::__toString` (VincentLanglet)
 * feature #61023 [Serializer] add `can` to the accessor prefixes recognized by the `AttributeLoader` (Mark Schmale)
 * feature #61127 [Cache] Add `TagAwareAdapterInterface` to `NullAdapter` (a.dmitryuk)
 * feature #61108 [DoctrineBridge][Validator] mark getRequiredOptions()/getDefaultOption() of UniqueEntity as deprecated (xabbuh)
 * feature #60801 [Validator] deprecate handling options in the base Constraint class (xabbuh)
 * feature #60110 [Mailer] [Transport] Allow exception logging for `RoundRobinTransport` mailer (jnoordsij)
 * feature #61024 [Intl] Optionally allow Kosovo as a component region (llupa)
 * feature #61046 [SecurityBundle] configuration for the storage service for the login throttling rate limiter (xabbuh)
 * feature #60999 [Messenger] Allow any `ServiceResetterInterface` implementation in `ResetServicesListener` (santysisi)
 * feature #60480 [VarDumper] Add support for adding more default casters to `AbstractCloner::addDefaultCasters()` (lyrixx)
 * feature #60895 [BrowserKit] Add `isFirstPage()` and `isLastPage()` methods to History (santysisi)
 * feature #60857 [FrameworkBundle] Add `ControllerHelper`; the helpers from `AbstractController` as a standalone service (nicolas-grekas)
 * feature #60898 [Uid] Add microsecond precision to UUIDv7 and optimize on x64 (nicolas-grekas)
 * feature #60910 [DependencyInjection] Add argument `$target` to `ContainerBuilder::registerAliasForArgument()` (nicolas-grekas)
 * feature #60597 [DependencyInjection][FrameworkBundle] Use php-serialize to dump the container for debug/lint commands (nicolas-grekas)
 * feature #60874 [FrameworkBundle] Allow using their name without added suffix when using #[Target] for custom services (Valmonzo)
 * feature #60614 [Security] Deprecate callable firewall listeners (MatTheCat)
 * feature #60876 [HttpFoundation] Deprecate using `Request::sendHeaders()` after headers have already been sent (nicolas-grekas)
 * feature #60823 [Console] Add support for Invokable Commands in `CommandTester` (ruudk)
 * feature #60503 [Runtime] Automatically use FrankenPHP runner when its worker mode is detected (alexandre-daubois)
 * feature #60788 [FrameworkBundle] Allow to un-verbose all the method in `BrowserKitAssertionsTrait` (VincentLanglet)
 * feature #60819 [DependencyInjection] Allow extending `#[AsAlias]` attribute (ruudk)
 * feature #60740 [Mailer] Add `assertEmailAddressNotContains` (santysisi)
 * feature #60767 [Console] Allow Usages to be specified via #[AsCommand] attribute (weitzman)
 * feature #60586 [Console] Support `BackedEnum` in invokable commands (GromNaN)
 * feature #60371 [SecurityBundle] register alias for argument for password hasher (lyrixx, chalasr)
 * feature #60394 [Console][FrameworkBundle] Simplify using invokable commands when the component is used standalone (HypeMC)
 * feature #60731 [JsonStreamer] Add PHPDoc to generated code (mtarld)
 * feature #60739 [Console] Allow setting aliases & hidden via command name passed to the constructor (HypeMC)
 * feature #60424 [PhpUnitBridge] Add `strtotime()` to `ClockMock` (jprivet-dev)
 * feature #60508 [Routing] Allow query-specific parameters in `UrlGenerator` using `_query` (BenMorel)
 * feature #60704 [HttpClient] Deprecate using amphp/http-client < 5 (nicolas-grekas)
 * feature #60253 [Scheduler] Throw error on duplicate schedule provider service registration on the schedule name (adrianrudnik)
 * feature #60315 [Form] Add `input=date_point` to `DateTimeType`, `DateType` and `TimeType` (wkania)
 * feature #60498 [HttpCache] Add a `waiting` trace when finding the cache locked (mpdude)
 * feature #60569 [HttpKernel] Do not superseed private cache-control when no-store is set (alexander-schranz)
 * feature #60209 [Notifier] Allow to set block_id/value for SlackActionsBlock and SlackButtonBlockElement (miloszowi)
 * feature #60544 [JsonStreamer] Remove `nikic/php-parser` dependency (mtarld)
 * feature #60420 [WebLink] Add class to parse Link headers from HTTP responses (GromNaN)

