/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core;

import edu.jhu.htm.core.Base;
import edu.jhu.htm.core.ErrorHandler;
import edu.jhu.htm.core.HTMException;

public class HTMfunc {
    public static boolean verbose = Boolean.getBoolean("verbose");
    public static double Pi = Math.PI;
    public static double Pr = Math.PI / 180;
    public static double Epsilon = 1.0E-15;
    public static double sqrt3 = 1.7320508075688772;
    public static final int IDSIZE = 64;
    public static final long IDHIGHBIT = Long.MIN_VALUE;
    public static final long IDHIGHBIT2 = Long.MIN_VALUE;
    public static final int HTMNAMEMAX = 32;
    static double gEpsilon = 1.0E-15;
    public static final double HTM_INVALID_ID = 1.0;
    public static final int iS2 = 0;
    public static final int iN1 = 1;
    public static final int iS1 = 2;
    public static final int iN2 = 3;
    public static final int iS3 = 4;
    public static final int iN0 = 5;
    public static final int iS0 = 6;
    public static final int iN3 = 7;
    static Object[] anchor = new Object[6];
    static Object[] S_indexes = new Object[4];
    static Object[] N_indexes = new Object[4];
    static Base[] bases;

    protected static int startpane(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, StringBuffer stringBuffer) throws HTMException {
        int n = 0;
        if (d > 0.0 && d2 >= 0.0) {
            n = d3 >= 0.0 ? 7 : 6;
        } else if (d <= 0.0 && d2 > 0.0) {
            n = d3 >= 0.0 ? 3 : 2;
        } else if (d < 0.0 && d2 <= 0.0) {
            n = d3 >= 0.0 ? 1 : 0;
        } else if (d >= 0.0 && d2 < 0.0) {
            n = d3 >= 0.0 ? 5 : 4;
        } else {
            ErrorHandler.handleError(-1);
        }
        int n2 = HTMfunc.bases[n].ID;
        double[] dArray4 = (double[])anchor[HTMfunc.bases[n].v1];
        dArray[0] = dArray4[0];
        dArray[1] = dArray4[1];
        dArray[2] = dArray4[2];
        dArray4 = (double[])anchor[HTMfunc.bases[n].v2];
        dArray2[0] = dArray4[0];
        dArray2[1] = dArray4[1];
        dArray2[2] = dArray4[2];
        dArray4 = (double[])anchor[HTMfunc.bases[n].v3];
        dArray3[0] = dArray4[0];
        dArray3[1] = dArray4[1];
        dArray3[2] = dArray4[2];
        stringBuffer.append(HTMfunc.bases[n].name);
        return n2;
    }

    protected static final void m4_midpoint(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        dArray3[2] = dArray[2] + dArray2[2];
        double d = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
        dArray3[0] = dArray3[0] / d;
        dArray3[1] = dArray3[1] / d;
        dArray3[2] = dArray3[2] / d;
    }

    public static String lookup(double d, double d2, double d3, int n) throws HTMException {
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer(80);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double d4 = 0.0;
        dArray7[0] = d;
        dArray7[1] = d2;
        dArray7[2] = d3;
        int n2 = HTMfunc.startpane(dArray3, dArray, dArray2, d, d2, d3, stringBuffer);
        while (n-- > 0) {
            HTMfunc.m4_midpoint(dArray3, dArray, dArray5);
            HTMfunc.m4_midpoint(dArray, dArray2, dArray6);
            HTMfunc.m4_midpoint(dArray2, dArray3, dArray4);
            if (HTMfunc.isinside(dArray7, dArray3, dArray5, dArray4)) {
                stringBuffer.append('0');
                HTMfunc.copy_vec(dArray, dArray5);
                HTMfunc.copy_vec(dArray2, dArray4);
                continue;
            }
            if (HTMfunc.isinside(dArray7, dArray, dArray6, dArray5)) {
                stringBuffer.append('1');
                HTMfunc.copy_vec(dArray3, dArray);
                HTMfunc.copy_vec(dArray, dArray6);
                HTMfunc.copy_vec(dArray2, dArray5);
                continue;
            }
            if (HTMfunc.isinside(dArray7, dArray2, dArray4, dArray6)) {
                stringBuffer.append('2');
                HTMfunc.copy_vec(dArray3, dArray2);
                HTMfunc.copy_vec(dArray, dArray4);
                HTMfunc.copy_vec(dArray2, dArray6);
                continue;
            }
            if (HTMfunc.isinside(dArray7, dArray6, dArray4, dArray5)) {
                stringBuffer.append('3');
                HTMfunc.copy_vec(dArray3, dArray6);
                HTMfunc.copy_vec(dArray, dArray4);
                HTMfunc.copy_vec(dArray2, dArray5);
                continue;
            }
            ErrorHandler.handleError(-1);
        }
        return stringBuffer.toString();
    }

    public static long lookupId(double d, double d2, double d3, int n) throws HTMException {
        String string = HTMfunc.lookup(d, d2, d3, n);
        long l = HTMfunc.nameToId(string.toString());
        return l;
    }

    public static String lookup(double d, double d2, int n) throws HTMException {
        double[] dArray = HTMfunc.radecToVector(d, d2);
        return HTMfunc.lookup(dArray[0], dArray[1], dArray[2], n);
    }

    public static double[] radecToVector(double d, double d2) {
        double[] dArray = new double[3];
        double d3 = Math.cos(d2 * Pi / 180.0);
        double d4 = 90.0 - d2;
        if (d4 < Epsilon && d4 > -Epsilon) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = 1.0;
            return dArray;
        }
        d4 = -90.0 - d2;
        if (d4 < Epsilon && d4 > -Epsilon) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = -1.0;
            return dArray;
        }
        dArray[2] = Math.sin(d2 * Pi / 180.0);
        double d5 = d / 90.0;
        double d6 = Math.round(d5);
        if (Math.abs(d6 - d5) < Epsilon) {
            int n = (int)d6;
            if ((n %= 4) < 0) {
                n += 4;
            }
            switch (n) {
                case 0: {
                    dArray[0] = 1.0;
                    dArray[1] = 0.0;
                    break;
                }
                case 1: {
                    dArray[0] = 0.0;
                    dArray[1] = 1.0;
                    break;
                }
                case 2: {
                    dArray[0] = -1.0;
                    dArray[1] = 0.0;
                    break;
                }
                case 3: {
                    dArray[0] = 0.0;
                    dArray[1] = -1.0;
                }
            }
            return dArray;
        }
        dArray[0] = Math.cos(d * Pi / 180.0) * d3;
        dArray[1] = Math.sin(d * Pi / 180.0) * d3;
        return dArray;
    }

    public static long lookupId(double d, double d2, int n) throws HTMException {
        StringBuffer stringBuffer = new StringBuffer(80);
        double d3 = Math.cos(d2 * Pr);
        double d4 = Math.cos(d * Pr) * d3;
        double d5 = Math.sin(d * Pr) * d3;
        double d6 = Math.sin(d2 * Pr);
        return HTMfunc.lookupId(d4, d5, d6, n);
    }

    public static boolean isinside(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double[] dArray5 = new double[]{dArray2[1] * dArray3[2] - dArray3[1] * dArray2[2], dArray2[2] * dArray3[0] - dArray3[2] * dArray2[0], dArray2[0] * dArray3[1] - dArray3[0] * dArray2[1]};
        if (dArray[0] * dArray5[0] + dArray[1] * dArray5[1] + dArray[2] * dArray5[2] < -gEpsilon) {
            return false;
        }
        dArray5[0] = dArray3[1] * dArray4[2] - dArray4[1] * dArray3[2];
        dArray5[1] = dArray3[2] * dArray4[0] - dArray4[2] * dArray3[0];
        dArray5[2] = dArray3[0] * dArray4[1] - dArray4[0] * dArray3[1];
        if (dArray[0] * dArray5[0] + dArray[1] * dArray5[1] + dArray[2] * dArray5[2] < -gEpsilon) {
            return false;
        }
        dArray5[0] = dArray4[1] * dArray2[2] - dArray2[1] * dArray4[2];
        dArray5[1] = dArray4[2] * dArray2[0] - dArray2[2] * dArray4[0];
        dArray5[2] = dArray4[0] * dArray2[1] - dArray2[0] * dArray4[1];
        return !(dArray[0] * dArray5[0] + dArray[1] * dArray5[1] + dArray[2] * dArray5[2] < -gEpsilon);
    }

    public static long nameToId(String string) throws HTMException {
        long l = 0L;
        int n = 0;
        if (string == null || string.length() == 0) {
            ErrorHandler.handleError(-3);
        }
        if (string.charAt(0) != 'N' && string.charAt(0) != 'S') {
            ErrorHandler.handleError(-4);
        }
        if ((n = string.length()) < 2) {
            ErrorHandler.handleError(-4);
        }
        if (n > 32) {
            ErrorHandler.handleError(-4);
        }
        int n2 = n - 1;
        while (n2 > 0) {
            if (string.charAt(n2) > '3' || string.charAt(n2) < '0') {
                ErrorHandler.handleError(-4);
            }
            l += (long)(string.charAt(n2) - 48) << 2 * (n - n2 - 1);
            --n2;
        }
        n2 = 2;
        if (string.charAt(0) == 'N') {
            ++n2;
        }
        long l2 = (long)n2 << 2 * n - 2;
        return l += l2;
    }

    public static int idLevel(long l) {
        int n = 0;
        int n2 = 0;
        while (n2 < 64) {
            if ((l << n2 & Long.MIN_VALUE) > 0L) break;
            n2 += 2;
        }
        n = 64 - n2 >>> 1;
        return n - 2;
    }

    public static String idToName(long l) throws HTMException {
        int n = 0;
        int n2 = 0;
        while (n2 < 64) {
            long l2 = l << n2 & Long.MIN_VALUE;
            long l3 = l << n2 & Long.MIN_VALUE;
            if (l2 != 0L) break;
            if (l3 != 0L) {
                ErrorHandler.handleError(-2);
            }
            n2 += 2;
        }
        if (l == 0L) {
            ErrorHandler.handleError(-2);
        }
        n = 64 - n2 >>> 1;
        char[] cArray = new char[n];
        n2 = 0;
        while (n2 < n - 1) {
            int n3 = 48 + (int)(l >>> n2 * 2 & 3L);
            cArray[n - n2 - 1] = (char)n3;
            ++n2;
        }
        cArray[0] = (l >> n * 2 - 2 & 1L) > 0L ? 78 : 83;
        return new String(cArray);
    }

    public static Object[] nameToTriangle(String string) {
        boolean bl = false;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double d = 0.0;
        int[] nArray = new int[3];
        int n = string.charAt(1) - 48;
        if (string.charAt(0) == 'S') {
            nArray[0] = ((int[])S_indexes[n])[0];
            nArray[1] = ((int[])S_indexes[n])[1];
            nArray[2] = ((int[])S_indexes[n])[2];
        } else {
            nArray[0] = ((int[])N_indexes[n])[0];
            nArray[1] = ((int[])N_indexes[n])[1];
            nArray[2] = ((int[])N_indexes[n])[2];
        }
        HTMfunc.copy_vec(dArray4, (double[])anchor[nArray[0]]);
        HTMfunc.copy_vec(dArray5, (double[])anchor[nArray[1]]);
        HTMfunc.copy_vec(dArray6, (double[])anchor[nArray[2]]);
        int n2 = 2;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            HTMfunc.m4_midpoint(dArray4, dArray5, dArray3);
            HTMfunc.m4_midpoint(dArray5, dArray6, dArray);
            HTMfunc.m4_midpoint(dArray6, dArray4, dArray2);
            switch (c) {
                case '0': {
                    HTMfunc.copy_vec(dArray5, dArray3);
                    HTMfunc.copy_vec(dArray6, dArray2);
                    break;
                }
                case '1': {
                    HTMfunc.copy_vec(dArray4, dArray5);
                    HTMfunc.copy_vec(dArray5, dArray);
                    HTMfunc.copy_vec(dArray6, dArray3);
                    break;
                }
                case '2': {
                    HTMfunc.copy_vec(dArray4, dArray6);
                    HTMfunc.copy_vec(dArray5, dArray2);
                    HTMfunc.copy_vec(dArray6, dArray);
                    break;
                }
                case '3': {
                    HTMfunc.copy_vec(dArray4, dArray);
                    HTMfunc.copy_vec(dArray5, dArray2);
                    HTMfunc.copy_vec(dArray6, dArray3);
                }
            }
            ++n2;
        }
        Object[] objectArray = new Object[]{dArray4, dArray5, dArray6};
        return objectArray;
    }

    protected static void copy_vec(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
    }

    public static double[] idToPoint(String string) throws HTMException {
        Object[] objectArray = HTMfunc.nameToTriangle(string);
        double[] dArray = new double[3];
        double[] dArray2 = (double[])objectArray[0];
        double[] dArray3 = (double[])objectArray[1];
        double[] dArray4 = (double[])objectArray[2];
        double d = dArray2[0] + dArray3[0] + dArray4[0];
        double d2 = dArray2[1] + dArray3[1] + dArray4[1];
        double d3 = dArray2[2] + dArray3[2] + dArray4[2];
        double d4 = d * d + d2 * d2 + d3 * d3;
        d4 = Math.sqrt(d4);
        dArray[0] = d /= d4;
        dArray[1] = d2 /= d4;
        dArray[2] = d3 /= d4;
        return dArray;
    }

    public static double[] idToPoint(long l) throws HTMException {
        String string = HTMfunc.idToName(l);
        return HTMfunc.idToPoint(string);
    }

    public static double distance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray2[n];
            ++n;
        }
        double d2 = Math.acos(d);
        return d2;
    }

    public static double distance(long l, long l2) throws HTMException {
        double[] dArray = HTMfunc.idToPoint(l);
        double[] dArray2 = HTMfunc.idToPoint(l2);
        return HTMfunc.distance(dArray, dArray2);
    }

    public static double distance(String string, String string2) throws HTMException {
        double[] dArray = HTMfunc.idToPoint(string);
        double[] dArray2 = HTMfunc.idToPoint(string2);
        return HTMfunc.distance(dArray, dArray2);
    }

    static {
        int[] nArray = new int[]{1, 0, 4};
        HTMfunc.N_indexes[0] = nArray;
        int[] nArray2 = new int[]{4, 0, 3};
        HTMfunc.N_indexes[1] = nArray2;
        int[] nArray3 = new int[]{3, 0, 2};
        HTMfunc.N_indexes[2] = nArray3;
        int[] nArray4 = new int[]{2, 0, 1};
        HTMfunc.N_indexes[3] = nArray4;
        int[] nArray5 = new int[]{1, 5, 2};
        HTMfunc.S_indexes[0] = nArray5;
        int[] nArray6 = new int[]{2, 5, 3};
        HTMfunc.S_indexes[1] = nArray6;
        int[] nArray7 = new int[]{3, 5, 4};
        HTMfunc.S_indexes[2] = nArray7;
        int[] nArray8 = new int[]{4, 5, 1};
        HTMfunc.S_indexes[3] = nArray8;
        double[] dArray = new double[]{0.0, 0.0, 1.0};
        HTMfunc.anchor[0] = dArray;
        double[] dArray2 = new double[]{1.0, 0.0, 0.0};
        HTMfunc.anchor[1] = dArray2;
        double[] dArray3 = new double[]{0.0, 1.0, 0.0};
        HTMfunc.anchor[2] = dArray3;
        double[] dArray4 = new double[]{-1.0, 0.0, 0.0};
        HTMfunc.anchor[3] = dArray4;
        double[] dArray5 = new double[]{0.0, -1.0, 0.0};
        HTMfunc.anchor[4] = dArray5;
        double[] dArray6 = new double[]{0.0, 0.0, -1.0};
        HTMfunc.anchor[5] = dArray6;
        bases = new Base[]{new Base("S2", 10, 3, 5, 4), new Base("N1", 13, 4, 0, 3), new Base("S1", 9, 2, 5, 3), new Base("N2", 14, 3, 0, 2), new Base("S3", 11, 4, 5, 1), new Base("N0", 12, 1, 0, 4), new Base("S0", 8, 1, 5, 2), new Base("N3", 15, 2, 0, 1)};
    }
}

