%feature("docstring") OT::QuadraticBasisFactory
R"RAW(Quadratic basis factory.

The quadratic basis is composed of the quadratic terms of the canonical basis:

.. math::

    \{ \psi_k(x) \} = \{ 1, x_1, \hdots, x_n, x_i x_j \forall i,j \in [1,n] \}

Parameters
----------
dimension : int
    Input dimension of the basis.

See also
--------
BasisFactory, ConstantBasisFactory, LinearBasisFactory

Examples
--------
>>> import openturns as ot
>>> basis = ot.QuadraticBasisFactory(2).build()
>>> f = ot.AggregatedFunction(basis)
>>> x = [2, 3]
>>> print(f(x))
[1,2,3,4,6,9])RAW"
