#ifndef _BIGCHUMPPRE_NEG_H_
#define _BIGCHUMPPRE_NEG_H_

// bigchumppre_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -1.500000
 // --table_div  26.013498
 // --table_op  0.500000

struct tablebigchumppre_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablebigchumppre_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablebigchumppre_neg&() const { return *(tablebigchumppre_neg*)this; }
};

 static tablebigchumppre_neg_imp<2048> bigchumppre_neg_table __rt_data = {
	0,0.622726,682.333,2048, {
	0.000000000000,0.000225868279,0.000456501002,0.000691816022,0.000931733592,
	0.001176176268,0.001425068823,0.001678338159,0.001935913228,0.002197724949,
	0.002463706135,0.002733791421,0.003007917194,0.003286021526,0.003568044112,
	0.003853926206,0.004143610567,0.004437041396,0.004734164290,0.005034926185,
	0.005339275307,0.005647161129,0.005958534318,0.006273346699,0.006591551207,
	0.006913101852,0.007237953676,0.007566062719,0.007897385984,0.008231881398,
	0.008569507788,0.008910224841,0.009253993080,0.009600773833,0.009950529205,
	0.010303222052,0.010658815956,0.011017275201,0.011378564748,0.011742650213,
	0.012109497848,0.012479074515,0.012851347672,0.013226285350,0.013603856137,
	0.013984029158,0.014366774060,0.014752060996,0.015139860607,0.015530144011,
	0.015922882784,0.016318048951,0.016715614968,0.017115553713,0.017517838473,
	0.017922442929,0.018329341150,0.018738507578,0.019149917018,0.019563544632,
	0.019979365923,0.020397356730,0.020817493218,0.021239751871,0.021664109479,
	0.022090543135,0.022519030226,0.022949548423,0.023382075678,0.023816590214,
	0.024253070520,0.024691495344,0.025131843688,0.025574094800,0.026018228169,
	0.026464223522,0.026912060815,0.027361720231,0.027813182173,0.028266427261,
	0.028721436325,0.029178190402,0.029636670735,0.030096858761,0.030558736116,
	0.031022284624,0.031487486298,0.031954323333,0.032422778107,0.032892833171,
	0.033364471253,0.033837675249,0.034312428225,0.034788713409,0.035266514193,
	0.035745814127,0.036226596916,0.036708846420,0.037192546652,0.037677681770,
	0.038164236081,0.038652194037,0.039141540229,0.039632259390,0.040124336392,
	0.040617756239,0.041112504072,0.041608565163,0.042105924914,0.042604568854,
	0.043104482641,0.043605652055,0.044108063001,0.044611701506,0.045116553715,
	0.045622605893,0.046129844421,0.046638255795,0.047147826627,0.047658543640,
	0.048170393669,0.048683363658,0.049197440661,0.049712611838,0.050228864458,
	0.050746185891,0.051264563614,0.051783985206,0.052304438346,0.052825910815,
	0.053348390494,0.053871865361,0.054396323491,0.054921753056,0.055448142325,
	0.055975479658,0.056503753510,0.057032952430,0.057563065055,0.058094080117,
	0.058625986434,0.059158772914,0.059692428555,0.060226942439,0.060762303737,
	0.061298501704,0.061835525681,0.062373365092,0.062912009445,0.063451448329,
	0.063991671417,0.064532668462,0.065074429296,0.065616943832,0.066160202062,
	0.066704194056,0.067248909961,0.067794340000,0.068340474475,0.068887303762,
	0.069434818309,0.069983008644,0.070531865364,0.071081379141,0.071631540719,
	0.072182340914,0.072733770612,0.073285820771,0.073838482420,0.074391746654,
	0.074945604641,0.075500047614,0.076055066876,0.076610653796,0.077166799810,
	0.077723496421,0.078280735196,0.078838507769,0.079396805837,0.079955621162,
	0.080514945570,0.081074770948,0.081635089249,0.082195892485,0.082757172731,
	0.083318922124,0.083881132860,0.084443797195,0.085006907447,0.085570455992,
	0.086134435264,0.086698837757,0.087263656021,0.087828882665,0.088394510355,
	0.088960531814,0.089526939819,0.090093727205,0.090660886862,0.091228411733,
	0.091796294818,0.092364529171,0.092933107897,0.093502024157,0.094071271164,
	0.094640842184,0.095210730533,0.095780929581,0.096351432749,0.096922233508,
	0.097493325381,0.098064701938,0.098636356804,0.099208283648,0.099780476191,
	0.100352928203,0.100925633502,0.101498585952,0.102071779467,0.102645208007,
	0.103218865580,0.103792746240,0.104366844087,0.104941153267,0.105515667971,
	0.106090382436,0.106665290945,0.107240387823,0.107815667440,0.108391124212,
	0.108966752596,0.109542547093,0.110118502248,0.110694612647,0.111270872919,
	0.111847277735,0.112423821809,0.113000499894,0.113577306785,0.114154237318,
	0.114731286370,0.115308448858,0.115885719738,0.116463094006,0.117040566697,
	0.117618132887,0.118195787688,0.118773526251,0.119351343767,0.119929235464,
	0.120507196606,0.121085222496,0.121663308474,0.122241449916,0.122819642236,
	0.123397880882,0.123976161340,0.124554479132,0.125132829812,0.125711208973,
	0.126289612242,0.126868035280,0.127446473783,0.128024923479,0.128603380135,
	0.129181839546,0.129760297545,0.130338749995,0.130917192793,0.131495621869,
	0.132074033187,0.132652422740,0.133230786554,0.133809120690,0.134387421236,
	0.134965684313,0.135543906075,0.136122082704,0.136700210415,0.137278285451,
	0.137856304087,0.138434262627,0.139012157407,0.139589984788,0.140167741166,
	0.140745422961,0.141323026624,0.141900548636,0.142477985505,0.143055333767,
	0.143632589987,0.144209750756,0.144786812696,0.145363772454,0.145940626704,
	0.146517372148,0.147094005514,0.147670523559,0.148246923064,0.148823200837,
	0.149399353712,0.149975378549,0.150551272234,0.151127031678,0.151702653817,
	0.152278135614,0.152853474055,0.153428666151,0.154003708938,0.154578599478,
	0.155153334854,0.155727912175,0.156302328574,0.156876581207,0.157450667254,
	0.158024583919,0.158598328427,0.159171898029,0.159745289996,0.160318501624,
	0.160891530230,0.161464373153,0.162037027757,0.162609491425,0.163181761564,
	0.163753835600,0.164325710983,0.164897385185,0.165468855696,0.166040120029,
	0.166611175720,0.167182020322,0.167752651411,0.168323066582,0.168893263452,
	0.169463239657,0.170032992853,0.170602520717,0.171171820945,0.171740891252,
	0.172309729373,0.172878333062,0.173446700094,0.174014828260,0.174582715372,
	0.175150359260,0.175717757773,0.176284908779,0.176851810162,0.177418459826,
	0.177984855694,0.178550995705,0.179116877817,0.179682500005,0.180247860263,
	0.180812956599,0.181377787042,0.181942349637,0.182506642445,0.183070663546,
	0.183634411033,0.184197883021,0.184761077637,0.185323993026,0.185886627350,
	0.186448978787,0.187011045530,0.187572825788,0.188134317788,0.188695519771,
	0.189256429992,0.189817046725,0.190377368258,0.190937392892,0.191497118946,
	0.192056544753,0.192615668662,0.193174489034,0.193733004248,0.194291212695,
	0.194849112782,0.195406702931,0.195963981575,0.196520947166,0.197077598166,
	0.197633933052,0.198189950317,0.198745648465,0.199301026015,0.199856081499,
	0.200410813463,0.200965220467,0.201519301082,0.202073053894,0.202626477502,
	0.203179570517,0.203732331564,0.204284759280,0.204836852315,0.205388609332,
	0.205940029005,0.206491110023,0.207041851084,0.207592250901,0.208142308198,
	0.208692021711,0.209241390188,0.209790412389,0.210339087086,0.210887413062,
	0.211435389113,0.211983014045,0.212530286676,0.213077205835,0.213623770363,
	0.214169979113,0.214715830946,0.215261324737,0.215806459370,0.216351233742,
	0.216895646759,0.217439697338,0.217983384407,0.218526706905,0.219069663779,
	0.219612253990,0.220154476507,0.220696330310,0.221237814388,0.221778927742,
	0.222319669382,0.222860038327,0.223400033607,0.223939654263,0.224478899342,
	0.225017767905,0.225556259019,0.226094371763,0.226632105224,0.227169458499,
	0.227706430694,0.228243020923,0.228779228312,0.229315051994,0.229850491112,
	0.230385544817,0.230920212269,0.231454492637,0.231988385100,0.232521888844,
	0.233055003064,0.233587726964,0.234120059756,0.234652000661,0.235183548908,
	0.235714703734,0.236245464385,0.236775830114,0.237305800184,0.237835373865,
	0.238364550433,0.238893329176,0.239421709387,0.239949690367,0.240477271426,
	0.241004451881,0.241531231057,0.242057608285,0.242583582906,0.243109154267,
	0.243634321722,0.244159084634,0.244683442372,0.245207394313,0.245730939839,
	0.246254078343,0.246776809223,0.247299131883,0.247821045735,0.248342550199,
	0.248863644701,0.249384328672,0.249904601554,0.250424462791,0.250943911837,
	0.251462948151,0.251981571199,0.252499780454,0.253017575396,0.253534955509,
	0.254051920286,0.254568469225,0.255084601830,0.255600317612,0.256115616088,
	0.256630496781,0.257144959221,0.257659002942,0.258172627487,0.258685832401,
	0.259198617239,0.259710981559,0.260222924926,0.260734446911,0.261245547090,
	0.261756225046,0.262266480365,0.262776312641,0.263285721474,0.263794706467,
	0.264303267231,0.264811403380,0.265319114536,0.265826400324,0.266333260377,
	0.266839694330,0.267345701826,0.267851282512,0.268356436040,0.268861162067,
	0.269365460256,0.269869330275,0.270372771796,0.270875784497,0.271378368059,
	0.271880522171,0.272382246525,0.272883540817,0.273384404749,0.273884838028,
	0.274384840366,0.274884411477,0.275383551083,0.275882258908,0.276380534683,
	0.276878378141,0.277375789021,0.277872767067,0.278369312026,0.278865423650,
	0.279361101696,0.279856345924,0.280351156098,0.280845531990,0.281339473371,
	0.281832980019,0.282326051717,0.282818688250,0.283310889408,0.283802654986,
	0.284293984781,0.284784878596,0.285275336237,0.285765357514,0.286254942241,
	0.286744090235,0.287232801320,0.287721075319,0.288208912062,0.288696311383,
	0.289183273119,0.289669797109,0.290155883199,0.290641531235,0.291126741070,
	0.291611512558,0.292095845559,0.292579739934,0.293063195549,0.293546212273,
	0.294028789979,0.294510928543,0.294992627845,0.295473887766,0.295954708194,
	0.296435089018,0.296915030130,0.297394531427,0.297873592808,0.298352214176,
	0.298830395436,0.299308136497,0.299785437271,0.300262297674,0.300738717624,
	0.301214697041,0.301690235851,0.302165333980,0.302639991360,0.303114207923,
	0.303587983606,0.304061318348,0.304534212091,0.305006664781,0.305478676365,
	0.305950246793,0.306421376021,0.306892064003,0.307362310699,0.307832116071,
	0.308301480083,0.308770402703,0.309238883901,0.309706923650,0.310174521924,
	0.310641678701,0.311108393963,0.311574667692,0.312040499874,0.312505890497,
	0.312970839552,0.313435347032,0.313899412932,0.314363037252,0.314826219991,
	0.315288961152,0.315751260741,0.316213118766,0.316674535237,0.317135510166,
	0.317596043568,0.318056135460,0.318515785862,0.318974994795,0.319433762283,
	0.319892088353,0.320349973033,0.320807416353,0.321264418346,0.321720979047,
	0.322177098493,0.322632776723,0.323088013779,0.323542809704,0.323997164543,
	0.324451078344,0.324904551157,0.325357583032,0.325810174024,0.326262324188,
	0.326714033582,0.327165302265,0.327616130298,0.328066517746,0.328516464673,
	0.328965971146,0.329415037235,0.329863663010,0.330311848545,0.330759593914,
	0.331206899193,0.331653764460,0.332100189796,0.332546175282,0.332991721003,
	0.333436827042,0.333881493488,0.334325720429,0.334769507955,0.335212856159,
	0.335655765134,0.336098234976,0.336540265783,0.336981857652,0.337423010684,
	0.337863724981,0.338304000646,0.338743837786,0.339183236506,0.339622196915,
	0.340060719122,0.340498803240,0.340936449380,0.341373657657,0.341810428187,
	0.342246761087,0.342682656476,0.343118114475,0.343553135204,0.343987718787,
	0.344421865348,0.344855575014,0.345288847911,0.345721684168,0.346154083916,
	0.346586047285,0.347017574409,0.347448665421,0.347879320456,0.348309539652,
	0.348739323147,0.349168671079,0.349597583589,0.350026060819,0.350454102912,
	0.350881710013,0.351308882266,0.351735619819,0.352161922819,0.352587791416,
	0.353013225760,0.353438226002,0.353862792296,0.354286924794,0.354710623653,
	0.355133889027,0.355556721075,0.355979119955,0.356401085826,0.356822618849,
	0.357243719185,0.357664386998,0.358084622450,0.358504425707,0.358923796935,
	0.359342736301,0.359761243973,0.360179320119,0.360596964909,0.361014178516,
	0.361430961110,0.361847312866,0.362263233955,0.362678724555,0.363093784840,
	0.363508414988,0.363922615175,0.364336385582,0.364749726387,0.365162637772,
	0.365575119917,0.365987173005,0.366398797220,0.366809992745,0.367220759765,
	0.367631098466,0.368041009036,0.368450491662,0.368859546531,0.369268173834,
	0.369676373760,0.370084146501,0.370491492248,0.370898411193,0.371304903531,
	0.371710969454,0.372116609158,0.372521822840,0.372926610694,0.373330972918,
	0.373734909711,0.374138421270,0.374541507796,0.374944169489,0.375346406548,
	0.375748219177,0.376149607577,0.376550571951,0.376951112504,0.377351229438,
	0.377750922960,0.378150193276,0.378549040590,0.378947465112,0.379345467048,
	0.379743046607,0.380140203997,0.380536939429,0.380933253113,0.381329145260,
	0.381724616081,0.382119665788,0.382514294594,0.382908502713,0.383302290358,
	0.383695657745,0.384088605087,0.384481132601,0.384873240503,0.385264929009,
	0.385656198338,0.386047048707,0.386437480335,0.386827493440,0.387217088243,
	0.387606264962,0.387995023819,0.388383365036,0.388771288832,0.389158795432,
	0.389545885057,0.389932557930,0.390318814275,0.390704654316,0.391090078278,
	0.391475086386,0.391859678866,0.392243855942,0.392627617843,0.393010964794,
	0.393393897023,0.393776414758,0.394158518228,0.394540207660,0.394921483284,
	0.395302345329,0.395682794026,0.396062829605,0.396442452297,0.396821662332,
	0.397200459942,0.397578845360,0.397956818818,0.398334380548,0.398711530784,
	0.399088269759,0.399464597708,0.399840514863,0.400216021461,0.400591117736,
	0.400965803923,0.401340080259,0.401713946979,0.402087404319,0.402460452517,
	0.402833091809,0.403205322433,0.403577144627,0.403948558628,0.404319564676,
	0.404690163008,0.405060353865,0.405430137484,0.405799514106,0.406168483971,
	0.406537047319,0.406905204391,0.407272955427,0.407640300668,0.408007240356,
	0.408373774732,0.408739904039,0.409105628519,0.409470948413,0.409835863965,
	0.410200375419,0.410564483016,0.410928187000,0.411291487616,0.411654385107,
	0.412016879718,0.412378971692,0.412740661276,0.413101948712,0.413462834248,
	0.413823318128,0.414183400598,0.414543081903,0.414902362290,0.415261242005,
	0.415619721295,0.415977800405,0.416335479584,0.416692759078,0.417049639134,
	0.417406120000,0.417762201923,0.418117885152,0.418473169934,0.418828056518,
	0.419182545152,0.419536636085,0.419890329564,0.420243625841,0.420596525162,
	0.420949027778,0.421301133938,0.421652843892,0.422004157889,0.422355076179,
	0.422705599013,0.423055726640,0.423405459310,0.423754797275,0.424103740785,
	0.424452290090,0.424800445441,0.425148207090,0.425495575288,0.425842550285,
	0.426189132333,0.426535321684,0.426881118590,0.427226523302,0.427571536071,
	0.427916157151,0.428260386792,0.428604225248,0.428947672770,0.429290729611,
	0.429633396024,0.429975672260,0.430317558574,0.430659055216,0.431000162441,
	0.431340880501,0.431681209650,0.432021150140,0.432360702225,0.432699866158,
	0.433038642192,0.433377030581,0.433715031578,0.434052645437,0.434389872412,
	0.434726712756,0.435063166723,0.435399234568,0.435734916543,0.436070212903,
	0.436405123902,0.436739649794,0.437073790833,0.437407547273,0.437740919369,
	0.438073907375,0.438406511545,0.438738732133,0.439070569395,0.439402023584,
	0.439733094955,0.440063783762,0.440394090260,0.440724014704,0.441053557349,
	0.441382718448,0.441711498257,0.442039897030,0.442367915023,0.442695552489,
	0.443022809683,0.443349686862,0.443676184278,0.444002302187,0.444328040844,
	0.444653400504,0.444978381422,0.445302983851,0.445627208049,0.445951054268,
	0.446274522764,0.446597613793,0.446920327608,0.447242664465,0.447564624618,
	0.447886208323,0.448207415835,0.448528247407,0.448848703296,0.449168783755,
	0.449488489041,0.449807819406,0.450126775108,0.450445356399,0.450763563536,
	0.451081396772,0.451398856362,0.451715942562,0.452032655625,0.452348995807,
	0.452664963362,0.452980558545,0.453295781611,0.453610632813,0.453925112406,
	0.454239220646,0.454552957786,0.454866324081,0.455179319785,0.455491945152,
	0.455804200437,0.456116085895,0.456427601779,0.456738748343,0.457049525842,
	0.457359934530,0.457669974661,0.457979646489,0.458288950267,0.458597886250,
	0.458906454692,0.459214655847,0.459522489967,0.459829957307,0.460137058121,
	0.460443792663,0.460750161184,0.461056163940,0.461361801184,0.461667073168,
	0.461971980147,0.462276522373,0.462580700100,0.462884513580,0.463187963068,
	0.463491048815,0.463793771075,0.464096130100,0.464398126144,0.464699759459,
	0.465001030297,0.465301938911,0.465602485555,0.465902670479,0.466202493937,
	0.466501956180,0.466801057461,0.467099798033,0.467398178146,0.467696198053,
	0.467993858006,0.468291158257,0.468588099057,0.468884680658,0.469180903311,
	0.469476767268,0.469772272781,0.470067420100,0.470362209476,0.470656641162,
	0.470950715407,0.471244432464,0.471537792582,0.471830796012,0.472123443005,
	0.472415733812,0.472707668682,0.472999247868,0.473290471617,0.473581340182,
	0.473871853811,0.474162012756,0.474451817265,0.474741267589,0.475030363977,
	0.475319106679,0.475607495944,0.475895532022,0.476183215161,0.476470545612,
	0.476757523623,0.477044149444,0.477330423322,0.477616345507,0.477901916248,
	0.478187135792,0.478472004389,0.478756522287,0.479040689734,0.479324506977,
	0.479607974266,0.479891091848,0.480173859970,0.480456278881,0.480738348827,
	0.481020070057,0.481301442818,0.481582467356,0.481863143920,0.482143472755,
	0.482423454109,0.482703088229,0.482982375361,0.483261315751,0.483539909646,
	0.483818157293,0.484096058937,0.484373614825,0.484650825202,0.484927690314,
	0.485204210406,0.485480385726,0.485756216516,0.486031703024,0.486306845494,
	0.486581644172,0.486856099301,0.487130211128,0.487403979896,0.487677405850,
	0.487950489234,0.488223230294,0.488495629273,0.488767686414,0.489039401963,
	0.489310776162,0.489581809255,0.489852501487,0.490122853099,0.490392864337,
	0.490662535441,0.490931866657,0.491200858225,0.491469510390,0.491737823394,
	0.492005797478,0.492273432887,0.492540729861,0.492807688642,0.493074309474,
	0.493340592597,0.493606538253,0.493872146683,0.494137418129,0.494402352833,
	0.494666951035,0.494931212976,0.495195138897,0.495458729039,0.495721983643,
	0.495984902947,0.496247487194,0.496509736623,0.496771651474,0.497033231987,
	0.497294478402,0.497555390958,0.497815969894,0.498076215450,0.498336127865,
	0.498595707378,0.498854954228,0.499113868654,0.499372450893,0.499630701185,
	0.499888619768,0.500146206880,0.500403462759,0.500660387642,0.500916981768,
	0.501173245374,0.501429178697,0.501684781975,0.501940055444,0.502194999343,
	0.502449613907,0.502703899373,0.502957855977,0.503211483957,0.503464783549,
	0.503717754987,0.503970398509,0.504222714350,0.504474702746,0.504726363932,
	0.504977698143,0.505228705616,0.505479386584,0.505729741282,0.505979769946,
	0.506229472810,0.506478850109,0.506727902076,0.506976628945,0.507225030952,
	0.507473108329,0.507720861310,0.507968290129,0.508215395020,0.508462176214,
	0.508708633946,0.508954768449,0.509200579954,0.509446068695,0.509691234905,
	0.509936078814,0.510180600656,0.510424800663,0.510668679066,0.510912236098,
	0.511155471988,0.511398386970,0.511640981274,0.511883255131,0.512125208772,
	0.512366842428,0.512608156329,0.512849150706,0.513089825790,0.513330181810,
	0.513570218996,0.513809937577,0.514049337785,0.514288419848,0.514527183995,
	0.514765630456,0.515003759460,0.515241571235,0.515479066011,0.515716244016,
	0.515953105477,0.516189650625,0.516425879685,0.516661792888,0.516897390459,
	0.517132672627,0.517367639620,0.517602291664,0.517836628987,0.518070651815,
	0.518304360376,0.518537754896,0.518770835602,0.519003602719,0.519236056475,
	0.519468197095,0.519700024804,0.519931539829,0.520162742396,0.520393632729,
	0.520624211053,0.520854477595,0.521084432578,0.521314076228,0.521543408768,
	0.521772430424,0.522001141420,0.522229541979,0.522457632326,0.522685412684,
	0.522912883277,0.523140044329,0.523366896063,0.523593438701,0.523819672467,
	0.524045597584,0.524271214274,0.524496522760,0.524721523263,0.524946216007,
	0.525170601213,0.525394679103,0.525618449899,0.525841913822,0.526065071093,
	0.526287921934,0.526510466566,0.526732705210,0.526954638085,0.527176265413,
	0.527397587415,0.527618604310,0.527839316318,0.528059723659,0.528279826554,
	0.528499625221,0.528719119880,0.528938310750,0.529157198050,0.529375781999,
	0.529594062817,0.529812040721,0.530029715929,0.530247088661,0.530464159134,
	0.530680927566,0.530897394175,0.531113559179,0.531329422794,0.531544985239,
	0.531760246730,0.531975207484,0.532189867719,0.532404227650,0.532618287494,
	0.532832047468,0.533045507787,0.533258668668,0.533471530326,0.533684092977,
	0.533896356837,0.534108322121,0.534319989043,0.534531357819,0.534742428665,
	0.534953201793,0.535163677420,0.535373855758,0.535583737024,0.535793321429,
	0.536002609189,0.536211600517,0.536420295627,0.536628694731,0.536836798043,
	0.537044605777,0.537252118144,0.537459335358,0.537666257632,0.537872885176,
	0.538079218205,0.538285256930,0.538491001562,0.538696452313,0.538901609396,
	0.539106473021,0.539311043400,0.539515320743,0.539719305262,0.539922997167,
	0.540126396669,0.540329503979,0.540532319306,0.540734842861,0.540937074854,
	0.541139015494,0.541340664990,0.541542023554,0.541743091393,0.541943868717,
	0.542144355734,0.542344552654,0.542544459686,0.542744077036,0.542943404915,
	0.543142443530,0.543341193089,0.543539653800,0.543737825870,0.543935709507,
	0.544133304919,0.544330612312,0.544527631893,0.544724363870,0.544920808449,
	0.545116965836,0.545312836237,0.545508419860,0.545703716910,0.545898727593,
	0.546093452114,0.546287890679,0.546482043494,0.546675910763,0.546869492692,
	0.547062789486,0.547255801349,0.547448528485,0.547640971100,0.547833129398,
	0.548025003582,0.548216593856,0.548407900425,0.548598923491,0.548789663259,
	0.548980119931,0.549170293711,0.549360184801,0.549549793405,0.549739119725,
	0.549928163963,0.550116926321,0.550305407003,0.550493606209,0.550681524141,
	0.550869161002,0.551056516993,0.551243592315,0.551430387169,0.551616901756,
	0.551803136277,0.551989090933,0.552174765924,0.552360161451,0.552545277713,
	0.552730114912,0.552914673246,0.553098952915,0.553282954120,0.553466677059,
	0.553650121932,0.553833288937,0.554016178274,0.554198790141,0.554381124737,
	0.554563182261,0.554744962910,0.554926466884,0.555107694378,0.555288645593,
	0.555469320725,0.555649719971,0.555829843529,0.556009691596,0.556189264370,
	0.556368562046,0.556547584823,0.556726332895,0.556904806460,0.557083005713,
	0.557260930851,0.557438582070,0.557615959565,0.557793063533,0.557969894167,
	0.558146451664,0.558322736219,0.558498748027,0.558674487281,0.558849954178,
	0.559025148911,0.559200071675,0.559374722664,0.559549102072,0.559723210092,
	0.559897046919,0.560070612746,0.560243907765,0.560416932171,0.560589686157,
	0.560762169915,0.560934383638,0.561106327518,0.561278001749,0.561449406522,
	0.561620542029,0.561791408462,0.561962006013,0.562132334874,0.562302395236,
	0.562472187291,0.562641711229,0.562810967242,0.562979955520,0.563148676254,
	0.563317129634,0.563485315852,0.563653235097,0.563820887559,0.563988273428,
	0.564155392894,0.564322246146,0.564488833374,0.564655154768,0.564821210515,
	0.564987000806,0.565152525829,0.565317785773,0.565482780826,0.565647511176,
	0.565811977012,0.565976178522,0.566140115893,0.566303789314,0.566467198972,
	0.566630345054,0.566793227748,0.566955847240,0.567118203718,0.567280297368,
	0.567442128378,0.567603696933,0.567765003220,0.567926047425,0.568086829734,
	0.568247350333,0.568407609408,0.568567607144,0.568727343727,0.568886819341,
	0.569046034173,0.569204988407,0.569363682227,0.569522115819,0.569680289367,
	0.569838203055,0.569995857068,0.570153251589,0.570310386802,0.570467262892,
	0.570623880041,0.570780238434,0.570936338252,0.571092179681,0.571247762901,
	0.571403088097,0.571558155451,0.571712965146,0.571867517363,0.572021812285,
	0.572175850094,0.572329630973,0.572483155102,0.572636422664,0.572789433839,
	0.572942188809,0.573094687756,0.573246930860,0.573398918303,0.573550650264,
	0.573702126924,0.573853348465,0.574004315065,0.574155026905,0.574305484166,
	0.574455687027,0.574605635667,0.574755330266,0.574904771004,0.575053958059,
	0.575202891611,0.575351571838,0.575499998920,0.575648173035,0.575796094361,
	0.575943763077,0.576091179361,0.576238343390,0.576385255344,0.576531915399,
	0.576678323732,0.576824480523,0.576970385947,0.577116040182,0.577261443404,
	0.577406595792,0.577551497520,0.577696148767,0.577840549708,0.577984700519,
	0.578128601377,0.578272252457,0.578415653936,0.578558805988,0.578701708790,
	0.578844362517,0.578986767343,0.579128923445,0.579270830997,0.579412490173,
	0.579553901149,0.579695064099,0.579835979197,0.579976646617,0.580117066534,
	0.580257239121,0.580397164551,0.580536843000,0.580676274640,0.580815459644,
	0.580954398185,0.581093090437,0.581231536573,0.581369736765,0.581507691185,
	0.581645400007,0.581782863402,0.581920081543,0.582057054602,0.582193782750,
	0.582330266159,0.582466505001,0.582602499448,0.582738249669,0.582873755838,
	0.583009018124,0.583144036699,0.583278811733,0.583413343397,0.583547631861,
	0.583681677295,0.583815479871,0.583949039756,0.584082357123,0.584215432139,
	0.584348264976,0.584480855801,0.584613204786,0.584745312097,0.584877177906,
	0.585008802380,0.585140185688,0.585271327999,0.585402229481,0.585532890302,
	0.585663310632,0.585793490637,0.585923430485,0.586053130345,0.586182590384,
	0.586311810769,0.586440791667,0.586569533247,0.586698035674,0.586826299116,
	0.586954323739,0.587082109710,0.587209657196,0.587336966362,0.587464037376,
	0.587590870402,0.587717465608,0.587843823158,0.587969943218,0.588095825954,
	0.588221471532,0.588346880115,0.588472051870,0.588596986962,0.588721685554,
	0.588846147813,0.588970373901,0.589094363985,0.589218118227,0.589341636792,
	0.589464919844,0.589587967547,0.589710780064,0.589833357560,0.589955700196,
	0.590077808138,0.590199681547,0.590321320587,0.590442725420,0.590563896210,
	0.590684833119,0.590805536310,0.590926005944,0.591046242184,0.591166245192,
	0.591286015129,0.591405552158,0.591524856441,0.591643928138,0.591762767411,
	0.591881374422,0.591999749331,0.592117892299,0.592235803487,0.592353483056,
	0.592470931167,0.592588147979,0.592705133653,0.592821888349,0.592938412228,
	0.593054705448,0.593170768171,0.593286600554,0.593402202759,0.593517574943,
	0.593632717267,0.593747629889,0.593862312969,0.593976766664,0.594090991135,
	0.594204986539,0.594318753034,0.594432290779,0.594545599933,0.594658680652,
	0.594771533095,0.594884157420,0.594996553785,0.595108722346,0.595220663261,
	0.595332376687,0.595443862781,0.595555121701,0.595666153602,0.595776958643,
	0.595887536978,0.595997888765,0.596108014160,0.596217913319,0.596327586398,
	0.596437033553,0.596546254939,0.596655250713,0.596764021029,0.596872566044,
	0.596980885912,0.597088980788,0.597196850828,0.597304496185,0.597411917016,
	0.597519113474,0.597626085714,0.597732833890,0.597839358157,0.597945658667,
	0.598051735577,0.598157589038,0.598263219205,0.598368626231,0.598473810270,
	0.598578771476,0.598683510000,0.598788025996,0.598892319617,0.598996391017,
	0.599100240346,0.599203867758,0.599307273406,0.599410457441,0.599513420016,
	0.599616161282,0.599718681392,0.599820980497,0.599923058749,0.600024916299,
	0.600126553299,0.600227969900,0.600329166252,0.600430142508,0.600530898817,
	0.600631435330,0.600731752199,0.600831849573,0.600931727603,0.601031386439,
	0.601130826231,0.601230047130,0.601329049284,0.601427832843,0.601526397958,
	0.601624744778,0.601722873451,0.601820784128,0.601918476956,0.602015952086,
	0.602113209666,0.602210249845,0.602307072771,0.602403678592,0.602500067458,
	0.602596239516,0.602692194914,0.602787933800,0.602883456323,0.602978762629,
	0.603073852866,0.603168727183,0.603263385725,0.603357828641,0.603452056077,
	0.603546068181,0.603639865099,0.603733446978,0.603826813964,0.603919966205,
	0.604012903845,0.604105627032,0.604198135912,0.604290430631,0.604382511334,
	0.604474378167,0.604566031276,0.604657470806,0.604748696903,0.604839709712,
	0.604930509378,0.605021096046,0.605111469860,0.605201630967,0.605291579510,
	0.605381315633,0.605470839482,0.605560151200,0.605649250932,0.605738138822,
	0.605826815013,0.605915279649,0.606003532874,0.606091574832,0.606179405666,
	0.606267025520,0.606354434535,0.606441632857,0.606528620626,0.606615397988,
	0.606701965083,0.606788322055,0.606874469045,0.606960406198,0.607046133654,
	0.607131651556,0.607216960045,0.607302059264,0.607386949355,0.607471630459,
	0.607556102717,0.607640366271,0.607724421263,0.607808267833,0.607891906122,
	0.607975336272,0.608058558423,0.608141572716,0.608224379292,0.608306978290,
	0.608389369852,0.608471554117,0.608553531226,0.608635301319,0.608716864535,
	0.608798221014,0.608879370896,0.608960314321,0.609041051427,0.609121582354,
	0.609201907242,0.609282026229,0.609361939455,0.609441647057,0.609521149176,
	0.609600445949,0.609679537514,0.609758424011,0.609837105578,0.609915582352,
	0.609993854472,0.610071922076,0.610149785301,0.610227444285,0.610304899165,
	0.610382150080,0.610459197166,0.610536040561,0.610612680401,0.610689116825,
	0.610765349968,0.610841379967,0.610917206959,0.610992831081,0.611068252469,
	0.611143471259,0.611218487587,0.611293301590,0.611367913404,0.611442323164,
	0.611516531006,0.611590537066,0.611664341480,0.611737944382,0.611811345908,
	0.611884546193,0.611957545372,0.612030343581,0.612102940954,0.612175337625,
	0.612247533730,0.612319529403,0.612391324779,0.612462919990,0.612534315173,
	0.612605510461,0.612676505987,0.612747301886,0.612817898291,0.612888295337,
	0.612958493156,0.613028491882,0.613098291648,0.613167892588,0.613237294834,
	0.613306498520,0.613375503778,0.613444310741,0.613512919541,0.613581330312,
	0.613649543186,0.613717558295,0.613785375770,0.613852995745,0.613920418351,
	0.613987643720,0.614054671984,0.614121503275,0.614188137723,0.614254575461,
	0.614320816620,0.614386861331,0.614452709725,0.614518361933,0.614583818086,
	0.614649078315,0.614714142750,0.614779011523,0.614843684763,0.614908162601,
	0.614972445167,0.615036532591,0.615100425004,0.615164122535,0.615227625314,
	0.615290933470,0.615354047135,0.615416966436,0.615479691503,0.615542222466,
	0.615604559454,0.615666702596,0.615728652020,0.615790407856,0.615851970233,
	0.615913339279,0.615974515122,0.616035497892,0.616096287716,0.616156884723,
	0.616217289040,0.616277500797,0.616337520120,0.616397347138,0.616456981978,
	0.616516424768,0.616575675636,0.616634734708,0.616693602112,0.616752277976,
	0.616810762426,0.616869055590,0.616927157594,0.616985068565,0.617042788629,
	0.617100317914,0.617157656546,0.617214804651,0.617271762355,0.617328529785,
	0.617385107066,0.617441494325,0.617497691687,0.617553699279,0.617609517225,
	0.617665145652,0.617720584684,0.617775834448,0.617830895068,0.617885766669,
	0.617940449377,0.617994943317,0.618049248612,0.618103365389,0.618157293772,
	0.618211033884,0.618264585852,0.618317949798,0.618371125847,0.618424114124,
	0.618476914752,0.618529527856,0.618581953558,0.618634191983,0.618686243255,
	0.618738107497,0.618789784832,0.618841275383,0.618892579275,0.618943696630,
	0.618994627571,0.619045372221,0.619095930702,0.619146303138,0.619196489652,
	0.619246490365,0.619296305400,0.619345934880,0.619395378927,0.619444637662,
	0.619493711209,0.619542599688,0.619591303222,0.619639821932,0.619688155940,
	0.619736305368,0.619784270338,0.619832050969,0.619879647384,0.619927059704,
	0.619974288050,0.620021332543,0.620068193304,0.620114870453,0.620161364112,
	0.620207674400,0.620253801438,0.620299745347,0.620345506247,0.620391084258,
	0.620436479500,0.620481692094,0.620526722158,0.620571569814,0.620616235180,
	0.620660718376,0.620705019522,0.620749138738,0.620793076141,0.620836831853,
	0.620880405992,0.620923798676,0.620967010025,0.621010040159,0.621052889194,
	0.621095557251,0.621138044448,0.621180350903,0.621222476734,0.621264422060,
	0.621306187000,0.621347771671,0.621389176190,0.621430400677,0.621471445249,
	0.621512310024,0.621552995119,0.621593500652,0.621633826740,0.621673973501,
	0.621713941052,0.621753729510,0.621793338992,0.621832769615,0.621872021496,
	0.621911094752,0.621949989500,0.621988705856,0.622027243937,0.622065603858,
	0.622103785738,0.622141789691,0.622179615833,0.622217264282,0.622254735153,
	0.622292028562,0.622329144624,0.622366083455,0.622402845172,0.622439429888,
	0.622475837721,0.622512068785,0.622548123195,0.622584001067,0.622619702516,
	0.622655227656,0.622690576603,0.622725749471
	}
};

double always_inline bigchumppre_negclip(double x) {
    double f = fabs(x);
    f = f * bigchumppre_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = bigchumppre_neg_table.data[0];
    } else if (i >= bigchumppre_neg_table.size-1) {
        f = bigchumppre_neg_table.data[bigchumppre_neg_table.size-1];
    } else {
    f -= i;
    f = bigchumppre_neg_table.data[i]*(1-f) + bigchumppre_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

#endif //_BIGCHUMPPRE_NEG_H_
