/*
  Copyright (C) 2003  Sridhar Ratnakumar <srid@srid.ca>
        
  This file is part of GNUSim8085.

  GNUSim8085 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GNUSim8085 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNUSim8085; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA
  02110-1301, USA.
*/

#include <libintl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>

#define _(String) gettext (String)
#define N_(String) (String)
#define GTK_(String) dgettext ("gtk30", String)

/*
 * Public Functions.
 */

/*
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkWidget*  lookup_widget              (GtkWidget       *widget,
                                        const gchar     *widget_name);

/*
 * This function returns a action widget in a component.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkAction*  lookup_action_widget              (GtkWidget       *widget,
											   const gchar     *widget_name);


/*
 * Private Functions.
 */

/* This is used to create the pixbufs used in the interface. */
GdkPixbuf*  create_pixbuf              (const gchar     *filename);

/* This is used to read authors from AUTHORS file. */
gchar**  read_authors ();

/* This is used to read tutorial from asm-guide.txt file. */
GString*  read_tutorial ();

/* A wrapper function to create button with stock items. */
GtkWidget*  button_from_stock (const gchar *label, const gchar *icon_name);

/* A wrapper function to create button with stock image and custom label. */
GtkWidget*  button_from_stock_img_custom_label (const gchar *label,
		const gchar *icon_name);
