# Progress Linux: gnome-shell-extensions-extra

# Copyright (C) 2010-2023 Daniel Baumann <daniel.baumann@progress-linux.org>
#
# SPDX-License-Identifier: GPL-3.0+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Build-Depends:
# gettext libglib2.0-bin

SHELL := sh -e

EXTENSION := middleclickclose
UUID := $(shell awk -F\" '/"uuid": / { print $$4 }' $(EXTENSION)/*@*/metadata.json)

all:

test:

build:
	for TRANSLATION in $(EXTENSION)/$(UUID)/locale/*/*/*.mo; \
	do \
		msgfmt -cv -o $${TRANSLATION} $$(dirname $${TRANSLATION})/$$(basename $${TRANSLATION} .mo).po; \
	done

	glib-compile-schemas --strict --targetdir=$(EXTENSION)/$(UUID)/schemas/ $(EXTENSION)/$(UUID)/schemas

install: build
	mkdir -p $(DESTDIR)/usr/share/gnome-shell/extensions
	cp -a $(EXTENSION)/$(UUID) $(DESTDIR)/usr/share/gnome-shell/extensions

uninstall:
	rm -rf $(DESTDIR)/usr/share/gnome-shell/extensions/$(UUID)
	rmdir --ignore-fail-on-non-empty --parents $(DESTDIR) || true

clean:

distclean:

reinstall: uninstall install

upstream:
	rm -rf $(EXTENSION)
	git clone https://github.com/p91paul/$(EXTENSION)
	rm -rf $(EXTENSION)/.git
