// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudsearchdomain

import (
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpSearch struct {
}

func (*validateOpSearch) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSearch) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SearchInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSearchInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSuggest struct {
}

func (*validateOpSuggest) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSuggest) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SuggestInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSuggestInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUploadDocuments struct {
}

func (*validateOpUploadDocuments) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUploadDocuments) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UploadDocumentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUploadDocumentsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpSearchValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSearch{}, middleware.After)
}

func addOpSuggestValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSuggest{}, middleware.After)
}

func addOpUploadDocumentsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUploadDocuments{}, middleware.After)
}

func validateOpSearchInput(v *SearchInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchInput"}
	if v.Query == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Query"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSuggestInput(v *SuggestInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SuggestInput"}
	if v.Query == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Query"))
	}
	if v.Suggester == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Suggester"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUploadDocumentsInput(v *UploadDocumentsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UploadDocumentsInput"}
	if v.Documents == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Documents"))
	}
	if len(v.ContentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ContentType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
