//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armedgeorder

import "time"

// AddressDetails - Address details for an order item.
type AddressDetails struct {
	// REQUIRED; Customer address and contact details. It should be address resource
	ForwardAddress *AddressProperties `json:"forwardAddress,omitempty"`

	// READ-ONLY; Return shipping address
	ReturnAddress *AddressProperties `json:"returnAddress,omitempty" azure:"ro"`
}

// AddressProperties - Address Properties
type AddressProperties struct {
	// REQUIRED; Contact details for the address
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// Shipping details for the address
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// READ-ONLY; Status of address validation
	AddressValidationStatus *AddressValidationStatus `json:"addressValidationStatus,omitempty" azure:"ro"`
}

// AddressResource - Address Resource.
type AddressResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of an address.
	Properties *AddressProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Represents resource creation and update time
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AddressResourceList - Address Resource Collection
type AddressResourceList struct {
	// Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of address resources.
	Value []*AddressResource `json:"value,omitempty" azure:"ro"`
}

// AddressUpdateParameter - The Address update parameters
type AddressUpdateParameter struct {
	// Properties of a address to be updated.
	Properties *AddressUpdateProperties `json:"properties,omitempty"`

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string `json:"tags,omitempty"`
}

// AddressUpdateProperties - Address Properties
type AddressUpdateProperties struct {
	// Contact details for the address
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// Shipping details for the address
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
}

// AvailabilityInformation - Availability information of a product system.
type AvailabilityInformation struct {
	// READ-ONLY; Current availability stage of the product. Availability stage
	AvailabilityStage *AvailabilityStage `json:"availabilityStage,omitempty" azure:"ro"`

	// READ-ONLY; Reason why the product is disabled.
	DisabledReason *DisabledReason `json:"disabledReason,omitempty" azure:"ro"`

	// READ-ONLY; Message for why the product is disabled.
	DisabledReasonMessage *string `json:"disabledReasonMessage,omitempty" azure:"ro"`
}

// BasicInformation - Basic information for any product system
type BasicInformation struct {
	// READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty" azure:"ro"`

	// READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty" azure:"ro"`

	// READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty" azure:"ro"`

	// READ-ONLY; Image information for the product system.
	ImageInformation []*ImageInformation `json:"imageInformation,omitempty" azure:"ro"`
}

// BillingMeterDetails - Holds billing meter details for each type of billing
type BillingMeterDetails struct {
	// READ-ONLY; Frequency of recurrence
	Frequency *string `json:"frequency,omitempty" azure:"ro"`

	// READ-ONLY; Represents MeterDetails
	MeterDetails MeterDetailsClassification `json:"meterDetails,omitempty" azure:"ro"`

	// READ-ONLY; Represents Metering type (eg one-time or recurrent)
	MeteringType *MeteringType `json:"meteringType,omitempty" azure:"ro"`

	// READ-ONLY; Represents Billing type name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// CancellationReason - Reason for cancellation.
type CancellationReason struct {
	// REQUIRED; Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// CommonProperties - Represents common properties across product hierarchy
type CommonProperties struct {
	// READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty" azure:"ro"`

	// READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty" azure:"ro"`

	// READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; list of filters supported for a product
	FilterableProperties []*FilterableProperty `json:"filterableProperties,omitempty" azure:"ro"`

	// READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty" azure:"ro"`

	// READ-ONLY; Image information for the product system.
	ImageInformation []*ImageInformation `json:"imageInformation,omitempty" azure:"ro"`
}

// Configuration object.
type Configuration struct {
	// READ-ONLY; Properties of configuration
	Properties *ConfigurationProperties `json:"properties,omitempty" azure:"ro"`
}

// ConfigurationFilters - Configuration filters
type ConfigurationFilters struct {
	// REQUIRED; Product hierarchy information
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`

	// Filters specific to product
	FilterableProperty []*FilterableProperty `json:"filterableProperty,omitempty"`
}

// ConfigurationProperties - Properties of configuration
type ConfigurationProperties struct {
	// READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty" azure:"ro"`

	// READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty" azure:"ro"`

	// READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Dimensions of the configuration
	Dimensions *Dimensions `json:"dimensions,omitempty" azure:"ro"`

	// READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; list of filters supported for a product
	FilterableProperties []*FilterableProperty `json:"filterableProperties,omitempty" azure:"ro"`

	// READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty" azure:"ro"`

	// READ-ONLY; Image information for the product system.
	ImageInformation []*ImageInformation `json:"imageInformation,omitempty" azure:"ro"`

	// READ-ONLY; Specifications of the configuration
	Specifications []*Specification `json:"specifications,omitempty" azure:"ro"`
}

// Configurations - The list of configurations.
type Configurations struct {
	// Link for the next set of configurations.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of configurations.
	Value []*Configuration `json:"value,omitempty" azure:"ro"`
}

// ConfigurationsRequest - Configuration request object.
type ConfigurationsRequest struct {
	// REQUIRED; Holds details about product hierarchy information and filterable property.
	ConfigurationFilters []*ConfigurationFilters `json:"configurationFilters,omitempty"`

	// Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing
	// subscription details
	CustomerSubscriptionDetails *CustomerSubscriptionDetails `json:"customerSubscriptionDetails,omitempty"`
}

// ContactDetails - Contact Details.
type ContactDetails struct {
	// REQUIRED; Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`

	// REQUIRED; List of Email-ids to be notified about job progress.
	EmailList []*string `json:"emailList,omitempty"`

	// REQUIRED; Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`

	// Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`

	// Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
}

// CostInformation - Cost information for the product system
type CostInformation struct {
	// READ-ONLY; Default url to display billing information
	BillingInfoURL *string `json:"billingInfoUrl,omitempty" azure:"ro"`

	// READ-ONLY; Details on the various billing aspects for the product system.
	BillingMeterDetails []*BillingMeterDetails `json:"billingMeterDetails,omitempty" azure:"ro"`
}

// CustomerSubscriptionDetails - Holds Customer subscription details. Clients can display available products to unregistered
// customers by explicitly passing subscription details
type CustomerSubscriptionDetails struct {
	// REQUIRED; Quota ID of a subscription
	QuotaID *string `json:"quotaId,omitempty"`

	// Location placement Id of a subscription
	LocationPlacementID *string `json:"locationPlacementId,omitempty"`

	// List of registered feature flags for subscription
	RegisteredFeatures []*CustomerSubscriptionRegisteredFeatures `json:"registeredFeatures,omitempty"`
}

// CustomerSubscriptionRegisteredFeatures - Represents subscription registered features
type CustomerSubscriptionRegisteredFeatures struct {
	// Name of subscription registered feature
	Name *string `json:"name,omitempty"`

	// State of subscription registered feature
	State *string `json:"state,omitempty"`
}

// Description related properties of a product system.
type Description struct {
	// READ-ONLY; Attributes for the product system.
	Attributes []*string `json:"attributes,omitempty" azure:"ro"`

	// READ-ONLY; Type of description.
	DescriptionType *DescriptionType `json:"descriptionType,omitempty" azure:"ro"`

	// READ-ONLY; Keywords for the product system.
	Keywords []*string `json:"keywords,omitempty" azure:"ro"`

	// READ-ONLY; Links for the product system.
	Links []*Link `json:"links,omitempty" azure:"ro"`

	// READ-ONLY; Long description of the product system.
	LongDescription *string `json:"longDescription,omitempty" azure:"ro"`

	// READ-ONLY; Short description of the product system.
	ShortDescription *string `json:"shortDescription,omitempty" azure:"ro"`
}

// DeviceDetails - Device details.
type DeviceDetails struct {
	// READ-ONLY; Management Resource Id
	ManagementResourceID *string `json:"managementResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Management Resource Tenant ID
	ManagementResourceTenantID *string `json:"managementResourceTenantId,omitempty" azure:"ro"`

	// READ-ONLY; device serial number
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`
}

// Dimensions of a configuration.
type Dimensions struct {
	// READ-ONLY; Depth of the device.
	Depth *float64 `json:"depth,omitempty" azure:"ro"`

	// READ-ONLY; Height of the device.
	Height *float64 `json:"height,omitempty" azure:"ro"`

	// READ-ONLY; Length of the device.
	Length *float64 `json:"length,omitempty" azure:"ro"`

	// READ-ONLY; Unit for the dimensions of length, height and width.
	LengthHeightUnit *LengthHeightUnit `json:"lengthHeightUnit,omitempty" azure:"ro"`

	// READ-ONLY; Weight of the device.
	Weight *float64 `json:"weight,omitempty" azure:"ro"`

	// READ-ONLY; Unit for the dimensions of weight.
	WeightUnit *WeightMeasurementUnit `json:"weightUnit,omitempty" azure:"ro"`

	// READ-ONLY; Width of the device.
	Width *float64 `json:"width,omitempty" azure:"ro"`
}

// DisplayInfo - Describes product display information
type DisplayInfo struct {
	// READ-ONLY; Configuration display name
	ConfigurationDisplayName *string `json:"configurationDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Product family display name
	ProductFamilyDisplayName *string `json:"productFamilyDisplayName,omitempty" azure:"ro"`
}

// EncryptionPreferences - Preferences related to the double encryption
type EncryptionPreferences struct {
	// Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled'
	// policy is configured.
	DoubleEncryptionStatus *DoubleEncryptionStatus `json:"doubleEncryptionStatus,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FilterableProperty - Different types of filters supported and its values.
type FilterableProperty struct {
	// REQUIRED; Values to be filtered.
	SupportedValues []*string `json:"supportedValues,omitempty"`

	// REQUIRED; Type of product filter.
	Type *SupportedFilterTypes `json:"type,omitempty"`
}

// ForwardShippingDetails - Forward shipment details.
type ForwardShippingDetails struct {
	// READ-ONLY; Carrier Name for display purpose. Not to be used for any processing.
	CarrierDisplayName *string `json:"carrierDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty" azure:"ro"`

	// READ-ONLY; TrackingId of the package
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`

	// READ-ONLY; TrackingUrl of the package.
	TrackingURL *string `json:"trackingUrl,omitempty" azure:"ro"`
}

// HierarchyInformation - Holds details about product hierarchy information
type HierarchyInformation struct {
	// Represents configuration name that uniquely identifies configuration
	ConfigurationName *string `json:"configurationName,omitempty"`

	// Represents product family name that uniquely identifies product family
	ProductFamilyName *string `json:"productFamilyName,omitempty"`

	// Represents product line name that uniquely identifies product line
	ProductLineName *string `json:"productLineName,omitempty"`

	// Represents product name that uniquely identifies product
	ProductName *string `json:"productName,omitempty"`
}

// ImageInformation - Image for the product
type ImageInformation struct {
	// READ-ONLY; Type of the image
	ImageType *ImageType `json:"imageType,omitempty" azure:"ro"`

	// READ-ONLY; Url of the image
	ImageURL *string `json:"imageUrl,omitempty" azure:"ro"`
}

// Link - Returns link related to the product
type Link struct {
	// READ-ONLY; Type of link
	LinkType *LinkType `json:"linkType,omitempty" azure:"ro"`

	// READ-ONLY; Url of the link
	LinkURL *string `json:"linkUrl,omitempty" azure:"ro"`
}

// ManagementClientBeginCreateAddressOptions contains the optional parameters for the ManagementClient.BeginCreateAddress
// method.
type ManagementClientBeginCreateAddressOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginCreateOrderItemOptions contains the optional parameters for the ManagementClient.BeginCreateOrderItem
// method.
type ManagementClientBeginCreateOrderItemOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginDeleteAddressByNameOptions contains the optional parameters for the ManagementClient.BeginDeleteAddressByName
// method.
type ManagementClientBeginDeleteAddressByNameOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginDeleteOrderItemByNameOptions contains the optional parameters for the ManagementClient.BeginDeleteOrderItemByName
// method.
type ManagementClientBeginDeleteOrderItemByNameOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginReturnOrderItemOptions contains the optional parameters for the ManagementClient.BeginReturnOrderItem
// method.
type ManagementClientBeginReturnOrderItemOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginUpdateAddressOptions contains the optional parameters for the ManagementClient.BeginUpdateAddress
// method.
type ManagementClientBeginUpdateAddressOptions struct {
	// Defines the If-Match condition. The patch will be performed only if the ETag of the job on the server matches this value.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginUpdateOrderItemOptions contains the optional parameters for the ManagementClient.BeginUpdateOrderItem
// method.
type ManagementClientBeginUpdateOrderItemOptions struct {
	// Defines the If-Match condition. The patch will be performed only if the ETag of the order on the server matches this value.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientCancelOrderItemOptions contains the optional parameters for the ManagementClient.CancelOrderItem method.
type ManagementClientCancelOrderItemOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientGetAddressByNameOptions contains the optional parameters for the ManagementClient.GetAddressByName method.
type ManagementClientGetAddressByNameOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientGetOrderByNameOptions contains the optional parameters for the ManagementClient.GetOrderByName method.
type ManagementClientGetOrderByNameOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientGetOrderItemByNameOptions contains the optional parameters for the ManagementClient.GetOrderItemByName
// method.
type ManagementClientGetOrderItemByNameOptions struct {
	// $expand is supported on device details, forward shipping details and reverse shipping details parameters. Each of these
	// can be provided as a comma separated list. Device Details for order item
	// provides details on the devices of the product, Forward and Reverse Shipping details provide forward and reverse shipping
	// details respectively.
	Expand *string
}

// ManagementClientListAddressesAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.ListAddressesAtResourceGroupLevel
// method.
type ManagementClientListAddressesAtResourceGroupLevelOptions struct {
	// $filter is supported to filter based on shipping address properties. Filter supports only equals operation.
	Filter *string
	// $skipToken is supported on Get list of addresses, which provides the next page in the list of address.
	SkipToken *string
}

// ManagementClientListAddressesAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.ListAddressesAtSubscriptionLevel
// method.
type ManagementClientListAddressesAtSubscriptionLevelOptions struct {
	// $filter is supported to filter based on shipping address properties. Filter supports only equals operation.
	Filter *string
	// $skipToken is supported on Get list of addresses, which provides the next page in the list of addresses.
	SkipToken *string
}

// ManagementClientListConfigurationsOptions contains the optional parameters for the ManagementClient.ListConfigurations
// method.
type ManagementClientListConfigurationsOptions struct {
	// $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
	SkipToken *string
}

// ManagementClientListOperationsOptions contains the optional parameters for the ManagementClient.ListOperations method.
type ManagementClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientListOrderAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.ListOrderAtResourceGroupLevel
// method.
type ManagementClientListOrderAtResourceGroupLevelOptions struct {
	// $skipToken is supported on Get list of order, which provides the next page in the list of order.
	SkipToken *string
}

// ManagementClientListOrderAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.ListOrderAtSubscriptionLevel
// method.
type ManagementClientListOrderAtSubscriptionLevelOptions struct {
	// $skipToken is supported on Get list of order, which provides the next page in the list of order.
	SkipToken *string
}

// ManagementClientListOrderItemsAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.ListOrderItemsAtResourceGroupLevel
// method.
type ManagementClientListOrderItemsAtResourceGroupLevelOptions struct {
	// $expand is supported on device details, forward shipping details and reverse shipping details parameters. Each of these
	// can be provided as a comma separated list. Device Details for order item
	// provides details on the devices of the product, Forward and Reverse Shipping details provide forward and reverse shipping
	// details respectively.
	Expand *string
	// $filter is supported to filter based on order id. Filter supports only equals operation.
	Filter *string
	// $skipToken is supported on Get list of order items, which provides the next page in the list of order items.
	SkipToken *string
}

// ManagementClientListOrderItemsAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.ListOrderItemsAtSubscriptionLevel
// method.
type ManagementClientListOrderItemsAtSubscriptionLevelOptions struct {
	// $expand is supported on device details, forward shipping details and reverse shipping details parameters. Each of these
	// can be provided as a comma separated list. Device Details for order item
	// provides details on the devices of the product, Forward and Reverse Shipping details provide forward and reverse shipping
	// details respectively.
	Expand *string
	// $filter is supported to filter based on order id. Filter supports only equals operation.
	Filter *string
	// $skipToken is supported on Get list of order items, which provides the next page in the list of order items.
	SkipToken *string
}

// ManagementClientListProductFamiliesMetadataOptions contains the optional parameters for the ManagementClient.ListProductFamiliesMetadata
// method.
type ManagementClientListProductFamiliesMetadataOptions struct {
	// $skipToken is supported on list of product families metadata, which provides the next page in the list of product families
	// metadata.
	SkipToken *string
}

// ManagementClientListProductFamiliesOptions contains the optional parameters for the ManagementClient.ListProductFamilies
// method.
type ManagementClientListProductFamiliesOptions struct {
	// $expand is supported on configurations parameter for product, which provides details on the configurations for the product.
	Expand *string
	// $skipToken is supported on list of product families, which provides the next page in the list of product families.
	SkipToken *string
}

// ManagementResourcePreferences - Management resource preference to link device
type ManagementResourcePreferences struct {
	// Customer preferred Management resource ARM ID
	PreferredManagementResourceID *string `json:"preferredManagementResourceId,omitempty"`
}

// MeterDetailsClassification provides polymorphic access to related types.
// Call the interface's GetMeterDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MeterDetails, *Pav2MeterDetails, *PurchaseMeterDetails
type MeterDetailsClassification interface {
	// GetMeterDetails returns the MeterDetails content of the underlying type.
	GetMeterDetails() *MeterDetails
}

// MeterDetails - Holds details about billing type and its meter guids
type MeterDetails struct {
	// REQUIRED; Represents billing type.
	BillingType *BillingType `json:"billingType,omitempty"`

	// READ-ONLY; Charging type.
	ChargingType *ChargingType `json:"chargingType,omitempty" azure:"ro"`

	// READ-ONLY; Billing unit applicable for Pav2 billing
	Multiplier *float64 `json:"multiplier,omitempty" azure:"ro"`
}

// GetMeterDetails implements the MeterDetailsClassification interface for type MeterDetails.
func (m *MeterDetails) GetMeterDetails() *MeterDetails { return m }

// NotificationPreference - Notification preference for a job stage.
type NotificationPreference struct {
	// REQUIRED; Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`

	// REQUIRED; Name of the stage.
	StageName *NotificationStageName `json:"stageName,omitempty"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OrderItemDetails - Order item details
type OrderItemDetails struct {
	// REQUIRED; Order item type.
	OrderItemType *OrderItemType `json:"orderItemType,omitempty"`

	// REQUIRED; Unique identifier for configuration.
	ProductDetails *ProductDetails `json:"productDetails,omitempty"`

	// Additional notification email list
	NotificationEmailList []*string `json:"notificationEmailList,omitempty"`

	// Customer notification Preferences
	Preferences *Preferences `json:"preferences,omitempty"`

	// READ-ONLY; Cancellation reason.
	CancellationReason *string `json:"cancellationReason,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the order item is cancellable or not.
	CancellationStatus *OrderItemCancellationEnum `json:"cancellationStatus,omitempty" azure:"ro"`

	// READ-ONLY; Current Order item Status
	CurrentStage *StageDetails `json:"currentStage,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the order item is deletable or not.
	DeletionStatus *ActionStatusEnum `json:"deletionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Top level error for the job.
	Error *ErrorDetail `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Forward Package Shipping details
	ForwardShippingDetails *ForwardShippingDetails `json:"forwardShippingDetails,omitempty" azure:"ro"`

	// READ-ONLY; Parent RP details - this returns only the first or default parent RP from the entire list
	ManagementRpDetails *ResourceProviderDetails `json:"managementRpDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of parent RP details supported for configuration.
	ManagementRpDetailsList []*ResourceProviderDetails `json:"managementRpDetailsList,omitempty" azure:"ro"`

	// READ-ONLY; Order item status history
	OrderItemStageHistory []*StageDetails `json:"orderItemStageHistory,omitempty" azure:"ro"`

	// READ-ONLY; Return reason.
	ReturnReason *string `json:"returnReason,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the order item is returnable or not.
	ReturnStatus *OrderItemReturnEnum `json:"returnStatus,omitempty" azure:"ro"`

	// READ-ONLY; Reverse Package Shipping details
	ReverseShippingDetails *ReverseShippingDetails `json:"reverseShippingDetails,omitempty" azure:"ro"`
}

// OrderItemProperties - Represents order item details.
type OrderItemProperties struct {
	// REQUIRED; Represents shipping and return address for order item
	AddressDetails *AddressDetails `json:"addressDetails,omitempty"`

	// REQUIRED; Id of the order to which order item belongs to
	OrderID *string `json:"orderId,omitempty"`

	// REQUIRED; Represents order item details.
	OrderItemDetails *OrderItemDetails `json:"orderItemDetails,omitempty"`

	// READ-ONLY; Start time of order item
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// OrderItemResource - Represents order item contract
type OrderItemResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Order item properties
	Properties *OrderItemProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Represents resource creation and update time
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OrderItemResourceList - List of orderItems.
type OrderItemResourceList struct {
	// Link for the next set of order item resources.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of order item resources.
	Value []*OrderItemResource `json:"value,omitempty" azure:"ro"`
}

// OrderItemUpdateParameter - Updates order item parameters.
type OrderItemUpdateParameter struct {
	// Order item update properties
	Properties *OrderItemUpdateProperties `json:"properties,omitempty"`

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string `json:"tags,omitempty"`
}

// OrderItemUpdateProperties - Order item update properties.
type OrderItemUpdateProperties struct {
	// Updates forward shipping address and contact details.
	ForwardAddress *AddressProperties `json:"forwardAddress,omitempty"`

	// Additional notification email list.
	NotificationEmailList []*string `json:"notificationEmailList,omitempty"`

	// Customer preference.
	Preferences *Preferences `json:"preferences,omitempty"`
}

// OrderProperties - Represents order details.
type OrderProperties struct {
	// READ-ONLY; Order current status.
	CurrentStage *StageDetails `json:"currentStage,omitempty" azure:"ro"`

	// READ-ONLY; List of order item ARM Ids which are part of an order.
	OrderItemIDs []*string `json:"orderItemIds,omitempty" azure:"ro"`

	// READ-ONLY; Order status history.
	OrderStageHistory []*StageDetails `json:"orderStageHistory,omitempty" azure:"ro"`
}

// OrderResource - Specifies the properties or parameters for an order. Order is a grouping of one or more order items.
type OrderResource struct {
	// REQUIRED; Order properties
	Properties *OrderProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Represents resource creation and update time
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OrderResourceList - List of orders.
type OrderResourceList struct {
	// Link for the next set of order resources.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of order resources.
	Value []*OrderResource `json:"value,omitempty" azure:"ro"`
}

// Pav2MeterDetails - Billing type PAV2 meter details
type Pav2MeterDetails struct {
	// REQUIRED; Represents billing type.
	BillingType *BillingType `json:"billingType,omitempty"`

	// READ-ONLY; Charging type.
	ChargingType *ChargingType `json:"chargingType,omitempty" azure:"ro"`

	// READ-ONLY; Validation status of requested data center and transport.
	MeterGUID *string `json:"meterGuid,omitempty" azure:"ro"`

	// READ-ONLY; Billing unit applicable for Pav2 billing
	Multiplier *float64 `json:"multiplier,omitempty" azure:"ro"`
}

// GetMeterDetails implements the MeterDetailsClassification interface for type Pav2MeterDetails.
func (p *Pav2MeterDetails) GetMeterDetails() *MeterDetails {
	return &MeterDetails{
		BillingType:  p.BillingType,
		Multiplier:   p.Multiplier,
		ChargingType: p.ChargingType,
	}
}

// Preferences related to the order
type Preferences struct {
	// Preferences related to the Encryption.
	EncryptionPreferences *EncryptionPreferences `json:"encryptionPreferences,omitempty"`

	// Preferences related to the Management resource.
	ManagementResourcePreferences *ManagementResourcePreferences `json:"managementResourcePreferences,omitempty"`

	// Notification preferences.
	NotificationPreferences []*NotificationPreference `json:"notificationPreferences,omitempty"`

	// Preferences related to the shipment logistics of the order.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
}

// Product - List of Products
type Product struct {
	// READ-ONLY; Properties of product
	Properties *ProductProperties `json:"properties,omitempty" azure:"ro"`
}

// ProductDetails - Represents product details
type ProductDetails struct {
	// REQUIRED; Hierarchy of the product which uniquely identifies the product
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`

	// Display details of the product
	DisplayInfo *DisplayInfo `json:"displayInfo,omitempty"`

	// READ-ONLY; Quantity of the product
	Count *int32 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; list of device details
	DeviceDetails []*DeviceDetails `json:"deviceDetails,omitempty" azure:"ro"`

	// READ-ONLY; Double encryption status of the configuration. Read-only field.
	ProductDoubleEncryptionStatus *DoubleEncryptionStatus `json:"productDoubleEncryptionStatus,omitempty" azure:"ro"`
}

// ProductFamilies - The list of product families.
type ProductFamilies struct {
	// Link for the next set of product families.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of product families.
	Value []*ProductFamily `json:"value,omitempty" azure:"ro"`
}

// ProductFamiliesMetadata - Holds details about product family metadata
type ProductFamiliesMetadata struct {
	// READ-ONLY; Link for the next set of product families.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of product family metadata details.
	Value []*ProductFamiliesMetadataDetails `json:"value,omitempty" azure:"ro"`
}

// ProductFamiliesMetadataDetails - Product families metadata details.
type ProductFamiliesMetadataDetails struct {
	// READ-ONLY; Product family properties
	Properties *ProductFamilyProperties `json:"properties,omitempty" azure:"ro"`
}

// ProductFamiliesRequest - The filters for showing the product families.
type ProductFamiliesRequest struct {
	// REQUIRED; Dictionary of filterable properties on product family.
	FilterableProperties map[string][]*FilterableProperty `json:"filterableProperties,omitempty"`

	// Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing
	// subscription details
	CustomerSubscriptionDetails *CustomerSubscriptionDetails `json:"customerSubscriptionDetails,omitempty"`
}

// ProductFamily - Product Family
type ProductFamily struct {
	// READ-ONLY; Properties of product family
	Properties *ProductFamilyProperties `json:"properties,omitempty" azure:"ro"`
}

// ProductFamilyProperties - Properties of product family
type ProductFamilyProperties struct {
	// Contains details related to resource provider
	ResourceProviderDetails []*ResourceProviderDetails `json:"resourceProviderDetails,omitempty"`

	// READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty" azure:"ro"`

	// READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty" azure:"ro"`

	// READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; list of filters supported for a product
	FilterableProperties []*FilterableProperty `json:"filterableProperties,omitempty" azure:"ro"`

	// READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty" azure:"ro"`

	// READ-ONLY; Image information for the product system.
	ImageInformation []*ImageInformation `json:"imageInformation,omitempty" azure:"ro"`

	// READ-ONLY; List of product lines supported in the product family
	ProductLines []*ProductLine `json:"productLines,omitempty" azure:"ro"`
}

// ProductLine - Product line
type ProductLine struct {
	// READ-ONLY; Properties of product line
	Properties *ProductLineProperties `json:"properties,omitempty" azure:"ro"`
}

// ProductLineProperties - Properties of product line
type ProductLineProperties struct {
	// READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty" azure:"ro"`

	// READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty" azure:"ro"`

	// READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; list of filters supported for a product
	FilterableProperties []*FilterableProperty `json:"filterableProperties,omitempty" azure:"ro"`

	// READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty" azure:"ro"`

	// READ-ONLY; Image information for the product system.
	ImageInformation []*ImageInformation `json:"imageInformation,omitempty" azure:"ro"`

	// READ-ONLY; List of products in the product line
	Products []*Product `json:"products,omitempty" azure:"ro"`
}

// ProductProperties - Properties of products
type ProductProperties struct {
	// READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty" azure:"ro"`

	// READ-ONLY; List of configurations for the product
	Configurations []*Configuration `json:"configurations,omitempty" azure:"ro"`

	// READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty" azure:"ro"`

	// READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; list of filters supported for a product
	FilterableProperties []*FilterableProperty `json:"filterableProperties,omitempty" azure:"ro"`

	// READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty" azure:"ro"`

	// READ-ONLY; Image information for the product system.
	ImageInformation []*ImageInformation `json:"imageInformation,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PurchaseMeterDetails - Billing type Purchase meter details
type PurchaseMeterDetails struct {
	// REQUIRED; Represents billing type.
	BillingType *BillingType `json:"billingType,omitempty"`

	// READ-ONLY; Charging type.
	ChargingType *ChargingType `json:"chargingType,omitempty" azure:"ro"`

	// READ-ONLY; Billing unit applicable for Pav2 billing
	Multiplier *float64 `json:"multiplier,omitempty" azure:"ro"`

	// READ-ONLY; Product Id
	ProductID *string `json:"productId,omitempty" azure:"ro"`

	// READ-ONLY; Sku Id
	SKUID *string `json:"skuId,omitempty" azure:"ro"`

	// READ-ONLY; Term Id
	TermID *string `json:"termId,omitempty" azure:"ro"`
}

// GetMeterDetails implements the MeterDetailsClassification interface for type PurchaseMeterDetails.
func (p *PurchaseMeterDetails) GetMeterDetails() *MeterDetails {
	return &MeterDetails{
		BillingType:  p.BillingType,
		Multiplier:   p.Multiplier,
		ChargingType: p.ChargingType,
	}
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceIdentity - Msi identity details of the resource
type ResourceIdentity struct {
	// Identity type
	Type *string `json:"type,omitempty"`

	// READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Home Tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ResourceProviderDetails - Management RP details
type ResourceProviderDetails struct {
	// READ-ONLY; Resource provider namespace
	ResourceProviderNamespace *string `json:"resourceProviderNamespace,omitempty" azure:"ro"`
}

// ReturnOrderItemDetails - Return order item request body
type ReturnOrderItemDetails struct {
	// REQUIRED; Return Reason.
	ReturnReason *string `json:"returnReason,omitempty"`

	// customer return address.
	ReturnAddress *AddressProperties `json:"returnAddress,omitempty"`

	// Service tag (located on the bottom-right corner of the device)
	ServiceTag *string `json:"serviceTag,omitempty"`

	// Shipping Box required
	ShippingBoxRequired *bool `json:"shippingBoxRequired,omitempty"`
}

// ReverseShippingDetails - Reverse shipment details.
type ReverseShippingDetails struct {
	// READ-ONLY; Carrier Name for display purpose. Not to be used for any processing.
	CarrierDisplayName *string `json:"carrierDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty" azure:"ro"`

	// READ-ONLY; SAS key to download the reverse shipment label of the package.
	SasKeyForLabel *string `json:"sasKeyForLabel,omitempty" azure:"ro"`

	// READ-ONLY; TrackingId of the package
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`

	// READ-ONLY; TrackingUrl of the package.
	TrackingURL *string `json:"trackingUrl,omitempty" azure:"ro"`
}

// ShippingAddress - Shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// REQUIRED; Name of the Country.
	Country *string `json:"country,omitempty"`

	// REQUIRED; Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`

	// Type of address.
	AddressType *AddressType `json:"addressType,omitempty"`

	// Name of the City.
	City *string `json:"city,omitempty"`

	// Name of the company.
	CompanyName *string `json:"companyName,omitempty"`

	// Postal code.
	PostalCode *string `json:"postalCode,omitempty"`

	// Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`

	// Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`

	// Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`

	// Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
}

// ShippingDetails - Package shipping details
type ShippingDetails struct {
	// READ-ONLY; Carrier Name for display purpose. Not to be used for any processing.
	CarrierDisplayName *string `json:"carrierDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty" azure:"ro"`

	// READ-ONLY; TrackingId of the package
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`

	// READ-ONLY; TrackingUrl of the package.
	TrackingURL *string `json:"trackingUrl,omitempty" azure:"ro"`
}

// Specifications of the configurations
type Specification struct {
	// READ-ONLY; Name of the specification
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Value of the specification
	Value *string `json:"value,omitempty" azure:"ro"`
}

// StageDetails - Resource stage details.
type StageDetails struct {
	// READ-ONLY; Display name of the resource stage.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Stage name
	StageName *StageName `json:"stageName,omitempty" azure:"ro"`

	// READ-ONLY; Stage status.
	StageStatus *StageStatus `json:"stageStatus,omitempty" azure:"ro"`

	// READ-ONLY; Stage start time
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransportPreferences - Preferences related to the shipment logistics of the sku
type TransportPreferences struct {
	// REQUIRED; Indicates Shipment Logistics type that the customer preferred.
	PreferredShipmentType *TransportShipmentTypes `json:"preferredShipmentType,omitempty"`
}
