//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armalertsmanagement

import "encoding/json"

func unmarshalActionClassification(rawMsg json.RawMessage) (ActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ActionClassification
	switch m["actionType"] {
	case string(ActionTypeAddActionGroups):
		b = &AddActionGroups{}
	case string(ActionTypeRemoveAllActionGroups):
		b = &RemoveAllActionGroups{}
	default:
		b = &Action{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalActionClassificationArray(rawMsg json.RawMessage) ([]ActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ActionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalActionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAlertsMetaDataPropertiesClassification(rawMsg json.RawMessage) (AlertsMetaDataPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AlertsMetaDataPropertiesClassification
	switch m["metadataIdentifier"] {
	case string(MetadataIdentifierMonitorServiceList):
		b = &MonitorServiceList{}
	default:
		b = &AlertsMetaDataProperties{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRecurrenceClassification(rawMsg json.RawMessage) (RecurrenceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RecurrenceClassification
	switch m["recurrenceType"] {
	case string(RecurrenceTypeDaily):
		b = &DailyRecurrence{}
	case string(RecurrenceTypeMonthly):
		b = &MonthlyRecurrence{}
	case string(RecurrenceTypeWeekly):
		b = &WeeklyRecurrence{}
	default:
		b = &Recurrence{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRecurrenceClassificationArray(rawMsg json.RawMessage) ([]RecurrenceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]RecurrenceClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalRecurrenceClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
