# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor diagnostic-settings subscription create",
)
class Create(AAZCommand):
    """Create subscription diagnostic settings for the specified resource.

    :example: Create diagnostic settings for a subscription with EventHub.
        az monitor diagnostic-settings subscription create -n {name} --location westus --event-hub-auth-rule {eventHubRuleID} --storage-account {storageAccount} --logs "[{category:Security,enabled:true},{category:Administrative,enabled:true},{category:ServiceHealth,enabled:true},{category:Alert,enabled:true},{category:Recommendation,enabled:true},{category:Policy,enabled:true},{category:Autoscale,enabled:true},{category:ResourceHealth,enabled:true}]"
    """

    _aaz_info = {
        "version": "2017-05-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.insights/diagnosticsettings/{}", "2017-05-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the diagnostic setting.",
            required=True,
            id_part="name",
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location of the resource",
        )
        _args_schema.event_hub_auth_rule = AAZStrArg(
            options=["--event-hub-auth-rule"],
            help="The resource Id for the event hub authorization rule.",
        )
        _args_schema.event_hub_name = AAZStrArg(
            options=["--event-hub-name"],
            help="The name of the event hub. If none is specified, the default event hub will be selected.",
        )
        _args_schema.logs = AAZListArg(
            options=["--logs"],
            help="JSON encoded list of logs settings. Use '@{file}' to load from a file.",
        )
        _args_schema.service_bus_rule = AAZStrArg(
            options=["--service-bus-rule"],
            help="The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format '{service bus resourceID}/authorizationrules/{key name}'.",
        )
        _args_schema.storage_account = AAZStrArg(
            options=["--storage-account"],
            help="The resource id of the storage account to which you would like to send the Activity Log.",
        )
        _args_schema.workspace = AAZStrArg(
            options=["--workspace"],
            help="The resource id of the log analytics workspace.",
        )

        logs = cls._args_schema.logs
        logs.Element = AAZObjectArg()

        _element = cls._args_schema.logs.Element
        _element.category = AAZStrArg(
            options=["category"],
            help="Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.",
        )
        _element.enabled = AAZBoolArg(
            options=["enabled"],
            help="a value indicating whether this log is enabled.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SubscriptionDiagnosticSettingsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SubscriptionDiagnosticSettingsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/microsoft.insights/diagnosticSettings/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-05-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("eventHubAuthorizationRuleId", AAZStrType, ".event_hub_auth_rule")
                properties.set_prop("eventHubName", AAZStrType, ".event_hub_name")
                properties.set_prop("logs", AAZListType, ".logs")
                properties.set_prop("serviceBusRuleId", AAZStrType, ".service_bus_rule")
                properties.set_prop("storageAccountId", AAZStrType, ".storage_account")
                properties.set_prop("workspaceId", AAZStrType, ".workspace")

            logs = _builder.get(".properties.logs")
            if logs is not None:
                logs.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.logs[]")
            if _elements is not None:
                _elements.set_prop("category", AAZStrType, ".category")
                _elements.set_prop("enabled", AAZBoolType, ".enabled", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType()
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.event_hub_authorization_rule_id = AAZStrType(
                serialized_name="eventHubAuthorizationRuleId",
            )
            properties.event_hub_name = AAZStrType(
                serialized_name="eventHubName",
            )
            properties.logs = AAZListType()
            properties.service_bus_rule_id = AAZStrType(
                serialized_name="serviceBusRuleId",
            )
            properties.storage_account_id = AAZStrType(
                serialized_name="storageAccountId",
            )
            properties.workspace_id = AAZStrType(
                serialized_name="workspaceId",
            )

            logs = cls._schema_on_200.properties.logs
            logs.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.logs.Element
            _element.category = AAZStrType()
            _element.enabled = AAZBoolType(
                flags={"required": True},
            )

            return cls._schema_on_200


__all__ = ["Create"]
