#define IN_MAIN  /* so that global vars in header.h will not be external */
#include "Header.h"
#include "Dp.h"

#include <unistd.h>  /* for gethostname() and getopt() */

#define VERSION "1.3.4"
#define VDATE "Feb 2000"

 int First_order;
 int Domain_size;
 void read_gen_clauses_sorted(FILE *fp, int n, int d, int x);
 int Save_interval;
 FILE *Save_file;
 FILE *Restore_file;
 int Experiment;
 int Sorted_input;

/*************
 *
 *    void print_banner(argc, argv)
 *
 *************/

static void print_banner(int argc, char **argv)
{
    int i;
    char host[64];

#ifdef TP_HOST
    if (gethostname(host, 64) != 0)
#endif
	strcpy(host, "???");

    printf("----- MACE %s, %s -----\n", VERSION, VDATE);
    printf("The job began on %s, %s", host, get_time());
    printf("The command was \"");
    for(i = 0; i < argc; i++)
        printf("%s%s", argv[i], (i < argc-1 ? " " : ""));
    printf("\".\n\n");
    
}  /* print_banner */

/*************
 *
 *   usage_message()
 *
 *************/

void usage_message()
{
    printf("\nDP %s -- Davis-Putnam procedure for propositional logic.\n\n", VERSION);
    printf("\nInput clauses are taken from standard input.\n");
    printf("\ncommand-line options:\n");
    printf("   -s      | Perform unit subsumption. (Always done on input.)\n");
    printf("   -p      | Print models as they are found.\n");
    printf("   -P      | Print models in portable format as they are found.\n");
    printf("   -I      | Print models in IVY format as they are found.\n");
    printf("   -z      | Sorted first_order input.\n");
    printf("   -m n    | Stop when the n-th model is found.\n");
    printf("   -t n    | Stop after n seconds.\n");
    printf("   -k n    | Tp_allocate at most n K bytes.\n");
    printf("   -n n    | Read general clauses and use domain size n.\n");
    printf("   -c      | Assume constants are distinct (up to n).\n");
    printf("   -x 1    | Quasigroup constraint on last column of f/2.\n");
    printf("   -x n    | Experiment n.\n");
    /* printf("   -d n    | Maximum depth of search.\n"); */
    printf("   -b n    | Save assignments every n seconds.\n");
    printf("   -B file | Save assignments to file.\n");
    printf("   -R file | Restore assignments from file (must also give\n"
           "             ordinary input, exactly as in the original search).\n");
    printf("   -h      | Print this message.\n");
    printf("\n");
}  /* usage_message */

/*************
 *
 *   process_command_line_args()
 *
 *************/

int process_command_line_args(int argc, char **argv)
{
    extern char *optarg;

    int c, n;
    int error = 0;

    while ((c = getopt(argc, argv, "spPIhzcm:t:k:n:b:B:R:d:x:")) != EOF) {
	switch (c) {
	  case 'c':
	    change_flag(stderr, "distinct_constants", 1);
	    break;
	  case 's':
	    change_flag(stderr, "subsume", 1);
	    break;
	  case 'p':
	    change_flag(stderr, "print_models", 1);
	    break;
	  case 'P':
	    change_flag(stderr, "print_models_portable", 1);
	    break;
	  case 'I':
	    change_flag(stderr, "print_models_ivy", 1);
	    break;
	  case 'z':
	    Sorted_input = 1;
	    First_order = 1;
	    break;
	  case 'x':
	    n = atoi(optarg);
	    Experiment = n;
	    break;
	  case 'm':
	    n = atoi(optarg);
	    if (change_parm(stderr, "max_models", n) == -1)
		error++;
	    break;
	  case 't':
	    n = atoi(optarg);
	    if (change_parm(stderr, "max_seconds", n) == -1)
		error++;
	    break;
	  case 'k':
	    n = atoi(optarg);
	    if (change_parm(stderr, "max_mem", n) == -1)
		error++;
	    break;
	  case 'n':
	    n = atoi(optarg);
	    if (n < 1) {
		fprintf(stderr, "Domain size must be > 0.\n");
		error++;
		}
	    else {
		First_order = 1;
		Domain_size = n;
		}
	    break;
	  case 'b':
	    n = atoi(optarg);
	    Save_interval = n;
	    break;
	  case 'B':
	    Save_file = fopen(optarg, "w");
	    break;
	  case 'R':
	    Restore_file = fopen(optarg, "r");
	    if (!Restore_file) {
		fprintf(stderr, "File %s not found.\n", optarg);
		error++;
		}
	    break;
	  case 'h':
	  case '?':
	  default:
	    error = 1;
	    break;
	    }
	}

    /* Check for inconsistent options. */

    if (Save_interval == 0 && Save_file != NULL) {
	fprintf(stderr, "\nNeed save interval (-b seconds).\n");
	error++;
	}
    else if (Save_interval > 0 && Save_file == NULL) {
	fprintf(stderr, "\nNeed save file (-B file).\n");
	error++;
	}

    if (Sorted_input && Flags[DISTINCT_CONSTANTS].val) {
	fprintf(stderr, "\nSorted input and distinct constants are incompatible.\n");
	}
	
    return(error == 0);
}  /* process_command_line_args */

/*************
 *
 *    main
 *
 *************/

int main(int argc, char **argv)
{
    int rc;

    init_dp();
    rc = process_command_line_args(argc, argv);
    if (!rc) {
	usage_message();
	exit(0);
	}

    print_banner(argc, argv);

    CLOCK_START(INPUT_TIME)
    if (Domain_size > 0) {
	if (Parms[MAX_TP_SECONDS].val < INT_MAX)
	    fprintf(stderr, "Time limit ignored during clause generation.\n");
	read_gen_clauses_sorted(stdin, Domain_size, Flags[DISTINCT_CONSTANTS].val,
				Experiment);
	}
    else if (Sorted_input)
	read_gen_clauses_sorted(stdin, 0, 0, Experiment);
    else
	rc = read_all_clauses(stdin);
    rc = more_setup();
    CLOCK_STOP(INPUT_TIME)

    CLOCK_START(DECIDE_TIME)
    rc = dp_prover();
    CLOCK_STOP(DECIDE_TIME)

    output_stats(stdout);

    exit(rc);

}  /* main */





