# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Source message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
    ##
    class Source < Message
      ##
      # The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
      # of the source, typically a file path relative to the root directory
      ##
      attr_reader :uri

      ##
      # The contents of the file
      ##
      attr_reader :data

      ##
      # The media type of the file. Can be used to specify custom types, such as
      # text/x.cucumber.gherkin+plain
      ##
      attr_reader :media_type

      def initialize(
        uri: '',
        data: '',
        media_type: SourceMediaType::TEXT_X_CUCUMBER_GHERKIN_PLAIN
      )
        @uri = uri
        @data = data
        @media_type = media_type
        super()
      end

      ##
      # Returns a new Source from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Source.from_h(some_hash) # => #<Cucumber::Messages::Source:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          uri: hash[:uri],
          data: hash[:data],
          media_type: hash[:mediaType]
        )
      end
    end
  end
end
