\name{VotingBinaryIterativeHoleFillingImageFilter}
\alias{VotingBinaryIterativeHoleFillingImageFilter}
\title{VotingBinaryIterativeHoleFillingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Fills in holes and cavities by iteratively applying a voting
operation.
VotingBinaryIterativeHoleFillingImageFilter}
\details{
This filter uses internally the VotingBinaryHoleFillingImageFilter , and runs it iteratively until no pixels are being changed or until
it reaches the maximum number of iterations. The purpose of the filter
is to fill in holes of medium size (tens of pixels in radius). In
principle the number of iterations is related to the size of the holes
to be filled in. The larger the holes, the more iteration must be run
with this filter in order to fill in the full hole. The size of the
neighborhood is also related to the curvature of the hole borders and
therefore the hole size. Note that as a collateral effect this filter
may also fill in cavities in the external side of structures.
This filter is templated over a single image type because the output
image type must be the same as the input image type. This is required
in order to make the iterations possible, since the output image of
one iteration is taken as the input image for the next iteration.
See:
Image
VotingBinaryImageFilter
VotingBinaryHoleFillingImageFilter
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
VotingBinaryIterativeHoleFilling for the procedural interface
itk::VotingBinaryIterativeHoleFillingImageFilter for the Doxygen on the original ITK class.
VotingBinaryIterativeHoleFillingImageFilter}
%C++ includes: sitkVotingBinaryIterativeHoleFillingImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Get the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{double GetForegroundValue() const:}{
Get the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{unsigned int GetMajorityThreshold() const:}{
Majority threshold. It is the number of pixels over 50\% that will
decide whether an OFF pixel will become ON or not. For example, if the
neighborhood of a pixel has 124 pixels (excluding itself), the 50\%
will be 62, and if you set up a Majority threshold of 5, that means
that the filter will require 67 or more neighbor pixels to be ON in
order to switch the current OFF pixel to ON. The default value is 1.
}
\item{unsigned int GetMaximumNumberOfIterations() const:}{
Maximum number of iterations. This filter is executed iteratively as
long as at least one pixel has changed in a previous iteration, or
until the maximum number of iterations has been reached.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{
Get the radius of the neighborhood used to compute the median
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{Self SetMajorityThreshold(unsigned int MajorityThreshold):}{
Majority threshold. It is the number of pixels over 50\% that will
decide whether an OFF pixel will become ON or not. For example, if the
neighborhood of a pixel has 124 pixels (excluding itself), the 50\%
will be 62, and if you set up a Majority threshold of 5, that means
that the filter will require 67 or more neighbor pixels to be ON in
order to switch the current OFF pixel to ON. The default value is 1.
}
\item{Self SetMaximumNumberOfIterations(unsigned int MaximumNumberOfIterations):}{
Maximum number of iterations. This filter is executed iteratively as
long as at least one pixel has changed in a previous iteration, or
until the maximum number of iterations has been reached.
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{
Set the radius of the neighborhood used to compute the median.
}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ VotingBinaryIterativeHoleFillingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~VotingBinaryIterativeHoleFillingImageFilter():}{
Destructor
}
}
}
