/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JToolTip;
import javax.swing.border.Border;

public class StyledToolTip
extends JToolTip {
    private final StyledLabel label = new StyledLabel();

    public StyledToolTip() {
        this.label.setHorizontalTextPosition(0);
        this.label.setVerticalTextPosition(0);
        this.setLayout(new BorderLayout());
        this.add(this.label);
    }

    @Override
    public void setBorder(Border border) {
        if (border == null) {
            super.setBorder(null);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getTipText() != null) {
            Insets insets = this.getInsets();
            Dimension size = this.label.getPreferredSize();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }
        return super.getPreferredSize();
    }

    @Override
    public void setTipText(String tipText) {
        super.setTipText(tipText != null ? "" : null);
        StyledLabelBuilder.setStyledText(this.label, tipText != null ? tipText : "");
        this.revalidate();
    }
}

