/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.IkonResolver;

public class AbstractIkonResolver
implements IkonResolver {
    private static final String ORG_KORDAMP_IKONLI_STRICT = "org.kordamp.ikonli.strict";
    private static final Logger LOGGER = Logger.getLogger(AbstractIkonResolver.class.getName());
    protected final Set<IkonHandler> handlers = new CopyOnWriteArraySet<IkonHandler>();
    protected final Set<IkonHandler> customHandlers = new CopyOnWriteArraySet<IkonHandler>();

    @Override
    public boolean registerHandler(IkonHandler handler) {
        Objects.requireNonNull(handler, "Handler must not be null");
        if (this.isHandlerLoadedViaClasspath(handler)) {
            this.throwOrWarn(String.format("IkonHandler for %s is already loaded via classpath", handler.getFontFamily()));
            return false;
        }
        return this.customHandlers.add(handler);
    }

    @Override
    public boolean unregisterHandler(IkonHandler handler) {
        Objects.requireNonNull(handler, "Handler must not be null");
        if (this.isHandlerLoadedViaClasspath(handler)) {
            this.throwOrWarn(String.format("IkonHandler for %s was loaded via classpath and can't be unregistered", handler.getFontFamily()));
            return false;
        }
        return this.customHandlers.remove(handler);
    }

    @Override
    public IkonHandler resolve(String value) {
        Objects.requireNonNull(value, "Ikon description must not be null");
        return this.findHandler(value).orElseThrow(() -> new UnsupportedOperationException("Cannot resolve '" + value + "'"));
    }

    protected Optional<IkonHandler> findHandler(String value) {
        return Arrays.asList(this.handlers, this.customHandlers).stream().flatMap(Collection::stream).filter(handler -> handler.supports(value)).findFirst();
    }

    private boolean isHandlerLoadedViaClasspath(IkonHandler handler) {
        return this.handlers.stream().anyMatch(h -> h.getFontFamily().equals(handler.getFontFamily()));
    }

    private void throwOrWarn(String message) {
        if (Boolean.getBoolean(ORG_KORDAMP_IKONLI_STRICT)) {
            throw new IllegalArgumentException(message);
        }
        LOGGER.warning(message);
    }

    public static ServiceLoader<IkonHandler> resolveServiceLoader() {
        ServiceLoader<IkonHandler> ikonHandlerServiceLoaders;
        if (null != IkonHandler.class.getModule().getLayer() && (ikonHandlerServiceLoaders = ServiceLoader.load(IkonHandler.class.getModule().getLayer(), IkonHandler.class)).findFirst().isPresent()) {
            return ikonHandlerServiceLoaders;
        }
        ServiceLoader<IkonHandler> handlers = ServiceLoader.load(IkonHandler.class, IkonHandler.class.getClassLoader());
        return handlers.findFirst().isPresent() ? handlers : ServiceLoader.load(IkonHandler.class);
    }
}

