/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.Arrays;
import java.util.Objects;

public class ComparableEvent
implements Comparable<ComparableEvent> {
    public int outcome;
    public int[] predIndexes;
    public int seen = 1;
    public float[] values;

    public ComparableEvent(int oc, int[] pids, float[] values) {
        this.outcome = oc;
        this.values = values;
        this.predIndexes = pids;
    }

    public ComparableEvent(int oc, int[] pids) {
        this(oc, pids, null);
    }

    @Override
    public int compareTo(ComparableEvent ce) {
        int compareOutcome = Integer.compare(this.outcome, ce.outcome);
        if (compareOutcome != 0) {
            return compareOutcome;
        }
        int smallerLength = StrictMath.min(this.predIndexes.length, ce.predIndexes.length);
        for (int i = 0; i < smallerLength; ++i) {
            float compareValues;
            int comparePredIndexes = Integer.compare(this.predIndexes[i], ce.predIndexes[i]);
            if (comparePredIndexes != 0) {
                return comparePredIndexes;
            }
            if (!(this.values != null && ce.values != null ? !Float.valueOf(compareValues = (float)Float.compare(this.values[i], ce.values[i])).equals(Float.valueOf(0.0f)) : (this.values != null ? !Float.valueOf(compareValues = (float)Float.compare(this.values[i], 1.0f)).equals(Float.valueOf(0.0f)) : ce.values != null && !Float.valueOf(compareValues = (float)Float.compare(1.0f, ce.values[i])).equals(Float.valueOf(0.0f))))) continue;
            return (int)compareValues;
        }
        return Integer.compare(this.predIndexes.length, ce.predIndexes.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComparableEvent) {
            ComparableEvent other = (ComparableEvent)obj;
            return this.outcome == other.outcome && Arrays.equals(this.predIndexes, other.predIndexes) && this.seen == other.seen && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.outcome, Arrays.hashCode(this.predIndexes), this.seen, Arrays.hashCode(this.values));
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.outcome).append(":");
        for (int i = 0; i < this.predIndexes.length; ++i) {
            s.append(" ").append(this.predIndexes[i]);
            if (this.values == null) continue;
            s.append("=").append(this.values[i]);
        }
        return s.toString();
    }
}

