/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.instruction;

import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LoadInstruction
extends Instruction {
    public int slot();

    public TypeKind typeKind();

    public static LoadInstruction of(TypeKind kind, int slot) {
        Opcode opcode = BytecodeHelpers.loadOpcode(kind, slot);
        return new AbstractInstruction.UnboundLoadInstruction(opcode, slot);
    }

    public static LoadInstruction of(Opcode op, int slot) {
        Util.checkKind(op, Opcode.Kind.LOAD);
        BytecodeHelpers.validateSlot(op, slot, true);
        return new AbstractInstruction.UnboundLoadInstruction(op, slot);
    }
}

