/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel;

import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ResolutionState;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Describable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

public class GradleDependencyReportGenerator {
    private final AtomicLong nextId = new AtomicLong();

    public DependencyScopeNode buildDependencyGraph(@NotNull Configuration configuration, @NotNull Project project) {
        if (configuration == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(1);
        }
        IdGenerator idGenerator = new IdGenerator(this.nextId);
        ResolutionResult resolutionResult = configuration.getIncoming().getResolutionResult();
        ResolvedComponentResult root = resolutionResult.getRoot();
        String configurationName = configuration.getName();
        long id = idGenerator.getId(root.getId());
        String scopeDisplayName = "project " + project.getPath() + " (" + configurationName + ")";
        DependencyScopeNode node = new DependencyScopeNode(id, configurationName, scopeDisplayName, configuration.getDescription());
        node.setResolutionState(ResolutionState.RESOLVED);
        for (Dependency dependency : configuration.getAllDependencies()) {
            Set files;
            FileCollection fileCollection;
            if (!(dependency instanceof FileCollectionDependency) || (fileCollection = ((FileCollectionDependency)dependency).getFiles()) instanceof Configuration || (files = fileCollection.getFiles()).isEmpty()) continue;
            String displayName = null;
            if (fileCollection instanceof Describable) {
                displayName = ((Describable)fileCollection).getDisplayName();
            } else {
                String string = fileCollection.toString();
                if (!"file collection".equals(string)) {
                    displayName = string;
                }
            }
            if (displayName != null) {
                long fileDepId = idGenerator.getId(displayName);
                node.getDependencies().add(new FileCollectionDependencyNodeImpl(fileDepId, displayName, fileCollection.getAsPath()));
                continue;
            }
            for (File file : files) {
                long fileDepId = idGenerator.getId(file.getPath());
                node.getDependencies().add(new FileCollectionDependencyNodeImpl(fileDepId, file.getName(), file.getPath()));
            }
        }
        LinkedHashMap<Object, DependencyNode> added = new LinkedHashMap<Object, DependencyNode>();
        for (DependencyResult child : root.getDependencies()) {
            node.getDependencies().add(GradleDependencyReportGenerator.buildDependencyNode(child, added, idGenerator));
        }
        return node;
    }

    private static DependencyNode buildDependencyNode(DependencyResult dependency, Map<Object, DependencyNode> added, IdGenerator idGenerator) {
        if (dependency instanceof ResolvedDependencyResult) {
            return GradleDependencyReportGenerator.buildResolvedDependencyNode((ResolvedDependencyResult)dependency, added, idGenerator);
        }
        if (dependency instanceof UnresolvedDependencyResult) {
            return GradleDependencyReportGenerator.buildUnresolvedDependencyNode((UnresolvedDependencyResult)dependency, added, idGenerator);
        }
        throw new IllegalStateException("Unsupported dependency result type: " + dependency);
    }

    @NotNull
    private static DependencyNode buildResolvedDependencyNode(@NotNull ResolvedDependencyResult dependency, @NotNull Map<Object, DependencyNode> added, @NotNull IdGenerator idGenerator) {
        List descriptions;
        UnknownDependencyNode node;
        ResolvedComponentResult resolvedComponent;
        ComponentIdentifier componentId;
        long id;
        if (dependency == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(2);
        }
        if (added == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(3);
        }
        if (idGenerator == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(4);
        }
        if (added.containsKey(id = idGenerator.getId(componentId = (resolvedComponent = dependency.getSelected()).getId()))) {
            return new ReferenceNode(id);
        }
        if (componentId instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)componentId;
            String projectName = projectId.getProjectName();
            String projectPath = projectId.getProjectPath();
            node = new ProjectDependencyNodeImpl(id, projectName, projectPath);
        } else if (componentId instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)componentId;
            node = new ArtifactDependencyNodeImpl(id, moduleId.getGroup(), moduleId.getModule(), moduleId.getVersion());
        } else {
            node = new UnknownDependencyNode(id, componentId.getDisplayName());
        }
        node.setResolutionState(ResolutionState.RESOLVED);
        ComponentSelectionReason selectionReason = resolvedComponent.getSelectionReason();
        if (DefaultGroovyMethods.asBoolean((Object)DefaultGroovyMethods.hasProperty((Object)selectionReason, (String)"descriptions")) && !(descriptions = selectionReason.getDescriptions()).isEmpty()) {
            node.setSelectionReason(((ComponentSelectionDescriptor)DefaultGroovyMethods.last((List)descriptions)).getDescription());
        }
        added.put(id, (DependencyNode)node);
        for (DependencyResult child : resolvedComponent.getDependencies()) {
            node.getDependencies().add(GradleDependencyReportGenerator.buildDependencyNode(child, added, idGenerator));
        }
        UnknownDependencyNode unknownDependencyNode = node;
        if (unknownDependencyNode == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(5);
        }
        return unknownDependencyNode;
    }

    @NotNull
    private static DependencyNode buildUnresolvedDependencyNode(@NotNull UnresolvedDependencyResult dependency, @NotNull Map<Object, DependencyNode> added, @NotNull IdGenerator idGenerator) {
        ComponentSelector attempted;
        long id;
        if (dependency == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(6);
        }
        if (added == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(7);
        }
        if (idGenerator == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(8);
        }
        if (added.containsKey(id = idGenerator.getId(attempted = dependency.getAttempted()))) {
            return new ReferenceNode(id);
        }
        UnknownDependencyNode node = new UnknownDependencyNode(id, attempted.getDisplayName());
        node.setResolutionState(ResolutionState.UNRESOLVED);
        added.put(id, (DependencyNode)node);
        UnknownDependencyNode unknownDependencyNode = node;
        if (unknownDependencyNode == null) {
            GradleDependencyReportGenerator.$$$reportNull$$$0(9);
        }
        return unknownDependencyNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idGenerator";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/dependencyGraphModel/GradleDependencyReportGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyGraphModel/GradleDependencyReportGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResolvedDependencyNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUnresolvedDependencyNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDependencyGraph";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildResolvedDependencyNode";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildUnresolvedDependencyNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IdGenerator {
        private final HashMap<Object, Long> idMap = new HashMap();
        private final AtomicLong nextId;

        private IdGenerator(AtomicLong nextId) {
            this.nextId = nextId;
        }

        public long getId(Object key) {
            long newId = this.nextId.incrementAndGet();
            Long existingId = this.idMap.putIfAbsent(key, newId);
            if (existingId != null) {
                return existingId;
            }
            return newId;
        }
    }
}

