/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.TransformFunctions;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.AnchorSizeUnitImpl;
import io.sf.carte.doc.style.css.parser.AngleFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.AttrUnitImpl;
import io.sf.carte.doc.style.css.parser.BasicShapeUnitImpl;
import io.sf.carte.doc.style.css.parser.BufferTokenHandler;
import io.sf.carte.doc.style.css.parser.CSSContentHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ColorUnitImpl;
import io.sf.carte.doc.style.css.parser.CounterUnitImpl;
import io.sf.carte.doc.style.css.parser.EasingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ElementReferenceTH;
import io.sf.carte.doc.style.css.parser.ElementReferenceUnitImpl;
import io.sf.carte.doc.style.css.parser.EmptyUnitImpl;
import io.sf.carte.doc.style.css.parser.EnvUnitImpl;
import io.sf.carte.doc.style.css.parser.ExpressionUnitImpl;
import io.sf.carte.doc.style.css.parser.GenericFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ImageFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitFactory;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MultiArgScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.PowFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.RGBColorUnitImpl;
import io.sf.carte.doc.style.css.parser.RoundFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SqrtFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.parser.TransformFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.TypeFunctionTH;
import io.sf.carte.doc.style.css.parser.URLTokenHandler;
import io.sf.carte.doc.style.css.parser.URLUnitImpl;
import io.sf.carte.doc.style.css.parser.UnitlessFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ValueTokenHandler;
import io.sf.carte.doc.style.css.parser.VarFunctionUnitImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import java.util.HashMap;
import java.util.Map;

class FunctionFactories {
    private final Map<String, LexicalUnitFactory> factories = this.createFactoryMap();

    FunctionFactories() {
    }

    private Map<String, LexicalUnitFactory> createFactoryMap() {
        HashMap<String, LexicalUnitFactory> factories = new HashMap<String, LexicalUnitFactory>(101);
        factories.put("calc", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ExpressionUnitImpl(LexicalUnit.LexicalType.CALC);
            }
        });
        factories.put("attr", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AttrUnitImpl();
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
                LexicalUnit.LexicalType type;
                return lu.parameters != null && ((type = lu.parameters.getLexicalUnitType()) == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.VAR) && LexicalUnitFactory.super.validate(handler, index, lu);
            }
        });
        factories.put("type", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new GenericFunctionUnitImpl(LexicalUnit.LexicalType.TYPE_FUNCTION);
            }

            @Override
            public void handle(ValueTokenHandler parent, int index) {
                parent.yieldHandling(new TypeFunctionTH(parent));
                parent.prevcp = 41;
            }
        });
        factories.put("var", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new VarFunctionUnitImpl();
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                String s = currentlu.parameters.getStringValue();
                if (s == null) {
                    return false;
                }
                int len = s.length();
                if (len < 3 || s.charAt(0) != '-' || s.charAt(1) != '-') {
                    FunctionFactories.this.error(handler, index - len, "var() function must reference a custom property.");
                    return false;
                }
                LexicalUnit.LexicalType lastType = CSSParser.findLastValue(currentlu.parameters).getLexicalUnitType();
                if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    FunctionFactories.this.addEmptyLexicalUnit(handler);
                }
                return true;
            }
        });
        factories.put("env", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EnvUnitImpl();
            }
        });
        factories.put("url", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new URLUnitImpl();
            }

            @Override
            public String canonicalName(String lcName) {
                return null;
            }

            @Override
            public void handle(final ValueTokenHandler parent, int index) {
                URLTokenHandler handler = new URLTokenHandler(parent){

                    @Override
                    public void rightParenthesis(int index) {
                        super.rightParenthesis(index);
                        parent.endFunctionArgument(index);
                    }
                };
                parent.yieldHandling(handler);
                parent.prevcp = 41;
            }
        });
        factories.put("if", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new GenericFunctionUnitImpl();
            }
        });
        factories.put("matrix", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.MATRIX);
            }
        });
        factories.put("perspective", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.PERSPECTIVE);
            }
        });
        factories.put("translate", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE);
            }
        });
        factories.put("translate3d", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_3D);
            }
        });
        LexicalUnitFactory translatex = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "translateX";
            }
        };
        factories.put("translatex", translatex);
        factories.put("translateX", translatex);
        LexicalUnitFactory translatey = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "translateY";
            }
        };
        factories.put("translatey", translatey);
        factories.put("translateY", translatey);
        LexicalUnitFactory translatez = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.TRANSLATE_Z);
            }

            @Override
            public String canonicalName(String lcName) {
                return "translateZ";
            }
        };
        factories.put("translatez", translatez);
        factories.put("translateZ", translatez);
        factories.put("scale", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE);
            }
        });
        factories.put("scale3d", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_3D);
            }
        });
        LexicalUnitFactory scalex = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "scaleX";
            }
        };
        factories.put("scalex", scalex);
        factories.put("scaleX", scalex);
        LexicalUnitFactory scaley = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "scaleY";
            }
        };
        factories.put("scaley", scaley);
        factories.put("scaleY", scaley);
        LexicalUnitFactory scalez = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SCALE_Z);
            }

            @Override
            public String canonicalName(String lcName) {
                return "scaleZ";
            }
        };
        factories.put("scalez", scalez);
        factories.put("scaleZ", scalez);
        factories.put("rotate", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE);
            }
        });
        factories.put("rotate3d", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_3D);
            }
        });
        LexicalUnitFactory rotatex = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "rotateX";
            }
        };
        factories.put("rotatex", rotatex);
        factories.put("rotateX", rotatex);
        LexicalUnitFactory rotatey = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "rotateY";
            }
        };
        factories.put("rotatey", rotatey);
        factories.put("rotateY", rotatey);
        LexicalUnitFactory rotatez = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.ROTATE_Z);
            }

            @Override
            public String canonicalName(String lcName) {
                return "rotateZ";
            }
        };
        factories.put("rotatez", rotatez);
        factories.put("rotateZ", rotatez);
        factories.put("skew", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SKEW);
            }
        });
        LexicalUnitFactory skewx = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SKEW_X);
            }

            @Override
            public String canonicalName(String lcName) {
                return "skewX";
            }
        };
        factories.put("skewx", skewx);
        factories.put("skewX", skewx);
        LexicalUnitFactory skewy = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new TransformFunctionUnitImpl(TransformFunctions.SKEW_Y);
            }

            @Override
            public String canonicalName(String lcName) {
                return "skewY";
            }
        };
        factories.put("skewy", skewy);
        factories.put("skewY", skewy);
        factories.put("src", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.SRC);
            }
        });
        factories.put("image-set", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ImageFunctionUnitImpl(LexicalUnit.LexicalType.IMAGE_SET);
            }
        });
        factories.put("element", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ElementReferenceUnitImpl();
            }

            @Override
            public String canonicalName(String lcName) {
                return null;
            }

            @Override
            public void handle(ValueTokenHandler parent, int index) {
                parent.yieldHandling(new ElementReferenceTH(parent));
                parent.prevcp = 41;
            }
        });
        factories.put("circle", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.CIRCLE_FUNCTION);
            }
        });
        factories.put("ellipse", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.ELLIPSE_FUNCTION);
            }
        });
        factories.put("inset", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.INSET_FUNCTION);
            }
        });
        factories.put("path", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.PATH_FUNCTION);
            }
        });
        factories.put("polygon", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.POLYGON_FUNCTION);
            }
        });
        factories.put("rect", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.RECT_FUNCTION);
            }
        });
        factories.put("shape", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.SHAPE_FUNCTION);
            }
        });
        factories.put("xywh", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new BasicShapeUnitImpl(LexicalUnit.LexicalType.XYWH_FUNCTION);
            }
        });
        factories.put("counter", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new CounterUnitImpl(LexicalUnit.LexicalType.COUNTER_FUNCTION);
            }
        });
        factories.put("counters", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new CounterUnitImpl(LexicalUnit.LexicalType.COUNTERS_FUNCTION);
            }
        });
        factories.put("cubic-bezier", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EasingFunctionUnitImpl(LexicalUnit.LexicalType.CUBIC_BEZIER_FUNCTION);
            }
        });
        factories.put("linear", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EasingFunctionUnitImpl(LexicalUnit.LexicalType.LINEAR_FUNCTION);
            }
        });
        factories.put("steps", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new EasingFunctionUnitImpl(LexicalUnit.LexicalType.STEPS_FUNCTION);
            }
        });
        LexicalUnitFactory rgb = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new RGBColorUnitImpl();
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
                return FunctionFactories.this.isValidRGBColor(handler, index, lu);
            }
        };
        factories.put("rgb", rgb);
        factories.put("rgba", rgb);
        LexicalUnitFactory hsl = new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.HSLCOLOR);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
                return FunctionFactories.this.isValidHSLColor(handler, index, lu);
            }
        };
        factories.put("hsl", hsl);
        factories.put("hsla", hsl);
        factories.put("lab", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.LABCOLOR);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLabColor(handler, index, currentlu, 100, 100.0f);
            }
        });
        factories.put("lch", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.LCHCOLOR);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLCHColor(handler, index, currentlu, 100, 100.0f);
            }
        });
        factories.put("oklab", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.OKLABCOLOR);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLabColor(handler, index, currentlu, 1, 1.0f);
            }
        });
        factories.put("oklch", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.OKLCHCOLOR);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidLCHColor(handler, index, currentlu, 1, 1.0f);
            }
        });
        factories.put("hwb", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.HWBCOLOR);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidHWBColor(handler, index, currentlu);
            }
        });
        factories.put("color", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.COLOR_FUNCTION);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidColorFunction(handler, index, currentlu);
            }
        });
        factories.put("color-mix", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ColorUnitImpl(LexicalUnit.LexicalType.COLOR_MIX);
            }

            @Override
            public boolean validate(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
                return FunctionFactories.this.isValidColorMixFunction(index, currentlu);
            }
        });
        factories.put("abs", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ABS);
            }
        });
        factories.put("clamp", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.CLAMP);
            }
        });
        factories.put("max", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.MAX);
            }
        });
        factories.put("min", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.MIN);
            }
        });
        factories.put("round", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new RoundFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ROUND);
            }
        });
        factories.put("mod", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.MOD);
            }
        });
        factories.put("rem", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.REM);
            }
        });
        factories.put("hypot", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.HYPOT);
            }
        });
        factories.put("hypot2", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(CSSMathFunctionValue.MathFunction.HYPOT2);
            }
        });
        factories.put("log", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.LOG);
            }
        });
        factories.put("exp", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.EXP);
            }
        });
        factories.put("sqrt", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new SqrtFunctionUnitImpl(CSSMathFunctionValue.MathFunction.SQRT);
            }
        });
        factories.put("pow", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new PowFunctionUnitImpl(CSSMathFunctionValue.MathFunction.POW);
            }
        });
        factories.put("sign", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.SIGN);
            }
        });
        factories.put("sin", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.SIN);
            }
        });
        factories.put("cos", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.COS);
            }
        });
        factories.put("tan", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(CSSMathFunctionValue.MathFunction.TAN);
            }
        });
        factories.put("asin", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ASIN);
            }
        });
        factories.put("acos", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ACOS);
            }
        });
        factories.put("atan", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ATAN);
            }
        });
        factories.put("atan2", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(CSSMathFunctionValue.MathFunction.ATAN2);
            }
        });
        factories.put("anchor-size", new LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AnchorSizeUnitImpl();
            }
        });
        factories.put("dir", new PseudoUnitFactory("dir"));
        factories.put("has", new PseudoUnitFactory("has"));
        factories.put("is", new PseudoUnitFactory("is"));
        factories.put("lang", new PseudoUnitFactory("lang"));
        factories.put("not", new PseudoUnitFactory("not"));
        factories.put("nth-child", new PseudoUnitFactory("nth-child"));
        factories.put("nth-last-child", new PseudoUnitFactory("nth-last-child"));
        factories.put("nth-last-of-type", new PseudoUnitFactory("nth-last-of-type"));
        factories.put("nth-of-type", new PseudoUnitFactory("nth-of-type"));
        factories.put("where", new PseudoUnitFactory("where"));
        factories.put("host", new PseudoUnitFactory("host"));
        factories.put("host-context", new PseudoUnitFactory("host-context"));
        factories.put("state", new PseudoUnitFactory("state"));
        return factories;
    }

    private boolean isValidRGBColor(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
        LexicalUnitImpl lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        int valCount = 0;
        boolean hasVar = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        while (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return true;
            }
            type = lu.getLexicalUnitType();
        }
        boolean hasNoCommas = false;
        if (type == LexicalUnit.LexicalType.IDENT) {
            String s = lu.getStringValue();
            if ("from".equalsIgnoreCase(s)) {
                hasVar = false;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
                hasNoCommas = true;
            } else if (FunctionFactories.isRGBComponentName(s)) {
                valCount = 1;
            } else {
                return false;
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
        }
        LexicalUnit.LexicalType lastType = LexicalUnit.LexicalType.UNKNOWN;
        boolean hasCommas = false;
        do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case OPERATOR_COMMA: {
                    if (lastType == LexicalUnit.LexicalType.OPERATOR_COMMA || hasNoCommas || valCount == 0 && !hasVar || valCount > 1 && !hasCommas) {
                        return false;
                    }
                    hasCommas = true;
                    break;
                }
                case INTEGER: {
                    int value = lu.getIntegerValue();
                    if (value < 0) {
                        lu.intValue = 0;
                        this.warn(handler, index, "Color component has value under 0.");
                    } else if (valCount == 3 && value > 1) {
                        lu.intValue = 1;
                        this.warn(handler, index, "Color alpha has value over 1.");
                    }
                    if (value > 255) {
                        this.warn(handler, index, "Color component has value over 255.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case REAL: {
                    float fvalue = lu.getFloatValue();
                    if (fvalue < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has value under 0.");
                    } else if (fvalue > 255.0f) {
                        this.warn(handler, index, "Color component has value over 255.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case PERCENTAGE: {
                    float fvalue = lu.getFloatValue();
                    if (fvalue < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has percentage under 0%.");
                    } else if (fvalue > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(handler, index, "Color component has percentage over 100%.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case OPERATOR_SLASH: {
                    lu = lu.nextLexicalUnit;
                    if (lu == null || valCount < 3 && !hasVar || hasCommas || valCount > 3) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                case IDENT: {
                    String s = lu.getStringValue();
                    if (!FunctionFactories.isRGBComponentName(s)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                default: {
                    valCount = (short)(valCount + 1);
                }
            }
            if (!hasCommas && !hasVar && valCount > 1) {
                hasNoCommas = true;
            }
            lastType = type;
        } while ((lu = lu.nextLexicalUnit) != null);
        return valCount == 3 || valCount == 4 || hasVar && valCount < 3;
    }

    private static boolean isRGBComponentName(String s) {
        return "r".equalsIgnoreCase(s) || "g".equalsIgnoreCase(s) || "b".equalsIgnoreCase(s) || "none".equalsIgnoreCase(s) || "alpha".equalsIgnoreCase(s);
    }

    private boolean isValidHSLColor(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
        String s;
        LexicalUnitImpl lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        int valCount = 0;
        boolean hasCommas = false;
        boolean hasNoCommas = false;
        boolean hasVar = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        while (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return true;
            }
            type = lu.getLexicalUnitType();
        }
        if (type == LexicalUnit.LexicalType.IDENT) {
            s = lu.getStringValue();
            if ("from".equalsIgnoreCase(s)) {
                hasVar = false;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
                hasNoCommas = true;
            } else if (FunctionFactories.isHSLComponentName(s)) {
                valCount = 1;
            } else {
                return false;
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
        }
        if (!hasVar && valCount == 0) {
            switch (type) {
                case INTEGER: {
                    this.normalizeIntHue(handler, index, lu);
                    valCount = (short)(valCount + 1);
                    break;
                }
                case REAL: {
                    this.normalizeHue(handler, index, lu);
                    valCount = (short)(valCount + 1);
                    break;
                }
                case DIMENSION: {
                    if (this.isHueUnit(handler, index, lu)) {
                        valCount = (short)(valCount + 1);
                        break;
                    }
                    return false;
                }
                case IDENT: {
                    s = lu.getStringValue();
                    if (!FunctionFactories.isHSLComponentName(s)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                case OPERATOR_COMMA: {
                    if (hasNoCommas) {
                        return false;
                    }
                    if (hasVar) {
                        hasCommas = true;
                        break;
                    }
                }
                case PERCENTAGE: 
                case OPERATOR_SLASH: {
                    return false;
                }
                default: {
                    valCount = (short)(valCount + 1);
                }
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
        }
        do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case INTEGER: {
                    int value = lu.getIntegerValue();
                    if (value < 0) {
                        lu.intValue = 0;
                        this.warn(handler, index, "Color component has value under 0.");
                    } else if (valCount == 3 && value > 1) {
                        lu.intValue = 1;
                        this.warn(handler, index, "Color alpha has value over 1.");
                    } else if (valCount > 0 && value > 100) {
                        lu.intValue = 100;
                        this.warn(handler, index, "Peecentage component has value over 100.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case REAL: {
                    float fvalue = lu.getFloatValue();
                    if (fvalue < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has value under 0.");
                    } else if (valCount > 0 && fvalue > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(handler, index, "Peecentage component has value over 100.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case PERCENTAGE: {
                    float fvalue = lu.getFloatValue();
                    if (fvalue < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has percentage under 0%.");
                    } else if (fvalue > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(handler, index, "Color component has percentage over 100%.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case OPERATOR_COMMA: {
                    if (hasNoCommas) {
                        return false;
                    }
                    hasCommas = true;
                    break;
                }
                case OPERATOR_SLASH: {
                    lu = lu.nextLexicalUnit;
                    if (lu == null || valCount < 3 && !hasVar || hasCommas || valCount > 3) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                case IDENT: {
                    String s2 = lu.getStringValue();
                    if (!FunctionFactories.isHSLComponentName(s2)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                case CALC: 
                case MATH_FUNCTION: 
                case SUB_EXPRESSION: 
                case FUNCTION: 
                case ATTR: {
                    valCount = (short)(valCount + 1);
                    break;
                }
                case DIMENSION: {
                    if (!hasVar || valCount > 0) {
                        return false;
                    }
                    if (!this.isHueUnit(handler, index, lu)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (hasCommas || hasVar || valCount <= 1) continue;
            hasNoCommas = true;
        } while ((lu = lu.nextLexicalUnit) != null);
        return valCount == 3 || valCount == 4 || hasVar && valCount < 3;
    }

    private static boolean isHSLComponentName(String s) {
        return "h".equalsIgnoreCase(s) || "l".equalsIgnoreCase(s) || "s".equalsIgnoreCase(s) || "none".equalsIgnoreCase(s) || "alpha".equalsIgnoreCase(s);
    }

    private boolean isValidHWBColor(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
        String s;
        LexicalUnitImpl lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        int valCount = 0;
        boolean hasVar = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        while (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return true;
            }
            type = lu.getLexicalUnitType();
        }
        if (type == LexicalUnit.LexicalType.IDENT) {
            s = lu.getStringValue();
            if ("from".equalsIgnoreCase(s)) {
                hasVar = false;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
            } else if (FunctionFactories.isHWBComponentName(s)) {
                valCount = 1;
            } else {
                return false;
            }
            if ((lu = lu.nextLexicalUnit) == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
        }
        if (!hasVar && valCount == 0) {
            switch (type) {
                case INTEGER: {
                    this.normalizeIntHue(handler, index, lu);
                    valCount = (short)(valCount + 1);
                    break;
                }
                case REAL: {
                    this.normalizeHue(handler, index, lu);
                    valCount = (short)(valCount + 1);
                    break;
                }
                case DIMENSION: {
                    if (this.isHueUnit(handler, index, lu)) {
                        valCount = (short)(valCount + 1);
                        break;
                    }
                    return false;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                case IDENT: {
                    s = lu.getStringValue();
                    if (!FunctionFactories.isHSLComponentName(s)) {
                        return false;
                    }
                }
                case CALC: 
                case MATH_FUNCTION: 
                case SUB_EXPRESSION: 
                case FUNCTION: 
                case ATTR: {
                    valCount = (short)(valCount + 1);
                    break;
                }
                default: {
                    return false;
                }
            }
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
        }
        block17: do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case INTEGER: 
                case REAL: 
                case CALC: 
                case MATH_FUNCTION: 
                case SUB_EXPRESSION: 
                case FUNCTION: 
                case ATTR: {
                    valCount = (short)(valCount + 1);
                    break;
                }
                case PERCENTAGE: {
                    float fvalue = lu.getFloatValue();
                    if (fvalue < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has percentage under 0%.");
                    } else if (fvalue > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(handler, index, "Color component has percentage over 100%.");
                    }
                    valCount = (short)(valCount + 1);
                    if (valCount > 3) {
                        if (!hasVar || valCount > 4) {
                            return false;
                        }
                        return this.isValidAlpha(handler, index, lu);
                    }
                    float fval = lu.getFloatValue();
                    if (fval < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has percentage under 0%.");
                        break;
                    }
                    if (!(fval > 100.0f)) continue block17;
                    lu.floatValue = 100.0f;
                    this.warn(handler, index, "Color component has percentage over 100%.");
                    break;
                }
                case OPERATOR_SLASH: {
                    lu = lu.nextLexicalUnit;
                    if (lu == null || valCount < 3 && !hasVar || valCount > 3) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                case IDENT: {
                    String s2 = lu.getStringValue();
                    if (!FunctionFactories.isHWBComponentName(s2)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                case DIMENSION: {
                    if (!hasVar || valCount > 0) {
                        return false;
                    }
                    if (!this.isHueUnit(handler, index, lu)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                default: {
                    return false;
                }
            }
        } while ((lu = lu.nextLexicalUnit) != null);
        return valCount == 3 || valCount == 4 || hasVar && valCount < 3;
    }

    private static boolean isHWBComponentName(String s) {
        return "h".equalsIgnoreCase(s) || "w".equalsIgnoreCase(s) || "b".equalsIgnoreCase(s) || "none".equalsIgnoreCase(s) || "alpha".equalsIgnoreCase(s);
    }

    private boolean isValidLabColor(CSSContentHandler handler, int index, LexicalUnitImpl currentlu, int iUpperLightness, float fUpperLightness) {
        LexicalUnitImpl lu = currentlu.parameters;
        int valCount = 0;
        boolean hasVar = false;
        if (lu == null) {
            return false;
        }
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        while (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return true;
            }
            type = lu.getLexicalUnitType();
        }
        if (type == LexicalUnit.LexicalType.IDENT) {
            String s = lu.getStringValue();
            if ("from".equalsIgnoreCase(s)) {
                hasVar = false;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
            } else if (FunctionFactories.isLabComponentName(s)) {
                valCount = 1;
            } else {
                return false;
            }
            if ((lu = lu.nextLexicalUnit) == null) {
                return hasVar;
            }
            type = lu.getLexicalUnitType();
        }
        if (valCount == 0 && !hasVar) {
            if (type == LexicalUnit.LexicalType.PERCENTAGE) {
                float fL = lu.getFloatValue();
                if (fL < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(handler, index, "Color lightness has percentage under 0%.");
                } else if (fL > 100.0f) {
                    lu.floatValue = 100.0f;
                    this.warn(handler, index, "Color lightness has percentage over 100%.");
                }
            } else if (type == LexicalUnit.LexicalType.REAL) {
                float fL = lu.getFloatValue();
                if (fL < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(handler, index, "Color lightness has value under 0.");
                } else if (fL > fUpperLightness) {
                    lu.floatValue = fUpperLightness;
                    this.warn(handler, index, "Color lightness has value over " + fUpperLightness);
                }
            } else if (type == LexicalUnit.LexicalType.INTEGER) {
                int iL = lu.getIntegerValue();
                if (iL < 0) {
                    lu.intValue = 0;
                    this.warn(handler, index, "Color lightness has value under 0.");
                } else if (iL > iUpperLightness) {
                    lu.intValue = iUpperLightness;
                    this.warn(handler, index, "Color lightness has value over " + iUpperLightness);
                }
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.SUB_EXPRESSION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.IDENT && FunctionFactories.isLabComponentName(lu.getStringValue()))) {
                return false;
            }
            valCount = (short)(valCount + 1);
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return hasVar;
            }
        }
        block8: do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case PERCENTAGE: {
                    valCount = (short)(valCount + 1);
                    if (valCount > 3) {
                        if (!hasVar || valCount > 4) {
                            return false;
                        }
                        return this.isValidAlpha(handler, index, lu);
                    }
                    float fval = lu.getFloatValue();
                    if (fval > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(handler, index, "Color component has percentage over 100%.");
                        break;
                    }
                    if (!(fval < 0.0f) || hasVar) continue block8;
                    if (valCount == 4) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color alpha has percentage under 0%.");
                        break;
                    }
                    if (!(fval < -100.0f)) continue block8;
                    lu.floatValue = -100.0f;
                    this.warn(handler, index, "Color component has percentage under -100%.");
                    break;
                }
                case OPERATOR_SLASH: {
                    lu = lu.nextLexicalUnit;
                    if (lu == null || valCount < 3 && !hasVar || valCount > 3) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                case IDENT: {
                    String s = lu.getStringValue();
                    if (!FunctionFactories.isLabComponentName(s)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case OPERATOR_COMMA: 
                case DIMENSION: {
                    return false;
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                default: {
                    valCount = (short)(valCount + 1);
                    if (valCount < 4) continue block8;
                    if (!hasVar || valCount > 4) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
            }
        } while ((lu = lu.nextLexicalUnit) != null);
        return valCount == 3 || valCount == 4 || hasVar && valCount < 3;
    }

    private static boolean isLabComponentName(String s) {
        return "l".equalsIgnoreCase(s) || "a".equalsIgnoreCase(s) || "b".equalsIgnoreCase(s) || "none".equalsIgnoreCase(s) || "alpha".equalsIgnoreCase(s);
    }

    private boolean isValidLCHColor(CSSContentHandler handler, int index, LexicalUnitImpl currentlu, int iUpperLightness, float fUpperLightness) {
        LexicalUnitImpl lu = currentlu.parameters;
        int valCount = 0;
        boolean hasVar = false;
        if (lu == null) {
            return false;
        }
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        while (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return true;
            }
            type = lu.getLexicalUnitType();
        }
        if (type == LexicalUnit.LexicalType.IDENT) {
            String s = lu.getStringValue();
            if ("from".equalsIgnoreCase(s)) {
                hasVar = false;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
            } else if (FunctionFactories.isLCHComponentName(s)) {
                valCount = 1;
            } else {
                return false;
            }
            if ((lu = lu.nextLexicalUnit) == null) {
                return hasVar;
            }
        }
        if (valCount == 0 && !hasVar) {
            return this.isValidNonVarLCHColor(handler, index, lu, iUpperLightness, fUpperLightness);
        }
        block10: do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case PERCENTAGE: {
                    float fvalue = lu.getFloatValue();
                    if (fvalue < 0.0f) {
                        lu.floatValue = 0.0f;
                        this.warn(handler, index, "Color component has percentage under 0%.");
                    } else if (fvalue > 100.0f) {
                        lu.floatValue = 100.0f;
                        this.warn(handler, index, "Color component has percentage over 100%.");
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case REAL: {
                    if (!hasVar && valCount == 2) {
                        this.normalizeHue(handler, index, lu);
                        valCount = (short)(valCount + 1);
                        break;
                    }
                }
                case INTEGER: 
                case CALC: 
                case MATH_FUNCTION: 
                case SUB_EXPRESSION: 
                case FUNCTION: 
                case ATTR: {
                    valCount = (short)(valCount + 1);
                    if (valCount != 4) continue block10;
                    return this.isValidAlpha(handler, index, lu);
                }
                case IDENT: {
                    String s = lu.getStringValue();
                    if (!FunctionFactories.isLCHComponentName(s)) {
                        return false;
                    }
                    valCount = (short)(valCount + 1);
                    break;
                }
                case DIMENSION: {
                    short unit = lu.getCssUnit();
                    if (!CSSUnit.isAngleUnitType(unit) || valCount > 2 || valCount == 1 && !hasVar) {
                        return false;
                    }
                    this.normalizeHue(handler, index, lu);
                    valCount = (short)(valCount + 1);
                    break;
                }
                case OPERATOR_SLASH: {
                    lu = lu.nextLexicalUnit;
                    if (lu == null || valCount < 3 && !hasVar || valCount > 3) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                case VAR: {
                    hasVar = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while ((lu = lu.nextLexicalUnit) != null);
        return valCount == 3 || valCount == 4 || hasVar && valCount < 3;
    }

    private boolean isHueUnit(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
        if (CSSUnit.isAngleUnitType(lu.getCssUnit())) {
            this.normalizeHue(handler, index, lu);
            return true;
        }
        return false;
    }

    private void normalizeHue(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
        float h = lu.getFloatValue();
        short unit = lu.getCssUnit();
        float hdeg = unit != 80 && unit != 0 ? NumberValue.floatValueConversion(h, unit, (short)80) : h;
        if (Math.abs(hdeg) > 360.0f) {
            double dh = Math.IEEEremainder(hdeg, 360.0);
            if (dh < 0.0) {
                dh += 360.0;
                this.warn(handler, index, "Color hue has value under 0.");
            } else {
                this.warn(handler, index, "Color hue has value over 360.");
            }
            dh = Math.rint(dh * 10000.0) / 10000.0;
            lu.floatValue = (float)(dh += 0.0);
            lu.setUnitType(LexicalUnit.LexicalType.REAL);
            lu.setCssUnit((short)0);
            lu.dimensionUnitText = "";
        } else if (hdeg < 0.0f) {
            this.warn(handler, index, "Color hue has value under 0.");
            lu.floatValue = hdeg += 360.0f;
            lu.setUnitType(LexicalUnit.LexicalType.REAL);
            lu.setCssUnit((short)0);
            lu.dimensionUnitText = "";
        }
    }

    private void normalizeIntHue(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
        int h = lu.getIntegerValue();
        if (Math.abs(h) > 360) {
            this.warn(handler, index, "Color hue has value outside the 0-360 range.");
            lu.intValue = h = Math.floorMod(h, 360);
        } else if (h < 0) {
            this.warn(handler, index, "Color hue has value under 0.");
            lu.intValue = h += 360;
        }
    }

    private boolean isValidNonVarLCHColor(CSSContentHandler handler, int index, LexicalUnitImpl lu, int iUpperLightness, float fUpperLightness) {
        boolean hasVar = false;
        if (lu == null) {
            return false;
        }
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float fL = lu.getFloatValue();
            if (fL < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(handler, index, "Color lightness has percentage under 0%.");
            } else if (fL > 100.0f) {
                lu.floatValue = 100.0f;
                this.warn(handler, index, "Color lightness has percentage over 100%.");
            }
        } else if (type == LexicalUnit.LexicalType.REAL) {
            float fL = lu.getFloatValue();
            if (fL < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(handler, index, "Color lightness has value under 0.");
            } else if (fL > fUpperLightness) {
                lu.floatValue = fUpperLightness;
                this.warn(handler, index, "Color lightness has value over " + fUpperLightness);
            }
        } else if (type == LexicalUnit.LexicalType.INTEGER) {
            int iL = lu.getIntegerValue();
            if (iL < 0) {
                lu.intValue = 0;
                this.warn(handler, index, "Color lightness has value under 0.");
            } else if (iL > iUpperLightness) {
                lu.intValue = iUpperLightness;
                this.warn(handler, index, "Color lightness has value over " + iUpperLightness);
            }
        } else if (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
        } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.SUB_EXPRESSION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.IDENT && FunctionFactories.isLCHComponentName(lu.getStringValue()))) {
            return false;
        }
        lu = lu.nextLexicalUnit;
        if (lu == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float fC = lu.getFloatValue();
            if (fC < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(handler, index, "Color chroma has percentage under 0.");
            } else if (fC > 100.0f) {
                lu.floatValue = 100.0f;
                this.warn(handler, index, "Color chroma has percentage over 100.");
            }
        } else if (type == LexicalUnit.LexicalType.REAL) {
            float fC;
            if (!hasVar && (fC = lu.getFloatValue()) < 0.0f) {
                lu.floatValue = 0.0f;
                this.warn(handler, index, "Color chroma has value under 0.");
            }
        } else if (type == LexicalUnit.LexicalType.INTEGER) {
            int iC;
            if (!hasVar && (iC = lu.getIntegerValue()) < 0) {
                lu.intValue = 0;
                this.warn(handler, index, "Color chroma has value under 0.");
            }
        } else if (!(type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.SUB_EXPRESSION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.IDENT && FunctionFactories.isLCHComponentName(lu.getStringValue()) || type == LexicalUnit.LexicalType.FUNCTION)) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else {
                if (hasVar) {
                    if (CSSUnit.isAngleUnitType(lu.getCssUnit())) {
                        this.normalizeHue(handler, index, lu);
                        return this.checkNextSlashAplhaChannel(handler, index, lu, false);
                    }
                    if (type == LexicalUnit.LexicalType.OPERATOR_SLASH && (lu = lu.nextLexicalUnit) == null) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                return false;
            }
        }
        lu = lu.nextLexicalUnit;
        if (lu == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        if (!(type == LexicalUnit.LexicalType.REAL || type == LexicalUnit.LexicalType.INTEGER || this.isHueUnit(handler, index, lu) || type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.SUB_EXPRESSION || type == LexicalUnit.LexicalType.ATTR || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.IDENT && FunctionFactories.isLCHComponentName(lu.getStringValue()))) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else {
                if (hasVar) {
                    if (type == LexicalUnit.LexicalType.OPERATOR_SLASH && (lu = lu.nextLexicalUnit) == null) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                return false;
            }
        }
        return this.checkNextSlashAplhaChannel(handler, index, lu, hasVar);
    }

    private static boolean isLCHComponentName(String s) {
        return "l".equalsIgnoreCase(s) || "c".equalsIgnoreCase(s) || "h".equalsIgnoreCase(s) || "none".equalsIgnoreCase(s) || "alpha".equalsIgnoreCase(s);
    }

    private boolean checkNextSlashAplhaChannel(CSSContentHandler handler, int index, LexicalUnitImpl lu, boolean hasVar) {
        lu = lu.nextLexicalUnit;
        if (lu != null) {
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
            } else {
                if (type == LexicalUnit.LexicalType.VAR) {
                    lu = lu.nextLexicalUnit;
                    while (lu != null) {
                        if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                            return this.isValidAlpha(handler, index, lu);
                        }
                        lu = lu.nextLexicalUnit;
                    }
                    return true;
                }
                if (!hasVar) {
                    return false;
                }
            }
            return this.isValidAlpha(handler, index, lu);
        }
        return true;
    }

    private boolean isValidColorFunction(CSSContentHandler handler, int index, LexicalUnitImpl currentlu) {
        LexicalUnitImpl lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        boolean hasVar = false;
        boolean foundComponent = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        while (type == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.nextLexicalUnit;
            if (lu == null) {
                return true;
            }
            type = lu.getLexicalUnitType();
        }
        if (type == LexicalUnit.LexicalType.IDENT) {
            String s = lu.getStringValue();
            if ("from".equalsIgnoreCase(s)) {
                hasVar = false;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return false;
                }
                type = lu.getLexicalUnitType();
                boolean isVar = type == LexicalUnit.LexicalType.VAR;
                lu = lu.nextLexicalUnit;
                if (lu == null) {
                    return isVar;
                }
                if (isVar || lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    hasVar = true;
                }
            }
            if ((lu = lu.nextLexicalUnit) == null) {
                return hasVar;
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            }
        } else if (!hasVar) {
            return false;
        }
        do {
            type = lu.getLexicalUnitType();
            switch (type) {
                case IDENT: {
                    if ("from".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                }
                case INTEGER: 
                case REAL: 
                case PERCENTAGE: 
                case VAR: 
                case CALC: 
                case MATH_FUNCTION: 
                case SUB_EXPRESSION: 
                case FUNCTION: 
                case ATTR: {
                    foundComponent = true;
                    break;
                }
                case OPERATOR_SLASH: {
                    if (!foundComponent && !hasVar) {
                        return false;
                    }
                    lu = lu.nextLexicalUnit;
                    if (lu == null) {
                        return false;
                    }
                    return this.isValidAlpha(handler, index, lu);
                }
                default: {
                    return false;
                }
            }
        } while ((lu = lu.nextLexicalUnit) != null);
        return true;
    }

    private boolean isValidColorMixFunction(int index, LexicalUnitImpl currentlu) {
        boolean lastTypeIsComma;
        LexicalUnit lu = currentlu.parameters;
        if (lu == null) {
            return false;
        }
        boolean hasVar = false;
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        if (type != LexicalUnit.LexicalType.IDENT) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (type != LexicalUnit.LexicalType.ATTR) {
                return false;
            }
        } else if (!"in".equalsIgnoreCase(lu.getStringValue())) {
            return false;
        }
        lu = lu.getNextLexicalUnit();
        if (lu == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        if (type != LexicalUnit.LexicalType.IDENT) {
            if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (type != LexicalUnit.LexicalType.ATTR) {
                return hasVar;
            }
        }
        if ((lu = lu.getNextLexicalUnit()) == null) {
            return hasVar;
        }
        type = lu.getLexicalUnitType();
        boolean bl = lastTypeIsComma = type == LexicalUnit.LexicalType.OPERATOR_COMMA;
        if (!lastTypeIsComma) {
            if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.ATTR) {
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    return hasVar;
                }
                type = lu.getLexicalUnitType();
                if (type == LexicalUnit.LexicalType.IDENT) {
                    if (!hasVar && !"hue".equalsIgnoreCase(lu.getStringValue())) {
                        return false;
                    }
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        return hasVar;
                    }
                    type = lu.getLexicalUnitType();
                }
                lastTypeIsComma = type == LexicalUnit.LexicalType.OPERATOR_COMMA;
            } else if (type == LexicalUnit.LexicalType.VAR) {
                hasVar = true;
            } else if (!hasVar) {
                return false;
            }
        }
        if (lastTypeIsComma) {
            lu = lu.getNextLexicalUnit();
        }
        if (lu == null) {
            return !lastTypeIsComma && hasVar;
        }
        CSSValueSyntax synColor = new SyntaxParser().parseSyntax("<color>");
        LexicalUnit.LexicalType uType = lu.getLexicalUnitType();
        if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.SUB_EXPRESSION || uType == LexicalUnit.LexicalType.FUNCTION) {
            if ((lu = lu.getNextLexicalUnit()) == null || FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
        } else if (uType == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.getNextLexicalUnit();
        } else {
            if (FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                return hasVar;
            }
            uType = lu.getLexicalUnitType();
            if (uType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                switch (uType) {
                    case VAR: {
                        hasVar = true;
                    }
                    case PERCENTAGE: 
                    case CALC: 
                    case MATH_FUNCTION: 
                    case SUB_EXPRESSION: 
                    case FUNCTION: 
                    case ATTR: {
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        if (lu == null) {
            return hasVar;
        }
        uType = lu.getLexicalUnitType();
        if (uType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            return hasVar && (!FunctionFactories.cannotBeColor(lu, synColor) || uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.SUB_EXPRESSION || uType == LexicalUnit.LexicalType.VAR || uType == LexicalUnit.LexicalType.ATTR || uType == LexicalUnit.LexicalType.FUNCTION);
        }
        uType = (lu = lu.getNextLexicalUnit()).getLexicalUnitType();
        if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.SUB_EXPRESSION || uType == LexicalUnit.LexicalType.FUNCTION) {
            if ((lu = lu.getNextLexicalUnit()) == null || FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
        } else if (uType == LexicalUnit.LexicalType.VAR) {
            hasVar = true;
            lu = lu.getNextLexicalUnit();
        } else {
            if (FunctionFactories.cannotBeColor(lu, synColor)) {
                return false;
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                return true;
            }
            uType = lu.getLexicalUnitType();
            if (uType == LexicalUnit.LexicalType.PERCENTAGE || uType == LexicalUnit.LexicalType.CALC || uType == LexicalUnit.LexicalType.MATH_FUNCTION || uType == LexicalUnit.LexicalType.SUB_EXPRESSION || uType == LexicalUnit.LexicalType.FUNCTION || uType == LexicalUnit.LexicalType.VAR || uType == LexicalUnit.LexicalType.ATTR) {
                lu = lu.getNextLexicalUnit();
            } else {
                return false;
            }
        }
        while (lu != null) {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
        }
        return true;
    }

    private boolean isValidAlpha(CSSContentHandler handler, int index, LexicalUnitImpl lu) {
        LexicalUnit.LexicalType type = lu.getLexicalUnitType();
        switch (type) {
            case INTEGER: {
                int iAlpha = lu.getIntegerValue();
                if (iAlpha < 0) {
                    lu.intValue = 0;
                    this.warn(handler, index, "Color alpha has value under 0.");
                    break;
                }
                if (iAlpha <= 1) break;
                lu.intValue = 1;
                this.warn(handler, index, "Color alpha has value over 1.");
                break;
            }
            case REAL: {
                float fAlpha = lu.getFloatValue();
                if (fAlpha < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(handler, index, "Color alpha has value under 0.");
                    break;
                }
                if (!(fAlpha > 1.0f)) break;
                lu.floatValue = 1.0f;
                this.warn(handler, index, "Color alpha has value over 1.");
                break;
            }
            case PERCENTAGE: {
                float fAlpha = lu.getFloatValue();
                if (fAlpha < 0.0f) {
                    lu.floatValue = 0.0f;
                    this.warn(handler, index, "Color alpha has value under 0%.");
                    break;
                }
                if (!(fAlpha > 100.0f)) break;
                lu.floatValue = 100.0f;
                this.warn(handler, index, "Color alpha has value over 100%.");
                break;
            }
            case IDENT: {
                String s = lu.getStringValue();
                if ("none".equalsIgnoreCase(s) || "alpha".equalsIgnoreCase(s)) break;
                return false;
            }
            case VAR: 
            case CALC: 
            case MATH_FUNCTION: 
            case SUB_EXPRESSION: 
            case FUNCTION: 
            case ATTR: {
                break;
            }
            default: {
                return false;
            }
        }
        lu = lu.nextLexicalUnit;
        while (lu != null) {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                return false;
            }
            lu = lu.nextLexicalUnit;
        }
        return true;
    }

    private static boolean cannotBeColor(LexicalUnit lu, CSSValueSyntax syn) {
        return lu.shallowMatch(syn) == CSSValueSyntax.Match.FALSE;
    }

    protected void addEmptyLexicalUnit(CSSContentHandler handler) {
        if (!(handler instanceof LexicalProvider)) {
            throw new CSSException("Found var() in invalid context.");
        }
        ((LexicalProvider)handler).addEmptyLexicalUnit();
    }

    protected void error(CSSContentHandler handler, int index, String message) {
        handler.handleError(index, (byte)5, message);
    }

    protected void warn(CSSContentHandler handler, int index, String message) {
        handler.handleWarning(index, (byte)-5, message);
    }

    public LexicalUnitFactory getFactory(String lcFunctionName) {
        return this.factories.get(lcFunctionName);
    }

    private class PseudoUnitFactory
    implements LexicalUnitFactory {
        private final String name;

        PseudoUnitFactory(String name) {
            this.name = name;
        }

        @Override
        public LexicalUnitImpl createUnit() {
            return new EmptyUnitImpl();
        }

        @Override
        public void handle(ValueTokenHandler parent, int index) {
            parent.buffer.setLength(0);
            BufferTokenHandler selh = parent.nestedSelectorHandler(index);
            if (selh != null) {
                selh.word(index, this.name);
                selh.leftParenthesis(index);
                parent.yieldHandling(selh);
            } else {
                FunctionFactories.this.error(parent, index, "Invalid pseudo-class: " + this.name);
            }
        }
    }
}

