/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TranslatingShape
implements Shape {
    private Shape shape;
    private double dx;
    private double dy;

    public TranslatingShape(Shape shape, double dx, double dy) {
        this.shape = shape;
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle r = this.shape.getBounds();
        r.translate((int)this.dx, (int)this.dy);
        return r;
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D r = this.shape.getBounds2D();
        r.setRect(r.getMinX() + this.dx, r.getMinY() + this.dy, r.getWidth(), r.getHeight());
        return r;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.shape.contains(x - this.dx, y - this.dy);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.shape.intersects(x - this.dx, y - this.dy, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.shape.contains(x - this.dx, y - this.dy, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getMinX() - this.dx, r.getMinY() - this.dy, r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(this.shape.getPathIterator(at));
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new Iterator(this.shape.getPathIterator(at, flatness));
    }

    private class Iterator
    implements PathIterator {
        private PathIterator iterator;

        Iterator(PathIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public int getWindingRule() {
            return this.iterator.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.iterator.isDone();
        }

        @Override
        public void next() {
            this.iterator.next();
        }

        @Override
        public int currentSegment(float[] coords) {
            int result = this.iterator.currentSegment(coords);
            int i = 0;
            while (i < coords.length) {
                int n = i++;
                coords[n] = (float)((double)coords[n] + TranslatingShape.this.dx);
                int n2 = i++;
                coords[n2] = (float)((double)coords[n2] + TranslatingShape.this.dy);
            }
            return result;
        }

        @Override
        public int currentSegment(double[] coords) {
            int result = this.iterator.currentSegment(coords);
            int i = 0;
            while (i < coords.length) {
                int n = i++;
                coords[n] = coords[n] + TranslatingShape.this.dx;
                int n2 = i++;
                coords[n2] = coords[n2] + TranslatingShape.this.dy;
            }
            return result;
        }
    }
}

