﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/supplychain/SupplyChainRequest.h>
#include <aws/supplychain/SupplyChain_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SupplyChain {
namespace Model {

/**
 * <p>The request parameters for UpdateInstance.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/UpdateInstanceRequest">AWS
 * API Reference</a></p>
 */
class UpdateInstanceRequest : public SupplyChainRequest {
 public:
  AWS_SUPPLYCHAIN_API UpdateInstanceRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateInstance"; }

  AWS_SUPPLYCHAIN_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The AWS Supply Chain instance identifier.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  UpdateInstanceRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The AWS Supply Chain instance name.</p>
   */
  inline const Aws::String& GetInstanceName() const { return m_instanceName; }
  inline bool InstanceNameHasBeenSet() const { return m_instanceNameHasBeenSet; }
  template <typename InstanceNameT = Aws::String>
  void SetInstanceName(InstanceNameT&& value) {
    m_instanceNameHasBeenSet = true;
    m_instanceName = std::forward<InstanceNameT>(value);
  }
  template <typename InstanceNameT = Aws::String>
  UpdateInstanceRequest& WithInstanceName(InstanceNameT&& value) {
    SetInstanceName(std::forward<InstanceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The AWS Supply Chain instance description.</p>
   */
  inline const Aws::String& GetInstanceDescription() const { return m_instanceDescription; }
  inline bool InstanceDescriptionHasBeenSet() const { return m_instanceDescriptionHasBeenSet; }
  template <typename InstanceDescriptionT = Aws::String>
  void SetInstanceDescription(InstanceDescriptionT&& value) {
    m_instanceDescriptionHasBeenSet = true;
    m_instanceDescription = std::forward<InstanceDescriptionT>(value);
  }
  template <typename InstanceDescriptionT = Aws::String>
  UpdateInstanceRequest& WithInstanceDescription(InstanceDescriptionT&& value) {
    SetInstanceDescription(std::forward<InstanceDescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;
  bool m_instanceIdHasBeenSet = false;

  Aws::String m_instanceName;
  bool m_instanceNameHasBeenSet = false;

  Aws::String m_instanceDescription;
  bool m_instanceDescriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace SupplyChain
}  // namespace Aws
