﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mq/MQRequest.h>
#include <aws/mq/MQ_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MQ {
namespace Model {

/**
 */
class DeleteBrokerRequest : public MQRequest {
 public:
  AWS_MQ_API DeleteBrokerRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteBroker"; }

  AWS_MQ_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique ID that Amazon MQ generates for the broker.</p>
   */
  inline const Aws::String& GetBrokerId() const { return m_brokerId; }
  inline bool BrokerIdHasBeenSet() const { return m_brokerIdHasBeenSet; }
  template <typename BrokerIdT = Aws::String>
  void SetBrokerId(BrokerIdT&& value) {
    m_brokerIdHasBeenSet = true;
    m_brokerId = std::forward<BrokerIdT>(value);
  }
  template <typename BrokerIdT = Aws::String>
  DeleteBrokerRequest& WithBrokerId(BrokerIdT&& value) {
    SetBrokerId(std::forward<BrokerIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_brokerId;
  bool m_brokerIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MQ
}  // namespace Aws
