﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/SlotValueOverride.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>Override settings to configure the intent state.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/IntentOverride">AWS
 * API Reference</a></p>
 */
class IntentOverride {
 public:
  AWS_LEXMODELSV2_API IntentOverride() = default;
  AWS_LEXMODELSV2_API IntentOverride(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API IntentOverride& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the intent. Only required when you're switching intents.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  IntentOverride& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A map of all of the slot value overrides for the intent. The name of the slot
   * maps to the value of the slot. Slots that are not included in the map aren't
   * overridden.</p>
   */
  inline const Aws::Map<Aws::String, SlotValueOverride>& GetSlots() const { return m_slots; }
  inline bool SlotsHasBeenSet() const { return m_slotsHasBeenSet; }
  template <typename SlotsT = Aws::Map<Aws::String, SlotValueOverride>>
  void SetSlots(SlotsT&& value) {
    m_slotsHasBeenSet = true;
    m_slots = std::forward<SlotsT>(value);
  }
  template <typename SlotsT = Aws::Map<Aws::String, SlotValueOverride>>
  IntentOverride& WithSlots(SlotsT&& value) {
    SetSlots(std::forward<SlotsT>(value));
    return *this;
  }
  template <typename SlotsKeyT = Aws::String, typename SlotsValueT = SlotValueOverride>
  IntentOverride& AddSlots(SlotsKeyT&& key, SlotsValueT&& value) {
    m_slotsHasBeenSet = true;
    m_slots.emplace(std::forward<SlotsKeyT>(key), std::forward<SlotsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::Map<Aws::String, SlotValueOverride> m_slots;
  bool m_slotsHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
