﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/SceneSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {
class ListScenesResult {
 public:
  AWS_IOTTWINMAKER_API ListScenesResult() = default;
  AWS_IOTTWINMAKER_API ListScenesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTTWINMAKER_API ListScenesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of objects that contain information about the scenes.</p>
   */
  inline const Aws::Vector<SceneSummary>& GetSceneSummaries() const { return m_sceneSummaries; }
  template <typename SceneSummariesT = Aws::Vector<SceneSummary>>
  void SetSceneSummaries(SceneSummariesT&& value) {
    m_sceneSummariesHasBeenSet = true;
    m_sceneSummaries = std::forward<SceneSummariesT>(value);
  }
  template <typename SceneSummariesT = Aws::Vector<SceneSummary>>
  ListScenesResult& WithSceneSummaries(SceneSummariesT&& value) {
    SetSceneSummaries(std::forward<SceneSummariesT>(value));
    return *this;
  }
  template <typename SceneSummariesT = SceneSummary>
  ListScenesResult& AddSceneSummaries(SceneSummariesT&& value) {
    m_sceneSummariesHasBeenSet = true;
    m_sceneSummaries.emplace_back(std::forward<SceneSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The string that specifies the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListScenesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListScenesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<SceneSummary> m_sceneSummaries;
  bool m_sceneSummariesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
