﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datasync/DataSync_EXPORTS.h>

namespace Aws {
namespace DataSync {
namespace Model {
enum class TaskStatus { NOT_SET, AVAILABLE, CREATING, QUEUED, RUNNING, UNAVAILABLE };

namespace TaskStatusMapper {
AWS_DATASYNC_API TaskStatus GetTaskStatusForName(const Aws::String& name);

AWS_DATASYNC_API Aws::String GetNameForTaskStatus(TaskStatus value);
}  // namespace TaskStatusMapper
}  // namespace Model
}  // namespace DataSync
}  // namespace Aws
