/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.application.Topics;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.AnonymizedIdsCache;
import com.intellij.internal.statistic.eventLog.AtomicLazyValue;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.MathUtil;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u001f\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\u0010H\u0002J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020%J\u001a\u0010&\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020%H\u0007J\f\u0010'\u001a\u00020\u0010*\u00020\u0003H\u0002J\b\u0010(\u001a\u00020\u0003H\u0002J\b\u0010)\u001a\u00020\u0014H\u0002J\b\u0010*\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012\u00a8\u0006,"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "", "recorderId", "", "eventLogConfiguration", "Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "sessionId", "alternativeRecorderId", "<init>", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;Ljava/lang/String;Ljava/lang/String;)V", "getSessionId", "()Ljava/lang/String;", "getAlternativeRecorderId", "deviceId", "getDeviceId", "bucket", "", "getBucket", "()I", "salt", "", "anonymizedCache", "Lcom/intellij/internal/statistic/eventLog/AnonymizedIdsCache;", "machineIdReference", "Lcom/intellij/internal/statistic/eventLog/AtomicLazyValue;", "Lcom/intellij/internal/statistic/eventLog/MachineId;", "machineId", "getMachineId", "()Lcom/intellij/internal/statistic/eventLog/MachineId;", "maxFilesToSend", "getMaxFilesToSend", "generateMachineId", "machineIdSalt", "value", "anonymize", "data", "short", "", "anonymizeSkipCache", "asBucket", "getOrGenerateDeviceId", "getOrGenerateSalt", "computeMaxFilesToSend", "Companion", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventLogConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogConfiguration.kt\ncom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,287:1\n52#2:288\n52#2:289\n*S KotlinDebug\n*F\n+ 1 EventLogConfiguration.kt\ncom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration\n*L\n222#1:288\n213#1:289\n*E\n"})
public final class EventLogRecorderConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private final EventLogConfiguration eventLogConfiguration;
    @NotNull
    private final String sessionId;
    @Nullable
    private final String alternativeRecorderId;
    @NotNull
    private final String deviceId;
    private final int bucket;
    @NotNull
    private final byte[] salt;
    @NotNull
    private final AnonymizedIdsCache anonymizedCache;
    @NotNull
    private final AtomicLazyValue<MachineId> machineIdReference;
    private final int maxFilesToSend;
    private static final int DEFAULT_MAX_FILES_TO_SEND = 5;
    public static final int TOTAL_NUMBER_OF_BUCKETS = 256;

    public EventLogRecorderConfiguration(@NotNull String recorderId, @NotNull EventLogConfiguration eventLogConfiguration, @NotNull String sessionId, @Nullable String alternativeRecorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)eventLogConfiguration, (String)"eventLogConfiguration");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.recorderId = recorderId;
        this.eventLogConfiguration = eventLogConfiguration;
        this.sessionId = sessionId;
        this.alternativeRecorderId = alternativeRecorderId;
        this.deviceId = this.getOrGenerateDeviceId();
        this.bucket = this.asBucket(this.deviceId);
        this.salt = this.getOrGenerateSalt();
        this.anonymizedCache = new AnonymizedIdsCache();
        this.maxFilesToSend = this.computeMaxFilesToSend();
        this.machineIdReference = new AtomicLazyValue(() -> EventLogRecorderConfiguration._init_$lambda$0(this));
        Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        String string = this.alternativeRecorderId;
        if (string == null) {
            string = this.recorderId;
        }
        String string2 = string;
        Topics.subscribe(topic, null, (Object)new EventLogRecorderConfigOptionsListener(string2){

            @Override
            public void onMachineIdConfigurationChanged(String salt, int revision) {
                machineIdReference.updateAndGet(arg_0 -> 2.onMachineIdConfigurationChanged$lambda$0(salt, revision, this, arg_0));
            }

            private static final MachineId onMachineIdConfigurationChanged$lambda$0(String $salt, int $revision, EventLogRecorderConfiguration this$0, MachineId prevValue) {
                Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
                return $salt != null && $revision != -1 && $revision > prevValue.getRevision() ? this$0.generateMachineId($salt, $revision) : prevValue;
            }
        });
    }

    public /* synthetic */ EventLogRecorderConfiguration(String string, EventLogConfiguration eventLogConfiguration, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = EventLogConfiguration.Companion.generateSessionId$intellij_platform_statistics();
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        this(string, eventLogConfiguration, string2, string3);
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public final String getAlternativeRecorderId() {
        return this.alternativeRecorderId;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public final int getBucket() {
        return this.bucket;
    }

    @NotNull
    public final MachineId getMachineId() {
        return this.machineIdReference.getValue();
    }

    public final int getMaxFilesToSend() {
        return this.maxFilesToSend;
    }

    private final MachineId generateMachineId(String machineIdSalt, int value) {
        String salt;
        String string = machineIdSalt;
        if (string == null) {
            string = "";
        }
        if (Intrinsics.areEqual((Object)(salt = string), (Object)"disabled")) {
            return MachineId.DISABLED;
        }
        int revision = value >= 0 ? value : 0;
        String string2 = this.alternativeRecorderId;
        if (string2 == null) {
            string2 = this.recorderId;
        }
        String string3 = MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrains" + string2 + salt);
        if (string3 == null) {
            return MachineId.UNKNOWN;
        }
        String machineId = string3;
        return new MachineId(machineId, revision);
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.anonymize(data, false);
    }

    @NotNull
    public final String anonymize(@NotNull String data, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        return this.anonymizedCache.computeIfAbsent(data, (Function1<? super String, String>)((Function1)arg_0 -> EventLogRecorderConfiguration.anonymize$lambda$0(this, bl, arg_0)));
    }

    public static /* synthetic */ String anonymize$default(EventLogRecorderConfiguration eventLogRecorderConfiguration, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return eventLogRecorderConfiguration.anonymize(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final String anonymizeSkipCache(@NotNull String data, boolean bl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        String string2 = EventLogConfiguration.Companion.hashSha256(this.salt, data);
        boolean condition$iv = bl;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$applyIf$iv;
            void $this$anonymizeSkipCache_u24lambda_u240 = $this$applyIf$iv;
            boolean bl2 = false;
            String string3 = $this$anonymizeSkipCache_u24lambda_u240.substring(0, 12);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = string2;
        }
        return string;
    }

    public static /* synthetic */ String anonymizeSkipCache$default(EventLogRecorderConfiguration eventLogRecorderConfiguration, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return eventLogRecorderConfiguration.anonymizeSkipCache(string, bl);
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getOrGenerateDeviceId() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property;
            String string;
            String string2 = this.alternativeRecorderId;
            if (string2 == null) {
                string2 = this.recorderId;
            }
            if ((string = System.getProperty(property = this.eventLogConfiguration.getHeadlessDeviceIdProperty$intellij_platform_statistics(string2))) != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
        }
        try {
            DeviceIdManager.DeviceIdToken deviceIdToken = new DeviceIdManager.DeviceIdToken(){};
            String string = this.alternativeRecorderId;
            if (string == null) {
                string = this.recorderId;
            }
            String string3 = DeviceIdManager.getOrGenerateId(deviceIdToken, string);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getOrGenerateId(...)");
            return string3;
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException invalidDeviceIdTokenException) {
            Logger logger = EventLogConfiguration.Companion.getLOG$intellij_platform_statistics();
            String string = this.alternativeRecorderId;
            if (string == null) {
                string = this.recorderId;
            }
            logger.warn("Failed retrieving device id for " + string);
            return "000000000000000-0000-0000-0000-000000000000";
        }
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property;
            String string2;
            String string3 = this.alternativeRecorderId;
            if (string3 == null) {
                string3 = this.recorderId;
            }
            if ((string2 = System.getProperty(property = this.eventLogConfiguration.getHeadlessSaltProperty$intellij_platform_statistics(string3))) != null) {
                String it = string2;
                boolean bl = false;
                byte[] byArray = it.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return byArray;
            }
        }
        if ((string = this.alternativeRecorderId) == null) {
            string = this.recorderId;
        }
        return EventLogConfiguration.Companion.getOrGenerateSaltFromPrefs(string);
    }

    private final int computeMaxFilesToSend() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            Integer value;
            String property = this.eventLogConfiguration.getHeadlessMaxFilesToSendProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            Integer n = value = string != null ? StringsKt.toIntOrNull((String)string) : null;
            if (value != null) {
                int n2 = -1;
                if (value == n2 || value >= 0) {
                    return value;
                }
            }
        }
        return 5;
    }

    private static final MachineId _init_$lambda$0(EventLogRecorderConfiguration this$0) {
        EventLogConfigOptionsService eventLogConfigOptionsService = EventLogConfigOptionsService.getInstance();
        String string = this$0.alternativeRecorderId;
        if (string == null) {
            string = this$0.recorderId;
        }
        EventLogOptions eventLogOptions = eventLogConfigOptionsService.getOptions(string);
        Intrinsics.checkNotNullExpressionValue((Object)eventLogOptions, (String)"getOptions(...)");
        EventLogOptions configOptions = eventLogOptions;
        return this$0.generateMachineId(configOptions.getMachineIdSalt(), configOptions.getMachineIdRevision());
    }

    /*
     * WARNING - void declaration
     */
    private static final String anonymize$lambda$0(EventLogRecorderConfiguration this$0, boolean $short, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = EventLogConfiguration.Companion.hashSha256(this$0.salt, it);
        boolean condition$iv = $short;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$applyIf$iv;
            void $this$anonymize_u24lambda_u240_u240 = $this$applyIf$iv;
            boolean bl = false;
            String string3 = $this$anonymize_u24lambda_u240_u240.substring(0, 12);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = string2;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration$Companion;", "", "<init>", "()V", "DEFAULT_MAX_FILES_TO_SEND", "", "TOTAL_NUMBER_OF_BUCKETS", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

