/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReflexivePronouns {
    static final NodePattern accReflexivPronomen = NodePattern.N.form("[smd]ich|uns|euch").noDependents();
    static final NodePattern datReflexivPronomen = NodePattern.N.form("sich|[md]ir|uns|euch").noDependents();
    static final NodePattern anyReflexivePronoun = NodePattern.N.form("[smd]ich|uns|euch|[md]ir");
    private static final NodePattern inCorrectReflPosition = NodePattern.custom((foundReflexive, match) -> {
        boolean depClause;
        Node verb = match.getMarkedNode("ReflexiveVerb");
        List<Node> markDeps = verb.findDependents("mark").stream().filter(mark -> !mark.lowForm().equals("denn")).toList();
        boolean bl = depClause = !markDeps.isEmpty();
        if (verb.hasHeadRelation("conj|xcomp") || verb.hasHeadRelation("advcl") && (!depClause || markDeps.size() > 1) || verb.hasDependent("csubj.*")) {
            return match;
        }
        Node subj = match.getMarkedNode("Subject");
        Node aux = match.findMarkedNode("Auxiliary");
        Node shouldBeReflexive = ReflexivePronouns.getReflexivePosition(verb, subj, match.findMarkedNode("Auxiliary")).nextNode();
        boolean subjReflScramble = (depClause || aux != null) && shouldBeReflexive == subj.phraseStart();
        return shouldBeReflexive == foundReflexive || subjReflScramble ? match : null;
    });
    private static final WordSet accVerb = WordSet.loadResource("de/reflexiv_acc_verben.txt");
    private static final NodePattern withDependentSich = NodePattern.N.withDependent("nsubj|obj", NodePattern.N.form("sich"));
    private static final Map<String, String> p12Reflexives = Map.of("ich", "mich", "du", "dich", "wir", "uns", "ihr", "euch");
    private static final NodePattern subjectReflexiveMatch = NodePattern.custom((reflexive, match) -> reflexive.lowForm().equals(p12Reflexives.getOrDefault(match.getMarkedNode("Subj").lowForm(), "sich")) ? match : null);
    static final NodePattern reflexiveVerb = NodePattern.or(ReflexivePronouns.accVerb.lemmaPattern, NodePattern.N.lemma("integrieren").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("in"))), NodePattern.N.lemma("handeln").withDependent("nsubj", NodePattern.N.form("es")).andOr(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("um").andNot(withDependentSich))), NodePattern.N.withDependent("obj|advmod", NodePattern.N.form("(wo|da)rum"))).andNot(withDependentSich), NodePattern.N.lemma("interessieren|wenden").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("an"))), NodePattern.N.lemma("treffen").andOr(NodePattern.N.withDependent("obl", SemanticRules.animate.pos(".*DAT.*").withDependent("case", NodePattern.N.form("mit"))), NodePattern.N.withDependent("nsubj", NodePattern.N.onlyPos(".*PLU.*")).noDependents("obj").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("auf")))), NodePattern.N.lemma("einsetzen|entscheiden").noDependents("ccomp", NodePattern.N.withDependent("mark", NodePattern.N.form("dass"))).withDependent("obl|nmod", NodePattern.N.pos(".*AKK.*").withDependent("case", NodePattern.N.form("f\u00fcr"))), NodePattern.N.lemma("f\u00fcrchten").noDependents("obj").noDependents("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("zu"))).noDependents("obl", NodePattern.N.pos(".*AKK.*").withDependent("case", NodePattern.N.form("um"))).noDependents("ccomp"), NodePattern.N.lemma("f\u00fchlen").withDependent("advmod|obj|xcomp", NodePattern.N.pos("ADJ:PRD.*")), NodePattern.N.lemma("wiegen").andOr(NodePattern.N.pos(".*PR\u00c4.*"), NodePattern.N.form("wiegte[nt]?|gewiegt")), NodePattern.N.lemma("irren").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("durch|von|nach|(\u00fc|ue)ber"))), NodePattern.N.lemma("\u00e4ndern").noDependents("obj").noDependents("mark", NodePattern.N.form("zu")).andNot(CommonPatterns.severalDependents("[cn]subj")), NodePattern.N.lemma("nennen").noDependents("xcomp"), NodePattern.N.lemma("verteidigen").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("f(\u00fc|ue)r"))), NodePattern.N.lemma("umziehen").andOr(NodePattern.ROOT.noDependents("aux"), NodePattern.N.withHeadRelation("parataxis"), NodePattern.N.form("umzogen")).noDependents("obl"), NodePattern.N.lemma("verkrachen|einigen").pos(".*:PLU:.*"), NodePattern.N.lemma("wundern").noDependents("expl"), NodePattern.N.lemma("begr\u00fc\u00dfen").noDependents("expl").noDependents("mark"), NodePattern.N.lemma("befinden").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("i[nm]"))), NodePattern.N.lemma("erinnern").withDependent("nsubj").noDependents("ob[jl]").andOr(NodePattern.ROOT.withDependent("ccomp"), NodePattern.N.withDependent("advmod", NodePattern.N.pos("ADJ:PRD:GRU"))));
    private static final NodePattern dependentClauseOrder = NodePattern.N.withHeadRelation("acl|ccomp|csubj.*").noDependents("mark").noDependents("aux", NodePattern.N.beforeHead().andNot(NodePattern.N.directlyBeforeHead()));

    ReflexivePronouns() {
    }

    private static NodePattern trueReflexive() {
        NodePattern akkOrNoPos = NodePattern.or(NodePattern.N.noPos(), NodePattern.N.pos(".*AKK.*"), NodePattern.N.pos("PRO:.*").noPos(".*(NOM|AKK|GEN|DAT).*"));
        NodePattern completeSentence = NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("punct", NodePattern.N.form(".*[.?!].*"))).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("punct", CommonPatterns.firstWord.form("-")))).noDependents("punct", CommonPatterns.ellipsis.andNot(CommonPatterns.lastWord)).andNot(NodePattern.N.directlyBefore(CommonPatterns.ellipsis.andNot(CommonPatterns.lastWord)));
        NodePattern noSpaceAfter = NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.not(NodePattern.PUNCT));
        return reflexiveVerb.markAs("ReflexiveVerb").and(completeSentence).andOr(NodePattern.N.withDependent("[nc]subj(:pass)?", NodePattern.N.markAs("Subject")), NodePattern.N.withHead("conj|xcomp", NodePattern.N.withDependent("nsubj.*", NodePattern.N.markAs("Subject"))).noMatchUntil("Subject", GermanTreePatterns.anyQuotation), NodePattern.N.withHead("conj", CommonPatterns.possiblySkipUp("xcomp", CommonPatterns.possiblySkipUp("obj", NodePattern.N.withHead("conj", NodePattern.N.withDependent("nsubj.*", NodePattern.N.markAs("Subject")))))).directlyAfter(NodePattern.N.form("zu")), NodePattern.N.withHead("xcomp", CommonPatterns.possiblySkipUp("obj", CommonPatterns.possiblySkipUp("conj", NodePattern.N.withDependent("nsubj.*", NodePattern.N.markAs("Subject"))))).andNot(NodePattern.N.directlyBeforeHead()), NodePattern.N.withHead("acl", NodePattern.N.withHead("obj", NodePattern.N.withDependent("nsubj.*", NodePattern.N.markAs("Subject")))).noDependents("obl", NodePattern.N.pos("PRO:REF.*"))).andOptionally(NodePattern.N.withDependent("aux", NodePattern.N.markAs("Auxiliary"))).noDependents("compound:prt|dep").and(ReflexivePronouns.missingOrMisplacedReflexiveDependent("obj|expl:pv|obl")).andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("obj|expl:pv|obl", accReflexivPronomen))).andNot(NodePattern.N.pos("PA1.*").withHead("xcomp", NodePattern.N.lemma("werden"))).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()).withDependent("cop|aux", NodePattern.N.lemma("sein"))).andOr(NodePattern.N.withDependent("xcomp|iobj", ReflexivePronouns.missingOrMisplacedReflexiveDependent("nsubj|obj")), NodePattern.N.noDependents("xcomp|iobj")).andOr(NodePattern.N.withHead("xcomp", ReflexivePronouns.missingOrMisplacedReflexiveDependent(".*")), NodePattern.not(NodePattern.N.withHeadRelation("xcomp"))).andOr(NodePattern.N.pos("VER:INF.*").withHead("xcomp", NodePattern.N.lemma("lassen").and(ReflexivePronouns.missingOrMisplacedReflexiveDependent(".*"))), NodePattern.not(NodePattern.N.pos("VER:INF.*").withHead("xcomp", NodePattern.N.lemma("lassen")))).andNot(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("nsubj:pass|aux:pass"), NodePattern.N.withDependent("cop", NodePattern.N.lemma("sein")), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("nummod").noDependents("case")), NodePattern.N.withDependent("obj", akkOrNoPos.andNot(accReflexivPronomen)).andNot(NodePattern.not(reflexiveVerb).withHeadRelation("xcomp")), NodePattern.N.withDependent("expl", NodePattern.N.form("es")).withDependent("nsubj"), NodePattern.N.pos("VER:INF.*").withDependent("nsubj", akkOrNoPos).noDependents("obj|obl|ccomp"), NodePattern.N.withDependent("ccomp|acl", NodePattern.N.noDependents("mark", NodePattern.N.form("dass|da\u00df"))), NodePattern.N.withDependent("nsubj.*|i?obj|obl", NodePattern.N.afterHead().withDependent("acl")), NodePattern.N.withHead("parataxis", NodePattern.N.withDependent("punct", GermanTreePatterns.anyQuotation)), NodePattern.N.pos("PA2.*").andOr(NodePattern.N.withDependent("aux", NodePattern.N.lemma("sein")), NodePattern.N.withHeadRelation("xcomp").noDependents("cop|aux.*|nsubj.*")), NodePattern.N.lemma("legen").andOr(NodePattern.N.noDependents("obl", akkOrNoPos.withDependent("amod", NodePattern.N.form("quer"))), NodePattern.N.noDependents("compound:prt", NodePattern.N.form("fest|zu|los"))), NodePattern.N.pos("VER:INF.*").withHead("xcomp", NodePattern.N.lemma("werden|sein"))))).andNot(NodePattern.N.directlyBefore(NodePattern.N.noPos())).andNot(NodePattern.N.pos("PA1.*")).andOptionally(NodePattern.N.withDependent(".*", NodePattern.N.form("[md]ir").noDependents().markAs("WrongFormReflexive").includeIntoReport())).and((verb, match) -> {
            NodeCorrector resultingCorrector;
            Node subject = match.getMarkedNode("Subject");
            String reflexive = subject.hasPos(".*PRO:PER.*") ? p12Reflexives.getOrDefault(subject.lowForm(), "sich") : "sich";
            Node anchor = ReflexivePronouns.getReflexivePosition(verb, subject, match.findMarkedNode("Auxiliary"));
            Node incorrectPlacedReflexive = match.findMarkedNode("MisplacedReflexive");
            Node wrongFormReflexive = match.findMarkedNode("WrongFormReflexive");
            anchor = anchor.nextNode() != null && anchor.nextNode().hasForm(",") && !reflexiveVerb.matches(anchor) ? anchor.nextNode() : anchor;
            NodeCorrector nodeCorrector = resultingCorrector = noSpaceAfter.matches(anchor) ? NodeCorrector.insertAfter(anchor, " " + reflexive + " ") : NodeCorrector.insertAfter(anchor, " " + reflexive);
            if (incorrectPlacedReflexive != null) {
                resultingCorrector = resultingCorrector.join(NodeCorrector.removeNode(incorrectPlacedReflexive));
            }
            if (wrongFormReflexive != null) {
                resultingCorrector = resultingCorrector.join(NodeCorrector.removeNode(wrongFormReflexive));
            }
            String quoted = verb.quotedPresentableText();
            String message = wrongFormReflexive != null ? "Falsche Form des Reflexivpronomens von " + quoted + "?" : (incorrectPlacedReflexive != null ? "Falsche Stellung des Reflexivpronomens von " + quoted + "?" : "Fehlt ein Reflexivpronomen von " + quoted + "?");
            return match.withCorrector(resultingCorrector).withMessage(message);
        });
    }

    private static NodePattern missingOrMisplacedReflexiveDependent(String relations) {
        return NodePattern.or(NodePattern.N.noDependents(relations, accReflexivPronomen), NodePattern.N.withDependent("nsubj", NodePattern.N.markAs("Subj")).withDependent(relations, accReflexivPronomen.andNot(inCorrectReflPosition).and(subjectReflexiveMatch).markAs("MisplacedReflexive").includeIntoReport()));
    }

    @NotNull
    private static Node getReflexivePosition(Node verb, Node subject, @Nullable Node aux) {
        Node depFirstPosition;
        boolean verbFinal;
        Node phraseStartNode = verb.phraseStart();
        if ((verb.headRelation().equals("xcomp") || verb.headRelation().equals("acl")) && !verb.hasDependent("nsubj")) {
            Node headObj;
            Node verbHead = verb.head();
            Node node = headObj = verbHead != null ? verbHead.findSingleDependent("obj") : null;
            if (headObj != null && !accReflexivPronomen.matches(headObj)) {
                return phraseStartNode;
            }
            verb = verbHead;
        }
        if (subject.hasHeadRelation("csubj")) {
            Node expl = verb != null ? verb.findSingleDependent("expl") : null;
            subject = expl != null ? expl : subject;
        }
        Node subjectEnd = subject.phraseEnd();
        if (verb == null) {
            return subjectEnd;
        }
        Node whNode = StreamEx.of(verb.allDependents()).findFirst(n -> GermanTreePatterns.whPhrase.matches((Node)n)).orElse(null);
        boolean pronSubj = subject.hasPos("PRO:PER.*") && !subject.hasPos("ART:.*") || NodePattern.N.form("man|vieles?").noDependents().matches(subject);
        boolean bl = verbFinal = (!NodePattern.ROOT.matches(verb) || whNode != null) && NodePattern.N.noDependents(NodePattern.not(NodePattern.N.withHeadRelation("aux|conj|punct")).afterHead()).noDependents("aux", NodePattern.N.beforeHead()).matches(verb);
        if (subject.head() != verb && verb.hasHeadRelation("conj") && aux == null) {
            Node conj = verb.findSingleDependent("cc");
            return conj != null ? conj : verb.phraseStart();
        }
        if (subject.isAfter(verb)) {
            return subject.phraseStart() == verb.nextNode() || pronSubj ? subjectEnd : verb;
        }
        Node node = verbFinal && whNode != null ? whNode : (depFirstPosition = dependentClauseOrder.matches(verb) ? (Node)StreamEx.of(verb.allDependents()).findFirst(n -> NodePattern.or(NodePattern.N.lemma("der|wo"), NodePattern.N.withDependent("det", NodePattern.or(NodePattern.N.lemma("welch"), NodePattern.N.form("dessen")))).matches((Node)n)).orElse(null) : verb.findSingleDependent("mark"));
        if (depFirstPosition != null) {
            return pronSubj ? subjectEnd : depFirstPosition.phraseEnd();
        }
        return aux == null ? (verbFinal ? subjectEnd : verb) : (aux.isAfter(verb) ? subjectEnd : (aux.isAfter(subject) || !pronSubj ? aux : subjectEnd));
    }

    private static NodePattern falseReflexive() {
        String inf = "VER:INF:(NON|SFT)";
        return accReflexivPronomen.includeIntoReport().withHead("obj", NodePattern.custom(node -> !GermanValences.get(node).isEmpty()).includeIntoReport().withDependent("nsubj", NodePattern.N.markAs("Subj")).noLemma("gefallen").andNot(Case.mayHaveArg("A").noLemma("beginnen|hoffen")).andNot(CommonPatterns.lowercasedHasPos(inf)).andNot(NodePattern.N.withDependent("aux", NodePattern.N.pos(inf))).andNot(NodePattern.N.withDependent("xcomp", NodePattern.or(NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()), NodePattern.N.withDependent("aux", NodePattern.N.directlyAfter(NodePattern.N.form("zu"))), NodePattern.N.pos("VER:EIZ:SFT")))).andNot(reflexiveVerb).andNot(Case.mayHaveArg("refl")).andNot(Case.mayHaveArg("DRefl")).noDependents("compound:prt")).and(subjectReflexiveMatch).correct(NodeCorrector.replace("")).message("Dieses Verb ist im Deutschen nicht reflexiv");
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Grammar.REFLEXIVE_PRONOUN_ISSUES", "Falsche Verwendung von Reflexivpronomen", "Manche Verben brauchen Reflexivpronomen \u201esich\u201c, das an einer bestimmten Stelle im Satz und in einer bestimmten Form stehen soll.", "https://easy-deutsch.de/pronomen/reflexivpronomen/", () -> NodePattern.or(ReflexivePronouns.trueReflexive(), ReflexivePronouns.falseReflexive()), new Example("Ich mag <b>es,</b> stilvoll zu kleiden.", "Ich mag es, <b>mich</b> stilvoll zu kleiden."), new Example("aber du f\u00fchlst einsam <b>dich</b>.", "aber du f\u00fchlst <b>dich</b> einsam."), new Example("Ich mag es, <b>mir</b> stilvoll zu kleiden.", "Ich mag es, <b>mich</b> stilvoll zu kleiden.")).honorCrazyParses();
    }
}

