<?php

if ($this->list->isFresh($ob)) {
    $class = 'listitem';
    $hi = $css['.listitem-hi']['background-color'];
    $lo = $css['.listitem']['background-color'];
} else {
    $class = 'oldlistitem';
    $hi = $css['.oldlistitem-hi']['background-color'];
    $lo = $css['.oldlistitem']['background-color'];
}

if ($ob->hasValue('name')) {
    $link_text = htmlspecialchars(Turba::formatName($ob->getValue('name')));
} else {
    $link_text = '';
}

if ($ob->hasValue('__key')) {
    if ($ob->isGroup()) {
        $url = 'browse.php';
    } else {
        $url = 'displayobject.php';
    }
    $url = Horde::addParameter($url, 'source', $ob->getSource());
    $url = Horde::addParameter($url, 'key', $ob->getValue('__key'));

    $delurl = Horde::addParameter('deleteobject.php', 'source', $ob->getSource());
    $delurl = Horde::addParameter($delurl, 'key', $ob->getValue('__key'));
    $delurl = Horde::addParameter($delurl, 'url', Horde::selfUrl(true));

    $cell = Horde::link(Horde::applicationUrl($url), sprintf(_("View '%s'"), $ob->getValue('name')));
    $cell .= $link_text . '</a>';
    if (Turba::checkPermissions($ob, 'object', _PERMS_EDIT)) {
        $edit_url = Horde::addParameter('editobject.php', 'source', $ob->getSource());
        $edit_url = Horde::addParameter($edit_url, 'key', $ob->getValue('__key'));
        $edit_url = Horde::addParameter($edit_url, 'url', Horde::selfURL());
        $edit_url = Horde::link(Horde::applicationUrl($edit_url), sprintf(_("Edit '%s'"), $ob->getValue('name'))) . Horde::img('edit.gif', _("Edit")) . '</a>';
        $del_url = Horde::addParameter('editobject.php', 'source', $ob->getSource());
        $del_url = Horde::addParameter($del_url, 'key', $ob->getValue('__key'));
        $del_url = Horde::link(Horde::applicationUrl($delurl), sprintf(_("Delete '%s'"), $ob->getValue('name'))) . Horde::img('delete.gif', _("Delete")) . '</a>';
    } else {
        $edit_url = '&nbsp;';
        $del_url = '&nbsp;';
    }
} else {
    $cell = $link_text;
}
?>
<tr class="<?php echo $class ?>" onmouseover="javascript:style.backgroundColor='<?php echo $hi ?>';" onmouseout="javascript:style.backgroundColor='<?php echo $lo ?>';">
  <td><input type="checkbox" name="objectkeys[]" value="<?php echo htmlspecialchars($ob->getValue('__key')) ?>" /></td>
  <td><?php echo $edit_url ?></td>
  <td><?php echo $del_url ?></td>
  <td><?php echo $ob->isGroup() ? Horde::img('group.gif', _("Group")) : '&nbsp;' ?></td>
  <td><?php
echo $cell;

// We purposefully do this before the </td> so that if we end up
// including a script file (say, for the IMP compose window), it's in
// a legal spot.
//
// Build the columns to display.
$show = array();
foreach ($GLOBALS['columns'] as $column) {
    if ($ob->hasValue($column)) {
        $show[$column] = htmlspecialchars($ob->getValue($column));
        if ($GLOBALS['attributes'][$column]['type'] == 'email') {
            $show[$column] = Turba::formatEmailAddresses($show[$column], $ob);
        }
    } else {
        $show[$column] = '&nbsp;';
    }
}

?></td>
<?php foreach ($show as $field): ?>
  <td><?php echo $field ?></td>
<?php endforeach; ?>
</tr>
