<?php
// $Horde: turba/lib/ListView.php,v 1.13 2002/09/11 13:44:20 jan Exp $

/**
 * The Turba_ListView:: class provides an interface for objects that
 * visualize Turba_lists.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  Jon Parise <jon@csh.rit.edu>
 * @version $Revision: 1.13 $
 * @since   Turba 0.0.1
 * @package turba
 */
class Turba_ListView {

    /**
     * The Turba_List object that we are visualizing.
     * @var Turba_List
     */
    var $list;

    /**
     * The template used to display each row of the list.
     * @var string
     */
    var $template;

    /**
     * Constructs a new Turba_ListView object.
     *
     * @param $list     List of contacts to display.
     * @param $template What template file to display this contact with.
     */
    function Turba_ListView(&$list, $template)
    {
        $this->list = &$list;
        $this->template = $template;
    }

    /**
     * Renders the list contents into an HTML view.
     */
    function display()
    {
        Horde::getThemeConfig(TURBA_BASE);
        global $css;

        $i = 0;
        $this->list->reset();
        while ($ob = $this->list->next()) {
            include $this->template;
            $i++;
        }
        return $i;
    }

}
