<?php
/**
 * Turba Attributes File
 *
 * This file contains the attributes that Turba understands, and their
 * types. It may be safely edited by hand. Use attributes.php.dist as
 * a reference.
 *
 * General configuration is in 'conf.php'.
 * Contact sources are defined in 'sources.php'.
 * Default user preferences are defined in 'prefs.php'.
 *
 * $Horde: turba/config/attributes.php.dist,v 1.26 2003/07/31 16:29:40 chuck Exp $
 * The syntax of this array is as follows:
 *      label    - the text that the user will see attached to this field
 *      type     - one of the following:
 *                      - spacer            - header
 *                      - description       - html
 *                      - number            - int
 *                      - intlist           - text
 *                      - longtext          - countedtext
 *                      - address           - file
 *                      - boolean           - link
 *                      - email             - emailconfirm
 *                      - password          - passwordconfirm
 *                      - enum              - multienum
 *                      - radio             - set
 *                      - date              - time
 *                      - monthyear         - monthdayyear
 *                      - colorpicker       - sorter
 *                      - creditcard        - invalid
 *                      - stringlist
 *      required - boolean, true or false whether this field is mandatory
 *      readonly - boolean, true or false whether this editable
 *      desc     - any help text attached to the field
 *      params   - any other parameters that need to be passed to the field
 *                 such as a list to be used in the enum field, the row and
 *                 column sizing for a longtext field, TODO (list more types)
 */

$attributes['name'] = array(
    'label' => _("Name"),
    'type' => 'text',
    'required' => true
);
$attributes['surname'] = array(
    'label' => _("Surname"),
    'type' => 'text',
    'required' => true
);
$attributes['email'] = array(
    'label' => _("Email"),
    'type' => 'email',
    'required' => false
);
$attributes['alias'] = array(
    'label' => _("Alias"),
    'type' => 'text',
    'required' => false
);
$attributes['title'] = array(
    'label' => _("Title"),
    'type' => 'text',
    'required' => false
);
$attributes['company'] = array(
    'label' => _("Company"),
    'type' => 'text',
    'required' => false
);
$attributes['homeAddress'] = array(
    'label' => _("Home Address"),
    'type' => 'address',
    'required' => false,
    'params' => array('3', '40')
);
$attributes['workAddress'] = array(
    'label' => _("Work Address"),
    'type' => 'address',
    'required' => false,
    'params' => array('3', '40')
);
$attributes['companyAddress'] = array(
    'label' => _("Company Address"),
    'type' => 'address',
    'required' => false,
    'params' => array('3', '40')
);
$attributes['homePhone'] = array(
    'label' => _("Home Phone"),
    'type' => 'text',
    'required' => false
);
$attributes['workPhone'] = array(
    'label' => _("Work Phone"),
    'type' => 'text',
    'required' => false
);
$attributes['cellPhone'] = array(
    'label' => _("Mobile Phone"),
    'type' => 'text',
    'required' => false
);
$attributes['fax'] = array(
    'label' => _("Fax"),
    'type' => 'text',
    'required' => false
);
$attributes['businessCategory'] = array(
    'label' => _("Business Category"),
    'type' => 'text',
    'required' => false
);
$attributes['notes'] = array(
    'label' => _("Notes"),
    'type' => 'longtext',
    'required' => false,
    'params' => array('3', '40')
);
$attributes['pgpPublicKey'] = array(
    'label' => _("PGP Public Key"),
    'type' => 'longtext',
    'required' => false,
    'params' => array('3', '40')
);
$attributes['smimePublicKey'] = array(
    'label' => _("S/MIME Public Certificate"),
    'type' => 'longtext',
    'required' => false,
    'params' => array('3', '40')
);
$attributes['freebusyUrl'] = array(
    'label' => _("Freebusy URL"),
    'type' => 'text',
    'required' => false
);
