<?php
/**
 * $Horde: passwd/lib/base.php,v 1.24 2003/09/24 20:43:07 chuck Exp $
 * 
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 * Copyright 2002-2003 Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * Passwd base inclusion file.
 *
 * This file brings in all of the dependencies that every PASSWD script
 * will need, and sets up objects that all scripts use.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an
// auto_prepend_file definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';
require_once HORDE_BASE . '/lib/Notification.php';
require_once HORDE_BASE . '/lib/Registry.php';

// Registry.
$registry = &Registry::singleton();
if (is_a($registry->pushApp('passwd'), 'PEAR_Error')) {
    Horde::fatal(PEAR::raiseError(_("Passwd is not correctly configured or there was an error loading configuration files.")), __FILE__, __LINE__, false);
}
$conf = &$GLOBALS['conf'];
@define('PASSWD_TEMPLATES', $registry->getParam('templates'));

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Don't allow access unless there is a Horde login, or guests are
// allowed.
if (!(Auth::isAuthenticated() || $registry->allowGuests())) {
    Horde::authenticationFailureRedirect();
}

// Find the base file path of Passwd
@define('PASSWD_BASE', dirname(__FILE__) . '/..');

// Passwd base library.
require_once PASSWD_BASE . '/lib/Passwd.php';

// Horde libraries.
require_once HORDE_BASE . '/lib/Help.php';
require_once HORDE_BASE . '/lib/Secret.php';
