<?php
/**
 * $Horde: horde/lib/Block/google.php,v 1.1 2003/08/15 02:45:28 chuck Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_google extends Horde_Block {

    /**
     * Constructor.
     */
    function Horde_Block_google($params = array())
    {
        $this->_params = $params;
        $this->_app = 'horde';
        $this->_type = 'google';
    }

    /**
     * Does this block have any user editable parameters?
     *
     * @return boolean  True is there are editable parameters.
     *                  False if there are not.
     */
    function isEditable()
    {
        return false;
    }

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title()
    {
        return _("Google Search");
    }

    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content()
    {
	    $html  = '<form name="google" onsubmit="return false;">';
        $html .= '<table width="100%" height="100%">';
	    $html .= '<tr><script language="JavaScript" type="text/javascript" src="' . $GLOBALS['registry']->getParam('webroot', 'horde') . '/javascript.php?file=open_google_win.js&amp;app=horde"></script>';
        $html .= '<td>' . Horde::img('google.gif', 'Google') . '</td></tr>';
	    $html .= '<tr><td><input maxLength="256" size="40" name="q" width="100%" /></td></tr>';
	    $html .= '<tr><td><table width="100%"><tr><td align="center"><input type="radio" name="area" value="web" width="20%" checked="checked" />' . _("Web") . '</td>';
        $html .= '<td align="center"><input type="radio" name="area" value="images" width="20%" />' . _("Images") . '</td>';
        $html .= '<td align="center"><input type="radio" name="area" value="groups" width="20%" />' . _("Groups") . '</td>';
        $html .= '<td align="center"><input type="radio" name="area" value="directory" width="20%" />' . _("Directory") . '</td>';
        $html .= '<td align="center"><input type="radio" name="area" value="news" width="20%" />' . _("News") . '</td></tr></table></td></tr>';
	    $html .= '<tr><td><input type="submit" class="button" value="' . _("Google Search") . '" onclick="open_google_win();" /></td></tr>';
        $html .= '</table>';
        $html .= '</form>';
	    return $html;
    }

}
