<?php
/**
 * $Horde: kronolith/month.php,v 1.119 2003/06/18 15:23:21 chuck Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function time_compare($x, $y)
{
    $a = mktime(date('G', $x['d']), date('i', $x['d']), date('s', $x['d']));
    $b = mktime(date('G', $y['d']), date('i', $y['d']), date('s', $y['d']));

    if ($a < $b) {
        return -1;
    } elseif ($a == $b) {
        return 0;
    } else {
        return 1;
    }
}

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $year = Horde::getFormData('year', date('Y'));
}
$sidebyside = $prefs->getValue('show_shared_side_by_side');
$timestamp = mktime(1, 1, 1, $month, 1, $year);
$prevstamp = mktime(1, 1, 1, $month - 1, 1, $year);
$nextstamp = mktime(1, 1, 1, $month + 1, 1, $year);
$title = strftime('%B %Y', $timestamp);

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {
    $print_link = Horde::addParameter('month.php', 'timestamp=' . $timestamp);
    $print_link = Horde::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        require_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Kronolith::menu();
}

if ($sidebyside) {
    require KRONOLITH_TEMPLATES . '/month/head_side_by_side.inc';
} else {
    require KRONOLITH_TEMPLATES . '/month/head.inc';
}

$daysInMonth = Kronolith::daysInMonth($month, $year);
$startday = Kronolith::dayOfWeek($year, $month, $prefs->getValue('week_start_monday') ? 1 : 2);

$colors = Kronolith::categoryColors();

// Days before the month starts.
for ($i = 0; $i < $startday; $i++) {
    if (!$sidebyside) {
        echo '<td></td>';
    }
}

$startStamp = mktime(0, 0, 0, $month, 1, $year);
$startDate = Kronolith::timestampToObject($startStamp);
$endStamp = mktime(23, 59, 59, $month, $daysInMonth, $year);
$endDate = Kronolith::timestampToObject($endStamp);
$allevents = Kronolith::listEvents($startDate, $endDate, $GLOBALS['display_calendars']);
if ($sidebyside) {
    $allCalendars = Kronolith::listCalendars();
    foreach ($GLOBALS['display_calendars'] as $id) {
        $currentCalendars[$id] = &$allCalendars[$id];
    }
    $sharedCalendars = $GLOBALS['display_calendars'];
} else {
   $currentCalendars = array(true); 
}
$hour = date('H');
$min = date('i');
foreach ($currentCalendars as $id => $cal) {
    if ($sidebyside) {
        echo '<tr>';
    } 
    $dayofweek = $startday;
    for ($day = 1; $day <= $daysInMonth; $day++) {
        $dayStamp = mktime(0, 0, 0, $month, $day, $year);
        $timestamp = mktime($hour, $min - ($min % 5), 0, $month, $day, $year);
        $week = Kronolith::weekOfYear($day, $month, $year);
    
        if (($dayofweek % 7 == 0) && ($dayofweek != 0)) {
            if ($sidebyside) {
                echo '<th>' . $cal->getShareName() . '</th>';
            } else { 
                echo '</tr><tr>';
            }
        }
        if (mktime(0, 0, 0) == $dayStamp) {
            $style = 'today';
        } elseif (!empty($allevents[$dayStamp])) {
            $style = 'text';
        } else {
            $style = 'item';
        }

        echo '<td class="' . $style . '" height="100" width="14%" valign="top">';
        echo '<table cellspacing="0" cellpadding="1" width="100%"><tr><td>';

        $url = Horde::addParameter(Horde::applicationUrl('day.php'),
                                   'timestamp', $dayStamp);
        echo '<b><a class="day" href="' . $url . "\">&nbsp;$day&nbsp;</a></b>";

        if (($dayofweek % 7 == 0) && (($dayofweek != 0 || $startday == 0))) {
            $url = Horde::addParameter('week.php', 'week=' . $week);
            if ($month == 12 && $week == 1) {
                $url = Horde::addParameter($url, 'year=' . ($year + 1));
            } else {
                $url = Horde::addParameter($url, 'year=' . $year);
            }
            echo ' (' . Horde::link(Horde::applicationUrl($url), sprintf(_("Week %d"), $week)) . sprintf(_("Week&nbsp;%d"), $week) . '</a>)';
        }
        echo '</td>';

        if (Auth::getAuth() && !$print_view) {
            $url = Horde::addParameter(Horde::applicationUrl('addevent.php'),
                                       'timestamp', $timestamp);
            $url = Horde::addParameter($url, 'url', Horde::selfURL(true));
            echo '<td width="14%">' . Horde::link($url, _("Create a New Event")) . Horde::img('new.gif', _("Create a New Event"), 'align="right"') . '</a></td>';
        }

        echo '</tr></table>';

        if (!empty($allevents[$dayStamp]) &&
            count($allevents[$dayStamp])) {
            $cell = '<table cellspacing="0" cellpadding="1" width="100%">';
            foreach ($allevents[$dayStamp] as $event) {
                if (!$prefs->getValue('show_shared_side_by_side') || $event->getCalendar() == $id) {
                    $categoryColor = isset($colors[$event->getCalendar()][$event->getCategory()]) ? $colors[$event->getCalendar()][$event->getCategory()] : '#ccccff' ;
    
                    $cell .= '<tr><td class="month-eventbox" style="background-color: ' . $categoryColor . '; ' ;
                    $cell .= 'border-color: ' . Kronolith::borderColor($categoryColor) . '" ' ;
                    $cell .= 'onmouseover="javascript:style.backgroundColor=\'' . Kronolith::highlightColor($categoryColor) . '\'" ' ;
                    $cell .= 'onmouseout="javascript:style.backgroundColor=\'' . $categoryColor . '\'" ' ;
                    $cell .= 'valign="top">';
                    $cell .= $event->getLink($timestamp);
                    $cell .= '</td></tr>';
                }
            }

            $cell .= '</table>';
            echo $cell;
        }
    
        echo '</td>';
        $dayofweek++;
    }
}

echo '</tr></table>
</td></tr>';
echo Kronolith::buildCategoryLegend();
echo '</table>';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
