<?php

require_once HORDE_BASE . '/lib/MIME/Viewer/zip.php';

/**
 * The MIME_Viewer_zip class renders out the contents of ZIP files in HTML
 * format and allows downloading of extractable files.
 *
 * $Horde: imp/lib/MIME/Viewer/zip.php,v 1.17 2003/07/05 22:16:48 jan Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.17 $
 * @since   IMP 4.0
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_zip extends MIME_Viewer_zip {

    /**
     * The content type of the part.
     *
     * @var string $_contentType
     */
    var $_contentType = 'text/html';

    /**
     * The IMP_Contents object, needed for the _callback() function.
     *
     * @var object IMP_Contents $_contents
     */
    var $_contents;

    /**
     * Render out the currently set contents.
     *
     * @access public
     *
     * @param array $params  An array with a reference to a  MIME_Contents
     *                       object.
     *
     * @return string  Either the list of zip files or the data of an
     *                 individual zip file.
     */
    function render($params)
    {
        $contents =& $params[0];

        $data = $this->mime_part->getContents();
        $text = '';

        /* Send the requested file. Its position in the zip archive is
           located in 'zip_attachment'. */
        if (Horde::getFormData('zip_attachment')) {
            require_once HORDE_BASE . '/lib/Compress.php';
            $zip = &Horde_Compress::singleton('zip');
            $fileKey = Horde::getFormData('zip_attachment') - 1;
            $zipInfo = $zip->decompress($data, array('action' => HORDE_COMPRESS_ZIP_LIST));
            /* Verify that the requested file exists. */
            if (array_key_exists($fileKey, $zipInfo)) {
                $text = $zip->decompress($data, array('action' => HORDE_COMPRESS_ZIP_DATA, 'info' => &$zipInfo, 'key' => $fileKey));
                if (empty($text)) {
                    $text = '<pre>' . _("Could not extract the requested file from the Zip archive.") . '</pre>';
                } else {
                    $this->mime_part->setType('application/octet-stream');
                    $this->mime_part->setName($zipInfo[$fileKey]['name']);
                }
            } else {
                $text = '<pre>' . _("The requested file does not exist in the Zip attachment.") . '</pre>';
            }
        } else {
            $this->_contents = $contents;
            $text = parent::_render($data, array($this, '_callback'));
        }

        return $text;
    }

    /**
     * Return the content-type.
     *
     * @access public
     *
     * @return string  The content-type of the output.
     */
    function getType()
    {
        return $this->_contentType;
    }

    /**
     * The function to use as a callback to parent::_render().
     *
     * @access private
     *
     * @param integer $key  The position of the file in the zip archive.
     * @param array $val    The information array for the archived file.
     *
     * @return string  The content-type of the output.
     */
    function _callback($key, $val)
    {
        $name = str_replace('&nbsp;', '', $val['name']);
        if (!empty($val['size']) && (strstr($val['attr'], 'D') === false) &&
            ((($val['_method'] == 0x8) && Horde::extensionExists('zlib')) ||
            ($val['_method'] == 0x0))) {
            $old_name = $this->mime_part->getName();
            $this->mime_part->setName($name);
            $val['name'] = str_replace($name, $this->_contents->linkView($this->mime_part, 'download_render', $name, array('jstext' => sprintf(_("View %s"), $name), 'class' => 'fixed', 'viewparams' => array('zip_attachment' => (urlencode($key) + 1)))), $val['name']);
            $this->mime_part->setName($old_name);
        }

        return $val;
    }

}
