/*
    This file is part of KOrganizer.
    Copyright (c) 2000 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef KORGANIZER_PART_H
#define KORGANIZER_PART_H

#include <kparts/browserextension.h>
#include <kparts/factory.h>

#include "korganizersynciface.h"

class KInstance;
class KAboutData;
class KOrganizerBrowserExtension;
class KProcess;

class CalendarView;

class KOrganizerFactory : public KParts::Factory
{
    Q_OBJECT
  public:
    KOrganizerFactory();
    virtual ~KOrganizerFactory();

    virtual KParts::Part* createPartObject(QWidget *parentWidget, const char *name,
    QObject* parent = 0, const char* name1 = 0,
    const char* classname = "QObject",
    const QStringList &args = QStringList());

    static KInstance *instance();

  private:
    static KInstance *s_instance;
    static KAboutData *s_about;
};

class KOrganizerPart: public KParts::ReadOnlyPart, virtual public KOrganizerSyncIface
{
    Q_OBJECT
  public:
    KOrganizerPart(QWidget *parentWidget, const char *widgetName,
                   QObject *parent, const char *name, const QStringList& );
    virtual ~KOrganizerPart();

    // Groupware-syncing
    virtual void pullSyncData( QString filename );
    virtual void pushSyncData( QString filename );

  public slots:
    /** Turn on Groupware-based communication */
    virtual void slotSetGroupwareCommunicationEnabled( QObject* );
    /** Load data into the calendar; this method is called when the
        KOrganizer part is embedded into KMail. It loads the data from
        the special KMail folders into KOrganizer. The following
        methods do this for particular event types.
    */
    virtual void slotRefreshAll( const QStringList& events,
                                 const QStringList& notes,
                                 const QStringList& tasks );
    virtual void slotRefreshNotes( const QStringList& notes );

    /** Make sure a given time span is visible in the Calendar */
    virtual void slotUpdateView(const QDateTime&, const QDateTime&);

    /** Add a event request in from an external source */
    virtual void slotEventRequest( const QCString& receiver,
				   const QString& vCalIn,
                                   bool& vCalInOK,
                                   QString& choice,
                                   QString& vCalOut,
                                   bool& vCalOutOK );

    /** Create an answer for a resource request */
    virtual void slotResourceRequest( const QValueList<QPair<QDateTime, QDateTime> >& busy,
                                      const QCString& resource,
                                      const QString& vCalIn,
                                      bool& vCalInOK,
                                      QString& vCalOut,
                                      bool& vCalOutOK, bool& isFree,
                                      QDateTime& start, QDateTime& end );

    /** Add a event that was already accepted by the user,
        return acceptance vCal data to be send back to the invitor. */
    virtual void slotAcceptedEvent( bool tentative, const QCString& receiver,
				    const QString& vCalIn,
                                    bool& vCalInOK, QString& vCalOut,
                                    bool& vCalOutOK );
    /** This method is called when the user has an invitation in the
        calling application and wants to reject it. */
    virtual void slotRejectedEvent( const QCString& receiver,
				    const QString& vCalIn, bool& vCalInOK,
                                    QString& vCalOut, bool& vCalOutOK );

    /** This method is called when the user has invited people to a
        meeting and is now receiving the answers.
    */
    virtual void slotIncidenceAnswer( const QCString& sender, const QString& vCalIn,
				      QString& vCalOut );

    /**
       This slot is called when the user wants to publish its free/busy schedule.
    */
    virtual void slotPublishFreeBusy();

    virtual void slotPrint();
    virtual void slotPrintPreview();
    virtual void slotFileMerge();
    virtual void slotFileArchive();
    virtual void slotExportICalendar();
    virtual void slotExportVCalendar();
    virtual void slotPurgeCompleted();
    virtual void slotShowWhatsNextView();
    virtual void slotShowListView();
    virtual void slotShowDayView();
    virtual void slotShowWorkWeekView();
    virtual void slotShowWeekView();
    virtual void slotShowNextXView();
    virtual void slotShowMonthView();
    virtual void slotShowTodoView();
    virtual void slotShowJournalView();
    virtual void slotShowNotesView();
    virtual void slotShowCalendarView();
    virtual void slotUpdate();
    virtual void slotGoPrevious();
    virtual void slotGoNext();
    virtual void slotGoToday();
    virtual void slotAppointment_new();
    virtual void slotNewTodo();
    virtual void slotSubTodo();
    virtual void slotDeleteIncidence();
    virtual void slotEditIncidence();
    virtual void slotTodo_unsub();
    virtual void slotConfigure();
    virtual void slotConfigureDateTime();
    virtual void slotEditFilters();
    virtual void slotShowCategoryEditDialog();
    virtual void slotNewNote();

  signals:
    void signalKOrganizerShow( bool );

  protected:
    virtual bool openFile();
    virtual void ensureWeAreVisible();

private slots:
    void slotConfigureDateTimeFinished( KProcess* proc );


  private:
    CalendarView *widget;
    KOrganizerBrowserExtension *m_extension;
};

class KOrganizerBrowserExtension : public KParts::BrowserExtension
{
    Q_OBJECT
    friend class KOrganizerPart;
  public:
    KOrganizerBrowserExtension(KOrganizerPart *parent);
    virtual ~KOrganizerBrowserExtension();
};

#endif
