import { h } from "preact";
import { useTranslationContext } from "../index.browser.js";

/**
 * Common pagination footer for tables.
 * 
 * @param param0 
 * @returns 
 */
export function Pagination({
  onFirstPage,
  onNext,
}: {
  onFirstPage?: () => void;
  onNext?: () => void;
}) {
  const { i18n } = useTranslationContext();
  return (
    <nav
      class="flex items-center justify-between border-t border-gray-200 bg-white px-4 py-3 sm:px-6 rounded-lg"
      aria-label="Pagination"
    >
      <div class="flex flex-1 justify-between sm:justify-end">
        <button
          class="relative disabled:bg-gray-100 disabled:text-gray-500 inline-flex items-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 ring-1 ring-inset ring-gray-300 hover:bg-gray-50 focus-visible:outline-offset-0"
          disabled={!onFirstPage}
          onClick={onFirstPage}
        >
          <i18n.Translate>First page</i18n.Translate>
        </button>
        <button
          class="relative disabled:bg-gray-100 disabled:text-gray-500 ml-3 inline-flex items-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 ring-1 ring-inset ring-gray-300 hover:bg-gray-50 focus-visible:outline-offset-0"
          disabled={!onNext}
          onClick={onNext}
        >
          <i18n.Translate>Next</i18n.Translate>
        </button>
      </div>
    </nav>
  );
}
