/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_unit.h
 * @brief implementation of the insert_unit function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_INSERT_UNIT_H
#define PG_INSERT_UNIT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Insert a measurement unit definition.
 *
 * @param cls closure
 * @param instance_id instance to insert unit for
 * @param ud unit definition to store (unit_serial ignored)
 * @param[out] no_instance set to true if the instance is unknown
 * @param[out] conflict set to true if a conflicting unit already exists
 * @param[out] unit_serial set to the generated serial on success (or the existing serial for idempotent inserts)
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_insert_unit (void *cls,
                    const char *instance_id,
                    const struct TALER_MERCHANTDB_UnitDetails *ud,
                    bool *no_instance,
                    bool *conflict,
                    uint64_t *unit_serial);

#endif
