/*
  This file is part of TALER
  Copyright (C) 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-exchange-httpd_blinding-prepare.h
 * @brief Handle /blinding-prepare requests
 * @author Özgür Kesim
 */
#ifndef TALER_EXCHANGE_HTTPD_BLINDING_PREPARE_H
#define TALER_EXCHANGE_HTTPD_BLINDING_PREPARE_H

#include <microhttpd.h>
#include "taler-exchange-httpd.h"

/**
 * Handle a "/blinding-prepare" request.
 *
 * @param rc request context
 * @param root uploaded JSON data
 * @param args empty array
 * @return MHD result code
  */
MHD_RESULT
TEH_handler_blinding_prepare (struct TEH_RequestContext *rc,
                              const json_t *root,
                              const char *const args[]);

#endif
