/*
  This file is part of Gnu Taler
  Copyright (C) 2012-2025 Taler Systems Sa

  Gnu Taler is free software: you can redistribute it and/or modify it
  under the terms of the Gnu Lesser General Public License as published
  by the Free Software Foundation, either version 3 of the License,
  or (at your option) any later version.

  Gnu Taler is distributed in the hope that it will be useful, but
  Without Any Warranty; without even the implied warranty of
  Merchantability or Fitness For A Particular Purpose.  See the Gnu
  Lesser General Public License for more details.

  You should have received a copy of the Gnu Lesser General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  Spdx-License-Identifier: Lgpl3.0-or-later

  Note: the Lgpl does not apply to all components of Gnu Taler,
  but it does apply to this file.
 */

package gana

const (


  /**
   * Initialize or update the status of an Aml key for an Aml officer (Gnu Taler)
   */
  TalerSignaturePurposeMasterAmlKey = 1017


  /**
   * Affirm wiring of exchange profits to operator account. (Gnu Taler)
   */
  TalerSignaturePurposeMasterDrainProfit = 1018


  /**
   * Signature affirming a partner configuration for wads. (Gnu Taler)
   */
  TalerSignaturePurposeMasterPartnerDetails = 1019


  /**
   * The given revocation key was revoked and must no longer be used. (Gnu Taler)
   */
  TalerSignaturePurposeMasterSigningKeyRevoked = 1020


  /**
   * Add payto Uri to the list of our wire methods. (Gnu Taler)
   */
  TalerSignaturePurposeMasterAddWire = 1021


  /**
   * Signature over global set of fees charged by the exchange. (Gnu Taler)
   */
  TalerSignaturePurposeMasterGlobalFees = 1022


  /**
   * Remove payto Uri from the list of our wire methods. (Gnu Taler)
   */
  TalerSignaturePurposeMasterDelWire = 1023


  /**
   * Purpose for signing public keys signed by the exchange master key. (Gnu Taler)
   */
  TalerSignaturePurposeMasterSigningKeyValidity = 1024


  /**
   * Purpose for denomination keys signed by the exchange master key. (Gnu Taler)
   */
  TalerSignaturePurposeMasterDenominationKeyValidity = 1025


  /**
   * Add an auditor to the list of our auditors. (Gnu Taler)
   */
  TalerSignaturePurposeMasterAddAuditor = 1026


  /**
   * Remove an auditor from the list of our auditors. (Gnu Taler)
   */
  TalerSignaturePurposeMasterDelAuditor = 1027


  /**
   * Fees charged per (aggregate) wire transfer to the merchant. (Gnu Taler)
   */
  TalerSignaturePurposeMasterWireFees = 1028


  /**
   * The given revocation key was revoked and must no longer be used. (Gnu Taler)
   */
  TalerSignaturePurposeMasterDenominationKeyRevoked = 1029


  /**
   * Signature where the Exchange confirms its Iban details in the /wire response. (Gnu Taler)
   */
  TalerSignaturePurposeMasterWireDetails = 1030


  /**
   * Set the configuration of an extension (age-restriction or peer2peer) (Gnu Taler)
   */
  TalerSignaturePurposeMasterExtension = 1031


  /**
   * Purpose for the state of a reserve, signed by the exchange's signing key. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeReserveStatus = 1032


  /**
   * Signature where the Exchange confirms a deposit request. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmDeposit = 1033


  /**
   * Signature where the exchange (current signing key) confirms the no-reveal index for cut-and-choose and the validity of the melted coins. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmMelt = 1034


  /**
   * Signature where the Exchange confirms the full /keys response set. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeKeySet = 1035


  /**
   * Signature where the Exchange confirms the /track/transaction response. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmWire = 1036


  /**
   * Signature where the Exchange confirms the /wire/deposit response. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmWireDeposit = 1037


  /**
   * Signature where the Exchange confirms a refund request. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmRefund = 1038


  /**
   * Signature where the Exchange confirms a recoup. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmRecoup = 1039


  /**
   * Signature where the Exchange confirms it closed a reserve. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeReserveClosed = 1040


  /**
   * Signature where the Exchange confirms a recoup-refresh operation. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmRecoupRefresh = 1041


  /**
   * Signature where the Exchange confirms that it does not know a denomination (hash). (Gnu Taler)
   */
  TalerSignaturePurposeExchangeAffirmDenomUnknown = 1042


  /**
   * Signature where the Exchange confirms that it does not consider a denomination valid for the given operation at this time. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeAffirmDenomExpired = 1043


  /**
   * Signature by which the exchange affirms that a purse was created with a certain amount deposited into it. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmPurseCreation = 1045


  /**
   * Signature by which the exchange affirms that a purse was merged into a reserve with a certain amount in it. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmPurseMerged = 1046


  /**
   * Purpose for the state of a purse, signed by the exchange's signing key. (Gnu Taler)
   */
  TalerSignaturePurposeExchangePurseStatus = 1047


  /**
   * Signature by which the exchange attests identity attributes of a particular reserve owner. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeReserveAttestDetails = 1048


  /**
   * Signature by which the exchange confirms that a purse expired and a coin was refunded. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmPurseRefund = 1049


  /**
   * Signature where the Exchange confirms an (age-)withdraw. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeConfirmWithdraw = 1050


  /**
   * Signature where the auditor confirms that he is aware of certain denomination keys from the exchange. (Gnu Taler)
   */
  TalerSignaturePurposeAuditorExchangeKeys = 1064


  /**
   * Signature where the merchant confirms a contract (to the customer). (Gnu Taler)
   */
  TalerSignaturePurposeMerchantContract = 1101


  /**
   * Signature where the merchant confirms a refund (of a coin). (Gnu Taler)
   */
  TalerSignaturePurposeMerchantRefund = 1102


  /**
   * Signature where the merchant confirms that he needs the wire transfer identifier for a deposit operation. (Gnu Taler)
   */
  TalerSignaturePurposeMerchantTrackTransaction = 1103


  /**
   * Signature where the merchant confirms that the payment was successful (Gnu Taler)
   */
  TalerSignaturePurposeMerchantPaymentOk = 1104


  /**
   * Signature where the merchant confirms its own (salted) wire details (not yet really used). (Gnu Taler)
   */
  TalerSignaturePurposeMerchantWireDetails = 1107


  /**
   * Signature where the merchant issues a token by blindly signing it. Signed with the token issue private key. (Gnu Taler)
   */
  TalerSignaturePurposeMerchantTokenIssue = 1108


  /**
   * Signature where the reserve key confirms a withdraw request. Signed with the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveWithdraw = 1200


  /**
   * Signature made by the wallet of a user to confirm a deposit of a coin. (Gnu Taler)
   */
  TalerSignaturePurposeWalletCoinDeposit = 1201


  /**
   * Signature using a coin key confirming the melting of a coin. Signed with the coin's private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletCoinMelt = 1202


  /**
   * Signature using a coin key requesting recoup. Signed with the coin's private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletCoinRecoup = 1203


  /**
   * Signature using a coin key authenticating link data. Signed with the old coin's private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletCoinLink = 1204


  /**
   * Signature using a reserve key by which a wallet requests a payment target Uuid for itself. Signs over just a purpose (no body), as the signature only serves to demonstrate that the request comes from the wallet controlling the private key, and not some third party. (Gnu Taler)
   */
  TalerSignaturePurposeWalletAccountSetup = 1205


  /**
   * Signature using a coin key requesting recoup-refresh. Signed with the coin private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletCoinRecoupRefresh = 1206


  /**
   * Signature using a age restriction key for attestation of a particular age/age-group. (Gnu Taler)
   */
  TalerSignaturePurposeWalletAgeAttestation = 1207


  /**
   * Request full or partial reserve history. Signed with the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveHistory = 1208


  /**
   * Request full or partial coin history. Signed with the coin private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletCoinHistory = 1209


  /**
   * Request purse creation (without reserve). Signed by the purse private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletPurseCreate = 1210


  /**
   * Request coin to be deposited into a purse. Signed with the coin private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletPurseDeposit = 1211


  /**
   * Request purse status. Signed with the purse private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletPurseStatus = 1212


  /**
   * Request purse to be merged with a reserve. Signed with the purse private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletPurseMerge = 1213


  /**
   * Request purse to be merged with a reserve. Signed by the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletAccountMerge = 1214


  /**
   * Request account to be closed. Signed with the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveClose = 1215


  /**
   * Associates encrypted contract with a purse. Signed with the purse private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletPurseEcontract = 1216


  /**
   * Request reserve to be kept open. Signed with the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveOpen = 1217


  /**
   * Request coin to be used to pay for reserve to be kept open. Signed with the coin private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveOpenDeposit = 1218


  /**
   * Request attestation about reserve owner. Signed by the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveAttestDetails = 1219


  /**
   * Signature by which a wallet requests a purse to be deleted. (Gnu Taler)
   */
  TalerSignaturePurposeWalletPurseDelete = 1220


  /**
   * Signature where the reserve key confirms an age-withdraw request. Signed with the reserve private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletReserveAgeWithdraw = 1221


  /**
   * Signature where the token use key confirms the usage of a token on a pay request. Signed with the token use private key. (Gnu Taler)
   */
  TalerSignaturePurposeWalletTokenUse = 1222


  /**
   * Signature on a denomination key announcement. (Gnu Taler)
   */
  TalerSignaturePurposeSmRsaDenominationKey = 1250


  /**
   * Signature on an exchange message signing key announcement. (Gnu Taler)
   */
  TalerSignaturePurposeSmSigningKey = 1251


  /**
   * Signature on a denomination key announcement. (Gnu Taler)
   */
  TalerSignaturePurposeSmCsDenominationKey = 1252


  /**
   * EdDsa test signature. (Gnu Taler)
   */
  TalerSignaturePurposeClientTestEddsa = 1302


  /**
   * EdDsa test signature. (Gnu Taler)
   */
  TalerSignaturePurposeExchangeTestEddsa = 1303


  /**
   * Signature by which an Aml officer signs an Aml decision. (Gnu Taler)
   */
  TalerSignaturePurposeAmlDecision = 1350


  /**
   * Signature by which an Aml officer requests Aml data. (Gnu Taler)
   */
  TalerSignaturePurposeAmlQuery = 1351


  /**
   * Signature by which an account owner authorizes access to a Kyc operation. (Gnu Taler)
   */
  TalerSignaturePurposeKycAuth = 1360


  /**
   * EdDsa signature for a policy upload. (Gnu Taler)
   */
  TalerSignaturePurposeAnastasisPolicyUpload = 1400


  /**
   * EdDsa signature for a backup upload. (Gnu Taler)
   */
  TalerSignaturePurposeSyncBackupUpload = 1450


  /**
   * Signature over messages to delete in the mailbox service (Gnu Taler)
   */
  TalerSignaturePurposeMailboxMessagesDelete = 1551


  /**
   * Signature for mailbox registration request (Gnu Taler)
   */
  TalerSignaturePurposeMailboxRegister = 1552
)
